<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class wesper_section_cart extends Widget_Base {

    public function get_name() {
        return 'wesper-cart';
    }

    public function get_title() {
        return esc_html__( 'Jelly Cart', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-basket-medium jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'mini_cart_content_section',
            [
                'label' => __( 'Mini Cart', 'wesper' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        
        $this->add_control(
            'jl_btn_icons',
            [
                'label' =>esc_html__( 'Icon', 'wesper' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'jl_btn_icon',
                'label_block' => true,
                'default' => [
                    'value' => '',
                ]
            ]
        );            

        $this->end_controls_section();

        $this->start_controls_section(
            'mini_cart_button_section',
            [
                'label' => __( 'Mini Cart Style', 'wesper' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'icon_menu_height',
            [
                'label' => __( 'Height', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'size' => '90',
                    'unit' => 'px'
                ],
                'selectors' => [                    
                    '{{WRAPPER}} .jl_h_cart' => 'height: {{SIZE}}px',
                ]                
            ]
        );   

        $this->add_responsive_control(
            'icons_margin',
            [
                'label'      => __( 'Margin', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jl_h_cart' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icons_padding',
            [
                'label'      => __( 'Padding', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jl_h_cart' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Icons Font Size', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .jl_i_cart i' => 'font-size: {{SIZE}}px',
                    '{{WRAPPER}} .jl_i_cart svg' => 'width: {{SIZE}}px; height:auto;',                    
                ]                
            ]
        );    

        $this->add_responsive_control(
            'icon_space',
            [
                'label' => __( 'Icons Space', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .jl_i_cart i' => 'margin-right: {{SIZE}}px',
                    '{{WRAPPER}} .jl_i_cart svg' => 'margin-right: {{SIZE}}px',
                ]                
            ]
        );      

        $this->add_responsive_control(
            'product_list_space',
            [
                'label' => __( 'Product list position', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .jl-hshow' => 'right: {{SIZE}}px !important',
                ]                
            ]
        );      

        $this->add_control(
            'jl_btn_mobile_color',
            [
                'label' =>esc_html__( 'Color', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .jl_i_cart i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .jl_i_cart svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->add_control(
            'jl_btn_mobile_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl_i_cart i' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .jl_i_cart svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->add_control(
            'jl_mobile_color_hover',
            [
                'label' =>esc_html__( 'Color Hover', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .jl_i_cart:hover i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .jl_i_cart:hover svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'jl_mobile_color_hover_dark',
            [
                'label' =>esc_html__( 'Color hover dark mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl_i_cart:hover i' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .jl_i_cart:hover svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'jl_bgnum',
            [
                'label' =>esc_html__( 'Background number', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .jl_i_cart .jl_count_cart' => 'background: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'jl_bgnum_dark',
            [
                'label' =>esc_html__( 'Background number dark mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl_i_cart .jl_count_cart' => 'background: {{VALUE}} !important;',                    
                ],
            ]
        );

        $this->add_control(
            'jl_colornum',
            [
                'label' =>esc_html__( 'Color number', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .jl_i_cart .jl_count_cart' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );   

        $this->add_control(
            'jl_colornum_dark',
            [
                'label' =>esc_html__( 'Color number dark mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl_i_cart .jl_count_cart' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );

        $this->add_control(
            'sub_menu_div_color',
            [
                'label'     => esc_html__( 'Divider line Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_div_color_dark',
            [
                'label'     => esc_html__( 'Divider line Color dark mode', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .woocommerce-mini-cart__total' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_bg_color',
            [
                'label'     => esc_html__( 'Product background color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jl-hshow' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_bg_color_dark',
            [
                'label'     => esc_html__( 'Product background color dark mode', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl-hshow' => 'background: {{VALUE}};',
                ],
            ]
        );

                
        $this->add_control(
            'sub_menu_normal_color',
            [
                'label'     => esc_html__( 'Product color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} li.woocommerce-mini-cart-item a:not(.remove)' => 'color: {{VALUE}} !important;;',
                    '{{WRAPPER}} .woocommerce ul.product_list_widget .woocommerce-mini-cart-item .quantity' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .jl-hshow' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .woocommerce a.remove:before' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .woocommerce-mini-cart__total' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_normal_color_dark',
            [
                'label'     => esc_html__( 'Product color dark mode', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '.options_dark_skin {{WRAPPER}} li.woocommerce-mini-cart-item a:not(.remove)' => 'color: {{VALUE}} !important;;',
                    '.options_dark_skin {{WRAPPER}} .woocommerce ul.product_list_widget .woocommerce-mini-cart-item .quantity' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .jl-hshow' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .woocommerce a.remove:before' => 'color: {{VALUE}} !important;',
                    '.options_dark_skin {{WRAPPER}} .woocommerce-mini-cart__total' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'jl_show_border_menu',
            [
                'label' => esc_html__( 'cart border', 'wesper' ),
                'type' => Controls_Manager::SWITCHER,                                
            ]
            );
            
        $this->add_responsive_control(
            'sub_menu_border',
            [
                'label' => esc_html__( 'cart border size', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ]                        
                ],
                'default' => [
                'unit' => 'px',
                'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl-hshow' => 'border: {{SIZE}}{{UNIT}} solid; box-shadow: unset;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );        

        $this->add_control(
            'sub_menu_border_color',
            [
                'label'     => esc_html__( 'Border color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '{{WRAPPER}} .jl-hshow, {{WRAPPER}} .jl-hshow .mini_cart_item img' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sub_menu_border_color_dark',
            [
                'label'     => esc_html__( 'Border color dark mode', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '.options_dark_skin {{WRAPPER}} .jl-hshowm, .options_dark_skin {{WRAPPER}} .jl-hshow .mini_cart_item img' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );


        $this->end_controls_section();
        

    }
    protected function render(){

        if ( ! function_exists( 'WC' ) ) {
            $this->show_wc_missing_alert();
            return;
        }
        if ( ! class_exists( 'Woocommerce' ) || ! function_exists( 'wc_get_cart_url' ) || ! function_exists( 'is_cart' ) || is_cart() ) {
            return false;
        }
        $settings = $this->get_settings();        
        ?>

        <div class="jl_h_cart nav-cart is-hover">
        <a class="jl_l_cart cart-link" href="<?php echo esc_url( wc_get_cart_url() ) ?>" title="<?php echo esc_attr( 'view cart', 'wesper' ); ?>">
            <span class="jl_i_cart">
                <?php if (empty($settings['jl_btn_icons']['value'])) {?>
                <i class="jli-bag"></i>
                <?php }else{
                            $migrated = isset( $settings['__fa4_migrated']['jl_btn_icons'] );
                            $is_new = empty( $settings['jl_btn_icon'] );
                            if ( $is_new || $migrated ) {
                                Icons_Manager::render_icon( $settings['jl_btn_icons'], [ 'aria-hidden' => 'true' ] );
                            }else{
                                ?>
                                <i class="<?php echo esc_attr($settings['jl_btn_icon']); ?>" aria-hidden="true"></i>
                                <?php
                            }
                        }
                    ?>
                <em class="cart-counter jl_count_cart">
                    <?php
                    if ( !empty(WC()->cart->cart_contents_count) ){
                        echo esc_attr( WC()->cart->cart_contents_count );
                    }else{
                        echo 0;
                    }
                    ?>
                </em>
            </span>
        </a>
        <?php if ( function_exists( 'woocommerce_mini_cart' ) ): ?>
            <div class="jl-nav-cart jl-hshow">
                <div class="jl-cart-wrap woocommerce">
                    <div class="widget_shopping_cart_content">
                        <?php (( WC()->cart != '' ) ? woocommerce_mini_cart() : '' ); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
</div>

    
    <?php
    }
    public function show_wc_missing_alert() {
        if ( current_user_can( 'activate_plugins' ) ) {
            printf(
                '<div %s>%s</div>',
                'style="margin: 1rem;padding: 1rem 1.25rem;border-left: 5px solid #f5c848;color: #856404;background-color: #fff3cd;"',
                __( 'WooCommerce is missing! Please install and activate WooCommerce.', 'wesper' )
                );
        }
    }
}