<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class wesper_feature_carousel extends Widget_Base {

  public $base;

    public function get_name() {
        return 'wesper-feature-carousel';
    }

    public function get_title() {
        return esc_html__( 'Feature Carousel', 'wesper' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {       

    $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'wesper'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'wesper'),
              'description' => esc_html__( 'Choose post type to display posts', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'wesper'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'wesper' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'wesper' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'wesper'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'wesper' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'wesper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'wesper'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
               

        $this->add_control(
      'posts_per_page',
      array(
        'label'       => esc_html__( 'Posts per Page', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '4'
      )
    );

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'wesper' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'wesper' ),
                        'gallery'        => esc_html__( 'Gallery', 'wesper' ),
                        'video'        => esc_html__( 'Video', 'wesper' ),
                        'audio'        => esc_html__( 'Audio', 'wesper' ),
                        'quote'        => esc_html__( 'Quote', 'wesper' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );    

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'wesper' ),                        
                  'rand'      =>esc_html__( 'Random', 'wesper' ),
                  'update'      =>esc_html__( 'Latest updated', 'wesper' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'wesper' ),
                  'author'      =>esc_html__( 'Author', 'wesper' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'wesper' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'wesper' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'wesper' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'wesper' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'wesper' ),
              ],
            ]
        );                   

    $this->end_controls_section();        
     
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'wesper' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );        

       $this->add_control(
            'car_type',
            [
                'label'     =>esc_html__( 'Carousel style', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'carousel1',
                'options'   => [
                        'carousel1'      =>esc_html__( 'Classic Style', 'wesper' ),
                        'carousel2'      =>esc_html__( 'Overlay Style', 'wesper' ),
                        'carousel3'      =>esc_html__( 'Overlay + Background', 'wesper' ),
                        'carousel4'      =>esc_html__( 'Classic + Background', 'wesper' ),
                    ],
            ]
        ); 

        $this->add_control(
          'jl_cus_img',
          [
              'label'     =>esc_html__( 'Image size', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => '',
              'options'   => [
                      ''      =>esc_html__( 'Default image size', 'wesper' ),      
                      'wesper_large'      =>esc_html__( '1600 x 0', 'wesper' ),
                      'wesper_medium'      =>esc_html__( '1100 x 0', 'wesper' ),
                      'wesper_small'      =>esc_html__( '150 x 150', 'wesper' ),
                      'wesper_layouts'      =>esc_html__( '680 x 580', 'wesper' ),
                      'wesper_list'      =>esc_html__( '600 x 0', 'wesper' ),
                  ],
          ]
      ); 

        $this->add_responsive_control(
        'sl_height',
        [
            'label' => __( 'Carousel height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_caropt_w' => '--jlc-car-height: {{SIZE}}%;',
            ]            
        ]
      );

      $this->add_control(
        'jl_en_bg',
        [
            'label' => esc_html__( 'Enable background text style', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,  
            'selectors' => [
              '{{WRAPPER}} .jl_cgrid_layout .jl_fe_text' => 'position: relative; margin-left: auto; margin-right: auto;',
          ],
          'condition' => [
            'car_type' => [ 'carousel1']
          ]
        ]
    );
    
    $this->add_responsive_control(
      'captions_padding_space',
      [
          'label'      => __( 'Padding caption', 'wesper' ),
          'type'       => Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px', '%'],
          'default'    => [
              'top'      => '25',
              'right'    => '20',
              'bottom'   => '0',
              'left'     => '20',
              'unit'     => 'px',
              'isLinked' => false
          ],
          'selectors'  => [
              '{{WRAPPER}} .jl_cgrid_layout .jl_fe_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
          ],
          'condition' => [
              'jl_en_bg!'    => ''
          ]
      ]
    );

    $this->add_responsive_control(
      'caption_offset_top',
      [
          'label' => __( 'Caption offset top space', 'wesper' ),
          'type' => Controls_Manager::SLIDER,
          'default' => [
            'size' => -60,
        ],
          'range' => [
              'px' => [
                  'min' => -300,
                  'max' => 500,
                  'step' => 1,
              ]
          ],
          'selectors' => [            
          '{{WRAPPER}} .jl_cgrid_layout .jl_fe_text' => 'margin-top: {{SIZE}}px !important;',
          ],
          'condition' => [
              'jl_en_bg!'    => ''
          ]
      ]
    );

    $this->add_responsive_control(
      'caption_offset_h',
      [
          'label' => __( 'Caption offset left/right', 'wesper' ),
          'type' => Controls_Manager::SLIDER,                        
          'default' => [
            'size' => 40,
        ],
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 500,
                  'step' => 1,
              ]
          ],
          'selectors' => [            
          '{{WRAPPER}} .jl_cgrid_layout .jl_fe_text' => 'max-width: calc(100% - {{SIZE}}px) !important;',
          ],
          'condition' => [
              'jl_en_bg!'    => ''
          ]
      ]
    );

    $this->add_control(
      'titlebg',
      [
        'label' => __( 'Title bg color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
            '{{WRAPPER}} .jl_cgrid_layout .jl_fe_text' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'jl_en_bg!'    => ''
        ]
      ]
    );

    $this->add_control(
      'titlebg_dark',
      [
        'label' => __( 'Title bg color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#101010',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_fe_text' => 'background: {{VALUE}}',            
        ],
        'condition' => [
          'jl_en_bg!'    => ''
        ]
      ]
    );

    $this->add_control(
      'sl_1cap_color',
      [
        'label' => __( 'Caption color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .jl_cgrid_layout .jl_fe_title' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .jl_cgrid_layout .jl_fe_text a' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .jl_cgrid_layout .jl_fe_text .jl_fe_title:hover a' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .jl_cgrid_layout .jl_post_meta span' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .jl_cgrid_layout .jl_post_meta a' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .jl_cgrid_layout .jl_post_meta a:hover' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} .jl_cgrid_layout .jl_fe_des' => 'color: {{VALUE}} !important'
        ],
        'condition' => [
          'car_type' => [ 'carousel1']
        ]
      ]
    );

      $this->add_control(
      'sl_1cap_color_dark',
      [
        'label' => __( 'Caption dark mode color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_fe_title' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_fe_text a' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_fe_text .jl_fe_title:hover a' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_post_meta span' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_post_meta a' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_post_meta a:hover' => 'color: {{VALUE}} !important',
            '.options_dark_skin {{WRAPPER}} .jl_cgrid_layout .jl_fe_des' => 'color: {{VALUE}} !important'
        ],
        'condition' => [
          'car_type' => [ 'carousel1']
        ]
      ]
    );

      $this->add_responsive_control(
        'car_padding',
        [
            'label' => __( 'Carousel overlay padding', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_caropt_w' => '--jlc-padding: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
            'car_type' => [ 'carousel2', 'carousel3', 'carousel4' ]
            ]
        ]
      );

      $this->add_responsive_control(
        'car_cap_padding',
        [
            'label' => __( 'Carousel caption padding', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_caropt_w' => '--jlc-cap-padding: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
            'car_type' => [ 'carousel3' ]
            ]
        ]
      );

      $this->add_control(
        'jl_gradient_ov',
        [
            'label' => esc_html__( 'Enable gradient background', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => '',
            'selectors' => [
              '{{WRAPPER}} .jl_ov_el .jl_imgl' => 'background: transparent !important; background-image: repeating-linear-gradient(0deg, #000, transparent) !important;',
            ],
            'condition' => [
              'car_type' => [ 'carousel2' ]
              ]
        ]
    );     

      $this->add_control(
        'sl_ov_bg',
        [
          'label' => __( 'Overlay background', 'wesper' ),
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '{{WRAPPER}} .jl_ov_el .jl_imgl' => 'background: {{VALUE}}',
          ],                
          'condition' => [
                    'jl_gradient_ov!' => ''
          ]
        ]
      );

      $this->add_responsive_control(
        'jl_bg_opacity',
        [
            'label' => __( 'Opacity Overlay', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1,
                    'step' => 0.1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_ov_el .jl_imgl' => 'opacity: {{SIZE}}',            
            ],                
            'condition' => [
                      'jl_gradient_ov!' => ''
            ]
        ]
    ); 

      $this->add_control(
      'sl_cap_bg',
      [
        'label' => __( 'Caption background', 'wesper' ),
        'type' => Controls_Manager::COLOR,  
        'default' => '#fff1f1',      
        'selectors' => [
            '{{WRAPPER}} .jl_caropt_w' => '--jl-cap-bg: {{VALUE}}',
        ],
        'condition' => [
            'car_type' => [ 'carousel3', 'carousel4' ]
        ]
      ]
    );

      $this->add_control(
      'sl_cap_bg_dark',
      [
        'label' => __( 'Caption dark mode background', 'wesper' ),
        'type' => Controls_Manager::COLOR,   
        'default' => '#383838',     
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_caropt_w' => '--jl-cap-bg: {{VALUE}}',
        ],
        'condition' => [
            'car_type' => [ 'carousel3', 'carousel4' ]
        ]
      ]
    );

      $this->add_control(
      'sl_cap_color',
      [
        'label' => __( 'Caption color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jl_caropt_w' => '--jl-cap-color: {{VALUE}}',
        ],
        'condition' => [
            'car_type' => [ 'carousel3', 'carousel4' ]
        ]
      ]
    );

      $this->add_control(
      'sl_cap_color_dark',
      [
        'label' => __( 'Caption dark mode color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#fff',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_caropt_w' => '--jl-cap-color: {{VALUE}}',
        ],
        'condition' => [
            'car_type' => [ 'carousel3', 'carousel4' ]
        ]
      ]
    );

      $this->add_control(
      'cap_h_align',
      [
        'label' => __( 'Horizontal Alignment', 'wesper' ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'left' => [
            'title' => __( 'Left', 'wesper' ),
            'icon' => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => __( 'Center', 'wesper' ),
            'icon' => 'eicon-text-align-center',
          ],
          'right' => [
            'title' => __( 'Right', 'wesper' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'default' => 'center',
        'toggle' => true,
        'selectors' => [
                '{{WRAPPER}} .jl_caropt_w' => '--jlc-h-align: {{VALUE}}',                
            ]        
      ]
    );    

    $this->add_control(
      'cap_v_align',
      [
        'label' => __( 'Vertical Alignment', 'wesper' ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'start' => [
            'title' => __( 'Top', 'wesper' ),
            'icon' => 'eicon-v-align-top',
          ],
          'center' => [
            'title' => __( 'Middle', 'wesper' ),
            'icon' => 'eicon-v-align-middle',
          ],
          'end' => [
            'title' => __( 'Bottom', 'wesper' ),
            'icon' => 'eicon-v-align-bottom',
          ],
        ],
        'default' => 'center',
        'toggle' => true,
        'selectors' => [
                '{{WRAPPER}} .jl_caropt_w' => '--jlc-v-align: {{VALUE}}',                
            ],
        'condition' => [
            'car_type' => [ 'carousel2', 'carousel3' ]
        ]
      ]
    );      
      
      $this->add_responsive_control(
        'slfont_size',
        [
            'label' => __( 'Title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_caropt_w' => '--jlc-f-size: {{SIZE}}{{UNIT}};',            
            ],
        ]
      ); 
      
      $this->add_responsive_control(
        'jl_num_text_line',
        [
            'label' => __( 'Number line of text', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_ov_el .jl_fe_text .jl_fe_title' => 'display: -webkit-box !important; -webkit-line-clamp: {{SIZE}}; -webkit-box-orient: vertical; overflow: hidden; color: #fff;',            
            ],
        ]
    ); 

      $this->add_responsive_control(
        'sl_radius',
        [
            'label' => __( 'Carousel border radius', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jlc-car-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
      );  

      $this->add_responsive_control(
        'sl_nav_width',
        [
            'label' => __( 'Arrow width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-w: {{SIZE}}{{UNIT}};',
            ],
        ]
      );
      $this->add_responsive_control(
        'sl_nav_height',
        [
            'label' => __( 'Arrow height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-h: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_responsive_control(
        'sl_nav_size',
        [
            'label' => __( 'Arrow font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 150,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl-eb-sl .jl-spn-inner' => 'font-size: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
      );
      
      $this->add_responsive_control(
        'sl_nav_radius',
        [
            'label' => __( 'Arrow border radius', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-r: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_responsive_control(
        'sl_nav_space',
        [
            'label' => __( 'Arrow space left/right', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-space: {{SIZE}}{{UNIT}};',
            ],
        ]
      );

      $this->add_control(
      'sl_nav_bg',
      [
        'label' => __( 'Arrow background', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-bg: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'sl_nav_bg_dark',
      [
        'label' => __( 'Arrow background dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl-eb-sl' => '--jl-arrow-bg: {{VALUE}}',
        ],
      ]
    );
    
    $this->add_control(
      'sl_nav_color',
      [
        'label' => __( 'Arrow color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-color: {{VALUE}}',
        ],
      ]
    );
    
      $this->add_control(
      'sl_nav_hbg',
      [
        'label' => __( 'Arrow background hover', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-hbg: {{VALUE}}',
        ],
      ]
    );
      
    $this->add_control(
      'sl_nav_hcolor',
      [
        'label' => __( 'Arrow color hover', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .jl-eb-sl' => '--jl-arrow-hcolor: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'sl_nav_color_dark',
      [
        'label' => __( 'Arrow color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl-eb-sl' => '--jl-arrow-color: {{VALUE}}',
        ],
      ]
    ); 
    
    $this->add_control(
      'sl_dot_color',
      [
        'label' => __( 'Pagination color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '{{WRAPPER}} .jl_caropt_w .swiper-pagination-bullet' => 'color: {{VALUE}} !important',
        ],
      ]
    );

    $this->add_control(
      'sl_dot_color_dark',
      [
        'label' => __( 'Pagination color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_caropt_w .swiper-pagination-bullet' => 'color: {{VALUE}} !important',
        ],
      ]
    ); 

      $this->add_control(
                'desktop_item',
                [
                    'label' => esc_html__('Desktop Item', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3,
                ]
            );

            $this->add_control(
                'tablet_item',
                [
                    'label' => esc_html__('Tablet Item', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3,
                ]
            );

            $this->add_control(
                'small_mobile_item',
                [
                    'label' => esc_html__('Small mobile Item', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 1,
                ]
            );

            $this->add_control(
                'large_mobile_item',
                [
                    'label' => esc_html__('Large mobile', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 1,
                ]
            );

            $this->add_control(
                'landscape_mobile_item',
                [
                    'label' => esc_html__('Mobile landscape', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 2,
                ]
            );

            $this->add_control(
                'slider_speed',
                [
                    'label' => esc_html__('Speed', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 300,
                ]
            );

            $this->add_control(
                'slider_spacebetween',
                [
                    'label' => esc_html__('Space Between Items', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 30,
                ]
            );

            $this->add_control(
                'slider_loop',
                [
                    'label' => esc_html__( 'Repeatable Loop', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'slider_autoplay',
                [
                    'label' => esc_html__( 'Autoplay', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'slider_autoplay_delay',
                [
                    'label' => esc_html__('Autoplay Delay', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3500,
                    'condition'=>[
                        'slider_autoplay'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'slider_arrow',
                [
                    'label' => esc_html__( 'Slider Navigation', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );            

            $this->add_control(
                'slider_dots',
                [
                    'label' => esc_html__( 'Slider Pagination', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );              
          $this->add_control(
                'jl_hide_cat',
                [
                    'label' => esc_html__( 'Hide category', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'jl_hide_author',
                [
                    'label' => esc_html__( 'Hide author', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'jl_hide_date',
                [
                    'label' => esc_html__( 'Hide date', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

            $this->add_control(
                'jl_hide_meta',
                [
                    'label' => esc_html__( 'Hide author & date', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );            

            $this->add_control(
                'jl_hide_review',
                [
                    'label' => esc_html__( 'Hide review', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );  
       
         
        $this->end_controls_section();
    }

protected function render( ) { 
      $settings = $this->get_settings();

      if ( function_exists( 'wesper_mcarousel' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();
      $id = $settings['blockid'];
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }
      echo '<style>#'.esc_attr($settings['blockid']).' .jl-eb-sl:not(.swiper-container-initialized) .swiper-wrapper{grid-template-columns: repeat('.esc_attr($settings['desktop_item']).',minmax(0,1fr));grid-column-gap: '.esc_attr($settings['slider_spacebetween']).'px;display: grid;width: 100%;}#'.esc_attr($settings['blockid']).' .jl-eb-sl:not(.swiper-container-initialized) .swiper-wrapper .swiper-slide{display: none;}#'.esc_attr($settings['blockid']).' .jl-eb-sl:not(.swiper-container-initialized) .swiper-wrapper .swiper-slide:nth-child(-n+'.esc_attr($settings['desktop_item']).'){display: block;}</style>';
      echo \wesper_mcarousel( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'wesper' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }

   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }
}