<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class wesper_feature_slider_tab extends Widget_Base {

  public $base;

    public function get_name() {
        return 'wesper-feature-sl-tab';
    }

    public function get_title() {
        return esc_html__( 'Feature Tab Slider', 'wesper' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {

    $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'wesper'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'wesper'),
              'description' => esc_html__( 'Choose post type to display posts', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'wesper'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'wesper' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'wesper' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'wesper'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'wesper' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'wesper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'wesper'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
               

        $this->add_control(
      'posts_per_page',
      array(
        'label'       => esc_html__( 'Posts per Page', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '3'
      )
    );

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'wesper' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'wesper' ),
                        'gallery'        => esc_html__( 'Gallery', 'wesper' ),
                        'video'        => esc_html__( 'Video', 'wesper' ),
                        'audio'        => esc_html__( 'Audio', 'wesper' ),
                        'quote'        => esc_html__( 'Quote', 'wesper' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );   

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'wesper' ),                        
                  'rand'      =>esc_html__( 'Random', 'wesper' ),
                  'update'      =>esc_html__( 'Latest updated', 'wesper' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'wesper' ),
                  'author'      =>esc_html__( 'Author', 'wesper' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'wesper' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'wesper' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'wesper' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'wesper' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'wesper' ),
              ],
            ]
        );                   

    $this->end_controls_section();        
     
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'wesper' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );      
       
       $this->add_control(
            'car_effect',
            [
                'label'     =>esc_html__( 'Slider effect', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'fade',
                'options'   => [
                        'fade'      =>esc_html__( 'Fade effect', 'wesper' ),
                        'slide'      =>esc_html__( 'Slide effect', 'wesper' ),
                        'parallax'      =>esc_html__( 'Paralax effect', 'wesper' ),
                    ],
            ]
        ); 

        $this->add_control(
          'jl_cus_img',
          [
              'label'     =>esc_html__( 'Image size', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => '',
              'options'   => [
                      ''      =>esc_html__( 'Default image size', 'wesper' ),      
                      'wesper_large'      =>esc_html__( '1600 x 0', 'wesper' ),
                      'wesper_medium'      =>esc_html__( '1100 x 0', 'wesper' ),
                      'wesper_small'      =>esc_html__( '150 x 150', 'wesper' ),
                      'wesper_layouts'      =>esc_html__( '680 x 580', 'wesper' ),
                      'wesper_list'      =>esc_html__( '600 x 0', 'wesper' ),
                  ],
          ]
      ); 
        
      $this->add_responsive_control(
        'slfont_size',
        [
            'label' => __( 'Title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 45,
            ],
            'tablet_default' => [
              'size' => 40,
            ],
            'mobile_default' => [
              'size' => 35,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-main-size: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );  

      $this->add_responsive_control(
        'sltab_font_size',
        [
            'label' => __( 'Tab title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 19,
            ],
            'tablet_default' => [
              'size' => 19,
            ],
            'mobile_default' => [
              'size' => 19,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-tab-size: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'slwrap_width',
        [
            'label' => __( 'Slider content width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 1200,
            ],
            'tablet_default' => [
              'size' => 1200,
            ],
            'mobile_default' => [
              'size' => 1200,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 3000,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-max-width: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );    

      $this->add_responsive_control(
        'slwrap_height',
        [
            'label' => __( 'Slider height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 600,
            ],
            'tablet_default' => [
              'size' => 500,
            ],
            'mobile_default' => [
              'size' => 450,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 3000,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-max-height: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );         

      $this->add_responsive_control(
        'slcap_width',
        [
            'label' => __( 'Slider caption width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
            'size' => 50,
            ],
            'tablet_default' => [
              'size' => 50,
            ],
            'mobile_default' => [
              'size' => 100,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 100,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-cap-width: {{SIZE}}% !important;',            
            ],
        ]
      ); 

      $this->add_responsive_control(
        'slpadding_space',
        [
            'label' => __( 'Slider padding space', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 3000,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-padding: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'sltab_width',
        [
            'label' => __( 'Slider tab width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 400,
            ],
            'tablet_default' => [
              'size' => 300,
            ],
            'mobile_default' => [
              'size' => 300,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 3000,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl-stab-w' => '--st-tab-with: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );   

      $this->add_responsive_control(
        'sltab_img_width',
        [
            'label' => __( 'Slider tab img width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 150,
            ],
            'tablet_default' => [
              'size' => 110,
            ],
            'mobile_default' => [
              'size' => 110,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-img-with: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      ); 

      $this->add_responsive_control(
        'sltab_img_height',
        [
            'label' => __( 'Slider tab img height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 110,
            ],
            'tablet_default' => [
              'size' => 80,
            ],
            'mobile_default' => [
              'size' => 80,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-img-height: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'slmain_conner',
        [
            'label' => __( 'Slider rounded coner', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-rounded-mian: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );      

      $this->add_responsive_control(
        'sltab_conner',
        [
            'label' => __( 'Slider tab rounded coner', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl-stab-w' => '--st-rounded-tab: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );                    

    $this->add_control(
                'slider_speed',
                [
                    'label' => esc_html__('Speed', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 600,
                ]
    );        
    $this->add_control(
                'slider_loop',
                [
                    'label' => esc_html__( 'Repeatable Loop', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );    

            $this->add_control(
                'slider_autoplay',
                [
                    'label' => esc_html__( 'Autoplay', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'slider_autoplay_delay',
                [
                    'label' => esc_html__('Autoplay Delay', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3500,
                    'condition'=>[
                        'slider_autoplay'=>'yes',
                    ],
                ]
            ); 

            $this->add_control(
                'jl_hide_cat',
                [
                    'label' => esc_html__( 'Hide category', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'jl_hide_author',
                [
                    'label' => esc_html__( 'Hide author', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'jl_hide_date',
                [
                    'label' => esc_html__( 'Hide date', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

            $this->add_control(
                'jl_hide_meta',
                [
                    'label' => esc_html__( 'Hide author & date', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'jl_hide_desc',
                [
                    'label' => esc_html__( 'Hide description', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );  
            
            $this->add_control(
              'jl_hide_btn',
              [
                  'label' => esc_html__( 'Hide button', 'wesper' ),
                  'type' => Controls_Manager::SWITCHER,
                  'selectors' => [            
                  '{{WRAPPER}} .jl_cap_btn' => 'display: none !important;',            
                  ],
              ]
          );  
                 
         
        $this->end_controls_section();
    }

protected function render( ) { 
      $settings = $this->get_settings();

      if ( function_exists( 'wesper_tab_slider' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();
      $id = $settings['blockid'];
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }      
      echo \wesper_tab_slider( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'wesper' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }

   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }
}