<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class wesper_section_layouts extends Widget_Base {

    public function get_name() {
        return 'wesper-section-layouts';
    }

    public function get_title() {
        return esc_html__( 'Layouts', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-layout-settings jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_style_marker',
            [
                'label' => __( 'Layouts Settings', 'wesper' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'section_layouts',
            [
                'label'     =>esc_html__( 'Choose layouts', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'options'     => wesper_get_all_posts(),                
            ]
        );

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();
       $section_layouts = $settings['section_layouts'];
       if ( ! empty( $section_layouts ) ) {
        	echo do_shortcode( '[jl_layout id="' . esc_attr($section_layouts) . '"]' );
		}
    }
}