<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class wesper_newsticker_text extends Widget_Base {

    public function get_name() {
        return 'wesper-newsticker-text';
    }

    public function get_title() {
        return esc_html__( 'Newsticker Text', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }    

    protected function register_controls() {
     
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'wesper'),
            ]
        );        

        $this->add_control(
            'jl_label_title', [
              'label'       => esc_html__( 'Label title', 'wesper' ),
              'default'   => 'Top News',
              'type'        => Controls_Manager::TEXT,
              'label_block'   => true
            ]
            );  

            $this->add_control(
                'post_type',
                [
                    'label' =>esc_html__('Post types', 'wesper'),
                    'description' => esc_html__( 'Choose post type to display posts', 'wesper' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'post',            
                     'options'   => $this->post_get_type(),             
                ]
            ); 
      
            $this->add_control(
              'post_type_tax',
              [
                  'label' =>esc_html__('Post taxonomy', 'wesper'),
                  'description' => esc_html__( 'Choose post type (category or tag)', 'wesper' ),
                  'type'      => Controls_Manager::SELECT,
                  'default'   => 'none',          
                   'options'   => $this->post_get_taxs(),
                   'condition' => [
                     'post_type!'    => ['post']
                   ]  
                              
              ]
          ); 
      
          $this->add_control(
            'term_slugs', [
              'label'       => esc_html__( 'Term Slug', 'wesper' ),
              'description' => esc_html__( 'Example: slug1,slug2,slug3', 'wesper' ),
              'type'        => Controls_Manager::TEXT,
              'label_block'   => true,
              'condition' => [
                'post_type!'    => ['post']
              ]  
            ]
            );
              
              $this->add_control(
                  'categories',
                  [
                      'label' =>esc_html__('Select Categories', 'wesper'),
                      'type'      => Controls_Manager::SELECT2,
                       'options'   => $this->post_categories(),
                      'label_block' => true,
                      'multiple'  => true,
                      'condition' => [
                        'post_type'    => ['post']
                      ]  
                  ]
              ); 
               
      
              $this->add_control(
            'tags', [
              'label'       => esc_html__( 'Tag Slug', 'wesper' ),
              'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'wesper' ),
              'type'        => Controls_Manager::TEXT,
              'label_block'   => true,
              'condition' => [
                'post_type'    => ['post']
              ]  
            ]
            );  
      
              $this->add_control(
                  'author',
                  [
                      'label' =>esc_html__('Author Filter', 'wesper'),
                      'type'      => Controls_Manager::SELECT,
                      'default'   => 'none',
                       'options'   => $this->post_author(),
                       'condition' => [
                         'post_type'    => ['post']
                       ]  
                  ]
              ); 
              
            //   $this->add_control(
            //     'author',
            //     [
            //         'label' =>esc_html__('Select Author', 'wesper'),
            //         'type'      => Controls_Manager::SELECT2,
            //          'options'   => $this->post_author(),
            //         'label_block' => true,
            //         'multiple'  => true,
            //     ]
            // ); 
                     
      
              $this->add_control(
            'posts_per_page',
            array(
              'label'       => esc_html__( 'Posts per Page', 'wesper' ),
              'type'        => Controls_Manager::NUMBER,
              'default'     => '6'
            )
          );
      
              $this->add_control(
            'offset',
            array(
              'label'       => esc_html__( 'Post Offset', 'wesper' ),
              'type'        => Controls_Manager::NUMBER,
              'default'     => '',
            )
          );
          
      
          $this->add_control(
            'format',
            array(
              'label'       => esc_html__( 'Post Format', 'wesper' ),
              'type'        => Controls_Manager::SELECT,
              'options'   => [
                              '0'               => esc_html__( 'All', 'wesper' ),
                              'gallery'        => esc_html__( 'Gallery', 'wesper' ),
                              'video'        => esc_html__( 'Video', 'wesper' ),
                              'audio'        => esc_html__( 'Audio', 'wesper' ),
                              'quote'        => esc_html__( 'Quote', 'wesper' ),
                          ],
              'default'     => '0',
              'condition' => [
                'post_type'    => ['post']
              ]  
            )
          );       

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                    'date_post'      =>esc_html__( 'Latest post', 'wesper' ),                        
                    'rand'      =>esc_html__( 'Random', 'wesper' ),
                    'update'      =>esc_html__( 'Latest updated', 'wesper' ),
                    'comment_count'      =>esc_html__( 'Popular comment', 'wesper' ),
                    'author'      =>esc_html__( 'Author', 'wesper' ),
                    'popular_most'      =>esc_html__( 'Popular views', 'wesper' ),
                    'popular_by_month'      =>esc_html__( 'Popular views by month', 'wesper' ),
                    'popular_by_week'      =>esc_html__( 'Popular views by week', 'wesper' ),
                    'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'wesper' ),
                    'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'wesper' ),
                ],
            ]
        );          

      $this->add_control(
      'pagination',
      array(
        'label'       => esc_html__( 'Pagination', 'wesper' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'None', 'wesper' ),
                        'next_prev'       => esc_html__( 'Next Prev', 'wesper' ),
                        'loadmore'        => esc_html__( 'Load More', 'wesper' ),
                        'autoload'        => esc_html__( 'Auto Load', 'wesper' ),
                    ],
        'default'     => '0',
      )
    );      
    
    $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_style', [
              'label'  => esc_html__( 'Title Style', 'wesper' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
              );

              $this->add_control(
                'slider_speed',
                [
                    'label' => esc_html__('Speed', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 300,
                ]
            );                        

            $this->add_control(
                'slider_autoplay_delay',
                [
                    'label' => esc_html__('Autoplay Delay', 'wesper'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3500,                    
                ]
            );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'jl_list_text_typography',
                'label' => __( 'Title Typography', 'wesper' ),
                'selector' => '{{WRAPPER}} .jl-newsticker-li .jl_fe_title',
            ]
        );

        $this->add_control(
            'jl_list_text_color',
            [
                'label' => __( 'Title Color', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jl-newsticker-li .jl_fe_title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'jl_list_text_color_dark',
            [
                'label' => __( 'Title Color Dark Mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl-newsticker-li .jl_fe_title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'jl_arrow_color',
            [
                'label' => __( 'Arrow Color', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#d4d4d4',
                'selectors' => [
                    '{{WRAPPER}}' => '--tarrow-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'jl_arrow_color_dark',
            [
                'label' => __( 'Arrow Color Dark Mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#49494b',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}}' => '--tarrow-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'jl_arrow_colorh',
            [
                'label' => __( 'Arrow Hover Color', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ed0101',
                'selectors' => [
                    '{{WRAPPER}}' => '--tarrowh-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'jl_arrow_colorh_dark',
            [
                'label' => __( 'Arrow Hover Color Dark Mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ed0101',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}}' => '--tarrowh-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'jl_arrow_spacing',
            [
                'label' => esc_html__( 'Arrow Spacing', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_wp .jl_arpw' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'jl_arrow_size',
            [
                'label' => esc_html__( 'Arrow Size', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_wp .jl_arpw div .jl-spn-inner' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .jl-newsticker-li' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'jl_arrow_font_size',
            [
                'label' => esc_html__( 'Arrow Font Size', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_wp .jl_arpw div .jl-spn-inner' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'jl_arrow_rounded',
            [
                'label' => esc_html__( 'Arrow Border Rounded', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_wp .jl_arpw div .jl-spn-inner' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'jl_hide_meta',
            [
                'label' => esc_html__( 'Hide date', 'wesper' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );       

        $this->end_controls_section();

        
        $this->start_controls_section(
            'section_label_style', [
              'label'  => esc_html__( 'Label Style', 'wesper' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
              ); 

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'jl_label_typography',
                'label' => __( 'Label Typography', 'wesper' ),
                'selector' => '{{WRAPPER}} .jl_ticker_lbl',
            ]
        );

        $this->add_control(
            'jl_label_color',
            [
                'label' => __( 'Label Color', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_lbl' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'jl_label_color_dark',
            [
                'label' => __( 'Label Color Dark Mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl_ticker_lbl' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'jl_label_background',
            [
                'label' => __( 'Label Background', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_lbl' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'jl_label_background_dark',
            [
                'label' => __( 'Label Background Dark Mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl_ticker_lbl' => 'background: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'jl_label_spacing',
            [
                'label' => esc_html__( 'Label spacing', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_wp' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'jl_label_rounded',
            [
                'label' => esc_html__( 'Label border rounded', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl_ticker_lbl' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'jl_label_padding',
            [
                'label'      => __( 'Label padding', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jl_ticker_lbl' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]                
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();
        if ( function_exists( 'wesper_m_list' ) ) {
        $settings['blockid'] = 'blockid_' . $this->get_id();      
        if(!empty($settings['categories'])){
        $settings['categories'] = implode(',', $settings['categories']);      
        }
        echo \wesper_newsticker( $settings );
        }
    }
    public function post_categories() {
        $terms = get_terms( array(
              'taxonomy'    => 'category',
              'hide_empty'  => false,
              'posts_per_page' => -1, 
              'suppress_filters' => false,
        ) );
  
        $cat_list = [];
        foreach($terms as $post) {
        $cat_list[$post->term_id]  = [$post->name];
        }
        return $cat_list;
     }
  
     public function post_author() {
  
      $blogusers = get_users( array(
      'role__not_in' => array( 'subscriber' ),
      'fields'       => array( 'ID', 'display_name' )
      ) );
  
        $user_list = [];
        $user_list['none']= esc_html__( 'None', 'wesper' );
        foreach($blogusers as $user) {
        $user_list[$user->ID]  = [$user->display_name];
        }
        return $user_list;
     }

     public function post_get_type() {

        $post_types = get_post_types( '', 'names' ); 
    
          $type_list = [];
          $type_list['none']= esc_html__( 'None', 'wesper' );
          if ( ! empty( $post_types ) ){
            foreach($post_types as $p_type) {
            $type_list[$p_type]  = [$p_type];
            }
          }
          return $type_list;
       }
    
       public function post_get_taxs() {
    
        $taxonomies = get_taxonomies();
    
          $type_taxs = [];
          $type_taxs['none']= esc_html__( 'None', 'wesper' );
          if ( ! empty( $taxonomies ) ){
            foreach($taxonomies as $p_taxs) {
            $type_taxs[$p_taxs]  = [$p_taxs];
            }
        }
          return $type_taxs;
       }
}