<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class wesper_section_title extends Widget_Base {

  public $base;

    public function get_name() {
        return 'wesper-section-title';
    }

    public function get_title() {
        return esc_html__( 'Section Title', 'wesper' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Section Title Setting', 'wesper'),
            ]
        );

      $this->add_control(
      'section_title', [
        'label'       => esc_html__( 'Section Title', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => 'Section title',
        'placeholder' => esc_html__( 'Section text', 'wesper' )        
      ]
      );
      $this->add_control(
      'section_desc', [
        'label'       => esc_html__( 'Section description', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
      ]
      );
      $this->add_control(
      'section_btn_text', [
        'label'       => esc_html__( 'Section button text', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
      ]
      );
      $this->add_control(
            'jl_text_url',
            [
                'label' =>esc_html__( 'Section title URL', 'wesper' ),
                'type' => Controls_Manager::URL,                
            ]
     );

     $this->add_control(
            'jl_btn_url',
            [
                'label' =>esc_html__( 'Section button URL', 'wesper' ),
                'type' => Controls_Manager::URL,                
            ]
        );
    $this->add_control(
            'tag',
            [
                'label' => __( 'Title Tag', 'wesper' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h2',
            ]
        );
      $this->end_controls_section();
      $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Section Title Options', 'wesper' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     
      $this->add_control(
            'section_style',
            [
                'label'     =>esc_html__( 'Section Title Styles', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'jl_sec_style1',
                'options'   => [
                        'jl_sec_style1'      =>esc_html__( 'Line bottom', 'wesper' ),
                        'jl_sec_style2'    =>esc_html__( 'Line top', 'wesper' ),
                        'jl_sec_style3'    =>esc_html__( 'Line center', 'wesper' ),
                        'jl_sec_style4'    =>esc_html__( 'Double line bottom', 'wesper' ),
                        'jl_sec_style5'    =>esc_html__( 'Double line top', 'wesper' ),
                        'jl_sec_style6'    =>esc_html__( 'Double line center', 'wesper' ),
                        'jl_sec_style7'    =>esc_html__( 'Title shadow', 'wesper' ),
                        'jl_sec_style8'    =>esc_html__( 'Text only', 'wesper' ),
                        'jl_sec_style9'    =>esc_html__( 'Title with background', 'wesper' ),
                        'jl_sec_style10'    =>esc_html__( 'Title with background line top', 'wesper' ),
                        'jl_sec_style11'    =>esc_html__( 'Title line left', 'wesper' ),
                        'jl_sec_style12'    =>esc_html__( 'Title with doted circle', 'wesper' ),
                        'jl_sec_style13'    =>esc_html__( 'Title with squre', 'wesper' ),
                        'jl_sec_style14'    =>esc_html__( 'Title with parallelogram', 'wesper' ),
                        'jl_sec_style15'    =>esc_html__( 'Title line with line color', 'wesper' ),
                        'jl_sec_style16'    =>esc_html__( 'Title with background full', 'wesper' ),
                        'jl_sec_style17'    =>esc_html__( 'Title with background full with arrow', 'wesper' ),
                    ],
            ]
        );

      $this->add_responsive_control(
            'jlc_align',
            array(
                'label'     => __( 'Alignment', 'wesper' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => array(
                    'left'   => array(
                        'title' => __( 'Left', 'wesper' ),
                        'icon'  => 'eicon-text-align-left',
                    ),
                    'center' => array(
                        'title' => __( 'Center', 'wesper' ),
                        'icon'  => 'eicon-text-align-center',
                    ),
                    'right'  => array(
                        'title' => __( 'Right', 'wesper' ),
                        'icon'  => 'eicon-text-align-right',
                    ),
                ),
                'toggle'    => false,
                'default'   => 'left',
                'selectors' => array(
                    '{{WRAPPER}} .jlcus_sec_title' => '--sect-t-algin: {{VALUE}};',
                    '{{WRAPPER}} .jlcus_sec_title .jl_sct_bt' => 'top: 0px;',
                )                
            )
        );

        $this->add_responsive_control(
            'sec_line_top',
            [
                'label' => __( 'Section line top', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'default' => [
                    'size' => 5,
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title .jlcus_sect_inner' => 'border-top: {{SIZE}}{{UNIT}} solid;',
                ],
                'condition' => [
                    'section_style'    => ['jl_sec_style12','jl_sec_style13','jl_sec_style14']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_line_bottom',
            [
                'label' => __( 'Section line bottom', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title .jlcus_sect_inner' => 'border-bottom: {{SIZE}}{{UNIT}} solid;',
                ],
                'condition' => [
                    'section_style'    => ['jl_sec_style12','jl_sec_style13','jl_sec_style14']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_line_padding',
            [
                'label'      => __( 'Section line space', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jlcus_sec_title .jlcus_sect_inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                    'section_style'    => ['jl_sec_style12','jl_sec_style13','jl_sec_style14']
                ]
            ]
        );

        $this->add_control(
            'sec_line_color',
            [
              'label' => __( 'Section line color', 'wesper' ),
              'type' => Controls_Manager::COLOR,        
              'default' => '#000',
              'selectors' => [
                  '{{WRAPPER}}  .jlcus_sec_title .jlcus_sect_inner' => 'border-color: {{VALUE}}',
              ],
              'condition' => [
                  'section_style'    => ['jl_sec_style12','jl_sec_style13','jl_sec_style14']
              ]
            ]
          );
      
          $this->add_control(
            'sec_line_color_dark',
            [
              'label' => __( 'Section line color dark mode', 'wesper' ),
              'default' => '#3c3c3c',
              'type' => Controls_Manager::COLOR,        
              'selectors' => [
                  '.options_dark_skin {{WRAPPER}}  .jlcus_sec_title .jlcus_sect_inner' => 'border-color: {{VALUE}}',
              ],
              'condition' => [
                  'section_style'    => ['jl_sec_style12','jl_sec_style13','jl_sec_style14']
              ]
            ]
          );
          
        $this->add_responsive_control(
            'sec_line_height',
            [
                'label' => __( 'Line width', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title' => '--sect-line-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style'    => ['jl_sec_style1','jl_sec_style2','jl_sec_style3','jl_sec_style9','jl_sec_style10','jl_sec_style11','jl_sec_style15']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_ac_line_height',
            [
                'label' => __( 'Active line width', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'default' => [
                    'size' => 5,
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title' => '--sect-ac-line-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style'    => ['jl_sec_style15']
                ]
            ]
        );

          $this->add_responsive_control(
            'sec_line_width',
            [
                'label' => __( 'Line width', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title' => '--sect-line-w: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style'    => ['jl_sec_style3','jl_sec_style6','jl_sec_style7']
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_line_space',
            [
                'label' => __( 'Title space', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title' => '--sect-line-space: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'section_style!'    => ['jl_sec_style16','jl_sec_style17']
                ]
            ]
        );

        $this->add_control(
            'section_title_font',
            [
                'label'     =>esc_html__( 'Section Title font', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'jl_secf_title',
                'options'   => [
                        'jl_secf_title'      =>esc_html__( 'Title font', 'wesper' ),
                        'jl_secf_menu'    =>esc_html__( 'Menu font', 'wesper' ),
                        'jl_secf_body'    =>esc_html__( 'Body font', 'wesper' ),
                        'jl_secf_cus'    =>esc_html__( 'Custom font', 'wesper' ),
                    ],
            ]
        );

        $this->add_responsive_control(
        'sec_font_size',
        [
            'label' => __( 'Title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 23,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-t-size: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'section_title_font'    => ['jl_secf_title','jl_secf_menu','jl_secf_body']
            ]
        ]
    );
    
    $this->add_responsive_control(
        'sec_letter_spaceing',
        [
            'label' => __( 'Title letter spacing', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
                'size' => -0.03,
            ],
            'range' => [
                'px' => [
                    'min' => -0.7,
                    'max' => 0.7,
                    'step' => 0.01,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-t-space: {{SIZE}}em !important;',
            ],
            'condition' => [
                'section_title_font'    => ['jl_secf_title','jl_secf_menu','jl_secf_body']
            ]
        ]
    );

    $this->add_control(
        'jl_title_up',
        [
            'label' => esc_html__( 'Title Uppercase', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title .jl-heading-text' => 'text-transform: uppercase !important;',
            ],
            'condition' => [
                'section_title_font'    => ['jl_secf_title','jl_secf_menu','jl_secf_body']
            ]            
        ]
        );

      $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography', 
                'label' =>esc_html__( 'Title typography', 'wesper' ),               
                'selector' => '{{WRAPPER}} .jlcus_sec_title.jl_secf_cus .jl-heading-text',
                'condition' => [
                    'section_title_font'    => 'jl_secf_cus'
                ]
            ]
        );

        $this->add_responsive_control(
            'sec_desc_size',
            [
                'label' => __( 'Description font size', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title .jl_sct_sub' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
                'condition'=>[
                    'section_desc!'=>'',
                ],
            ]
        );   
        
        $this->add_responsive_control(
            'sec_desc_space',
            [
                'label' => __( 'Description space', 'wesper' ),
                'type' => Controls_Manager::SLIDER,                
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jlcus_sec_title .jl_sct_sub' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
                ],
                'condition'=>[
                    'section_desc!'=>'',
                ],
            ]
        );   

      $this->add_control(
            'section_btn_font',
            [
                'label'     =>esc_html__( 'Section button font', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'jl_secb_menu',
                'options'   => [
                        'jl_secb_title'      =>esc_html__( 'Title font', 'wesper' ),
                        'jl_secb_menu'    =>esc_html__( 'Menu font', 'wesper' ),
                        'jl_secb_body'    =>esc_html__( 'Body font', 'wesper' ),
                        'jl_secb_cus'    =>esc_html__( 'Custom font', 'wesper' ),
                ],
                'condition'=>[
                        'section_btn_text!'=>'',
                ],
            ]
        );  

      $this->add_responsive_control(
        'sec_btn_font_size',
        [
            'label' => __( 'Button font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 14,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-btn-size: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'section_btn_font'    => ['jl_secb_title','jl_secb_menu','jl_secb_body'],                
                'section_btn_text!'=>'',                
            ]
        ]
    );
    $this->add_responsive_control(
        'sec_btn_letter_spaceing',
        [
            'label' => __( 'Button letter spacing', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => -0.7,
                    'max' => 0.7,
                    'step' => 0.01,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-btn-space: {{SIZE}}em !important;',
            ],
            'condition' => [
                'section_btn_font'    => ['jl_secb_title','jl_secb_menu','jl_secb_body'],
                'section_btn_text!'=>'',                

            ]
        ]
    );

      $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography', 
                'label' =>esc_html__( 'Button typography', 'wesper' ),               
                'selector' => '{{WRAPPER}} .jlcus_sec_title.jl_secb_cus .jl_sct_bt',
                'condition' => [
                    'section_btn_font'    => 'jl_secb_cus',
                    'section_btn_text!'=>'',                
                ]
            ]
        );

    $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography', 
                'label' =>esc_html__( 'Description typography', 'wesper' ),               
                'selector' => '{{WRAPPER}} .jlcus_sec_title .jl_sct_sub',                
                'condition'=>[
                        'section_desc!'=>'',
                ],
            ]
        );

    $this->add_control(
      'title_color',
      [
        'label' => __( 'Title color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jlcus_sec_title' => '--sect-t-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'title_color_dark',
      [
        'label' => __( 'Title color dark mode', 'wesper' ),
        'default' => '#fff',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--sect-t-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
        'ac_line_color',
        [
          'label' => __( 'Active line color', 'wesper' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#000',
          'selectors' => [
              '{{WRAPPER}} .jlcus_sec_title' => '--ac-line-color: {{VALUE}}',
          ],
        ]
      );
  
      $this->add_control(
        'ac_line_color_dark',
        [
          'label' => __( 'Active line color dark mode', 'wesper' ),
          'default' => '#fff',
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--ac-line-color: {{VALUE}}',
          ],
        ]
      );

    $this->add_control(
        'titlebg_color',
        [
          'label' => __( 'Title bg color', 'wesper' ),
          'type' => Controls_Manager::COLOR,        
          'default' => '#e9e9e9',
          'selectors' => [
              '{{WRAPPER}} .jlcus_sect_inner' => 'background: {{VALUE}}',
              '{{WRAPPER}} .jl_sec_style17 .jlcus_sect_inner:before' => '    border-top-color: {{VALUE}}',
          ],
          'condition' => [
            'section_style'    => ['jl_sec_style16','jl_sec_style17']
          ]
        ]
      );
  
      $this->add_control(
        'titlebg_color_dark',
        [
          'label' => __( 'Title bg color dark mode', 'wesper' ),
          'default' => '#3c3c3c',
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '.options_dark_skin {{WRAPPER}} .jlcus_sect_inner' => 'background: {{VALUE}}',
              '.options_dark_skin {{WRAPPER}} .jl_sec_style17 .jlcus_sect_inner:before' => '    border-top-color: {{VALUE}}',
          ],
          'condition' => [
            'section_style'    => ['jl_sec_style16','jl_sec_style17']
          ]
        ]
      );

      $this->add_responsive_control(
        'sec_title_bg_h',
        [
            'label' => __( 'Title bg height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 40,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sect_inner' => 'height: {{SIZE}}{{UNIT}}; align-items: center;padding: 0px 15px;',
            ],
            'condition' => [
                'section_style'    => ['jl_sec_style16','jl_sec_style17']
            ]
        ]
    );

    $this->add_control(
      'title_desc_color',
      [
        'label' => __( 'Description color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#666',
        'selectors' => [
            '{{WRAPPER}} .jlcus_sec_title' => '--sect-dsc-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_desc!'=>'',
        ],
      ]
    );
    

    $this->add_control(
      'title_desc_color_dark',
      [
        'label' => __( 'Description color dark mode', 'wesper' ),
        'default' => '#ddd',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--sect-dsc-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_desc!'=>'',
        ],
      ]
    );

    $this->add_control(
      'button_color',
      [
        'label' => __( 'Button color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jlcus_sec_title' => '--sect-btn-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_btn_text!'=>'',
        ],
      ]
    );
    $this->add_control(
      'button_color_dark',
      [
        'label' => __( 'Button Dark mode color', 'wesper' ),
        'default' => '#fff',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--sect-btn-color: {{VALUE}}',
        ],
        'condition'=>[
                        'section_btn_text!'=>'',
        ],
      ]
    );
    $this->add_control(
      'line_color',
      [
        'label' => __( 'Line / dot color / background', 'wesper' ),
        'default' => '#e9ecef',
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .jlcus_sec_title' => '--sect-line-color: {{VALUE}}'
        ],
            'condition' => [
                'section_style'    => ['jl_sec_style1','jl_sec_style2','jl_sec_style3','jl_sec_style4','jl_sec_style5','jl_sec_style6', 'jl_sec_style7','jl_sec_style9','jl_sec_style10','jl_sec_style11','jl_sec_style12','jl_sec_style13','jl_sec_style14','jl_sec_style15']
        ]
      ]
    );
    

    $this->add_control(
      'line_color_dark',
      [
        'label' => __( 'Line / dot / background dark mode color', 'wesper' ),
        'default' => '#49494b',
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--sect-line-color: {{VALUE}}'        
        ],
            'condition' => [
                'section_style'    => ['jl_sec_style1','jl_sec_style2','jl_sec_style3','jl_sec_style4','jl_sec_style5','jl_sec_style6', 'jl_sec_style7', 'jl_sec_style9','jl_sec_style10','jl_sec_style11','jl_sec_style12','jl_sec_style13','jl_sec_style14','jl_sec_style15']
        ]
      ]
    );

    $this->add_control(
                'jl_show_icons',
                [
                    'label' => esc_html__( 'Show button arrow', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'=>[
                        'section_btn_text!'=>'',
                    ],  
                ]
    );

    $this->add_responsive_control(
        'sec_title_stroke',
        [
            'label' => __( 'Title stroke width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 20,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-stroke-size: {{SIZE}}px !important;',
            ],
            'condition' => [
                'section_style'    => 'jl_sec_style7'
            ]            
        ]
    );

    $this->add_responsive_control(
        'sec_title_shadow',
        [
            'label' => __( 'Title shadow position', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 0.6,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3,
                    'step' => 0.01,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-stroke-pos: {{SIZE}}rem !important;',
            ],
            'condition' => [
                'section_style'    => 'jl_sec_style7'
            ]            
        ]
    );
    $this->add_control(
      'line_stroke_color',
      [
        'label' => __( 'Stroke and shadow color', 'wesper' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jlcus_sec_title' => '--sect-shadow-color: {{VALUE}};'        
        ],
        'condition' => [
            'section_style'    => 'jl_sec_style7'
        ]
      ]
    );

    $this->add_control(
      'line_stroke_color_dark',
      [
        'label' => __( 'Stroke and shadow dark mode color', 'wesper' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#000',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--sect-shadow-color: {{VALUE}};'        
        ],
        'condition' => [
            'section_style'    => 'jl_sec_style7'
        ]
      ]
    );

    $this->add_control(
                'jl_bg_title',
                [
                    'label' => esc_html__( 'Enable title background & padding', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                    'section_style!'    => ['jl_sec_style16','jl_sec_style17']
                    ]
                ]
    );

    $this->add_control(
      'jl_title_bg',
      [
        'label' => __( 'Title background', 'wesper' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#ff1d46',
        'selectors' => [
            '{{WRAPPER}} .jlcus_sec_title' => '--sect-title-bg: {{VALUE}};'        
        ],
        'condition' => [
            'jl_bg_title'    => 'yes',
            'section_style!'    => ['jl_sec_style9','jl_sec_style10']
        ]
      ]
    );

    $this->add_control(
      'jl_title_bg_dark',
      [
        'label' => __( 'Title dark mode background', 'wesper' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#ff1d46',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--sect-title-bg: {{VALUE}};'        
        ],
        'condition' => [
            'jl_bg_title'    => 'yes',
            'section_style!'    => ['jl_sec_style9','jl_sec_style10']
        ]
      ]
    );
    $this->add_responsive_control(
        'jl_title_radius',
        [
            'label' => __( 'Title rounded coner', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-rounded: {{SIZE}}{{UNIT}} !important;',
                '{{WRAPPER}} .jlcus_sec_title.jl_sec_style10 .jl-heading-text span' => 'margin-top: 0px !important;',
            ],
            'condition' => [
                'jl_bg_title'    => 'yes',
                'section_style!'    => ['jl_sec_style9']
            ]            
        ]
    );

    $this->add_responsive_control(
            'jl_title_padding',
            [
                'label'      => __( 'Title padding', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jlcus_sec_title.jl_sec_title_bg .jl-heading-text span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                    'jl_bg_title'    => 'yes'
                ]
            ]
        );
    $this->add_control(
                'jl_bg_btn',
                [
                    'label' => esc_html__( 'Enable button background', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'=>[
                        'section_btn_text!'=>'',
                    ],
                ]
    );

    $this->add_control(
      'jl_btn_bg',
      [
        'label' => __( 'Button background', 'wesper' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#fff',
        'selectors' => [
            '{{WRAPPER}} .jlcus_sec_title' => '--sect-btn-bg: {{VALUE}};'        
        ],
        'condition' => [
            'jl_bg_btn'    => 'yes',
            'section_btn_text!'=>'',
        ]
      ]
    );

    $this->add_control(
      'jl_btn_bg_dark',
      [
        'label' => __( 'Button dark mode background', 'wesper' ),
        'type' => Controls_Manager::COLOR,
        'default' => '#ff1d46',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jlcus_sec_title' => '--sect-btn-bg: {{VALUE}};'        
        ],
        'condition' => [
            'jl_bg_btn'    => 'yes',
            'section_btn_text!'=>'',
        ]
      ]
    );
    $this->add_responsive_control(
        'jl_btn_radius',
        [
            'label' => __( 'Button rounded coner', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .jlcus_sec_title' => '--sect-btn-rounded: {{SIZE}}{{UNIT}} !important;',
            ],
            'condition' => [
                'jl_bg_btn'    => 'yes',
                'section_btn_text!'=>'',
            ]            
        ]
    );

    $this->add_responsive_control(
            'jl_btn_padding',
            [
                'label'      => __( 'Button Padding', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jlcus_sec_title.jl_sec_btn_bg .jl_sct_bt span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                    'jl_bg_btn'    => 'yes',
                    'section_btn_text!'=>'',
                ]
            ]
        );
        $this->end_controls_section();
    }
    protected function render( ) { 
        $settings = $this->get_settings_for_display();
        $tag = $settings['tag'];
        $section_style = $settings['section_style'];
        $section_title = $settings['section_title'];
        $section_desc = $settings['section_desc'];
        $section_btn_text = $settings['section_btn_text'];        
        $jl_show_icons = $settings['jl_show_icons'];
        $section_title_font = $settings['section_title_font'];
        $section_btn_font = $settings['section_btn_font'];
        $jl_bg_title = $settings['jl_bg_title'];
        $jl_bg_btn = $settings['jl_bg_btn'];
        if ($jl_bg_title === 'yes') {
            $jl_bg_title = 'jl_sec_title_bg';
        }
        if ($jl_bg_btn === 'yes') {
            $jl_bg_btn = 'jl_sec_btn_bg';
        }        
        $this->add_render_attribute(
            'section_head',
            array(                
                'class' => array('jlcus_sec_title', $section_style, $section_title_font, $section_btn_font, $jl_bg_title, $jl_bg_btn),
            )
        );
        if ( ! empty( $settings['jl_text_url']['url'] ) ) {
            $this->add_link_attributes( 'jl_text_url', $settings['jl_text_url'] );
        }
        if ( ! empty( $settings['jl_btn_url']['url'] ) ) {
            $this->add_link_attributes( 'jl_btn_url', $settings['jl_btn_url'] );
        }                                
        ?>
          <div <?php echo $this->get_render_attribute_string( 'section_head' ); ?>>
            <div class="jlcus_sect_inner">
                  <?php if(!empty($section_title)){?>
                  <<?php echo esc_html($tag); ?> class="jl-heading-text">            
                        <span>
                            <?php if ( ! empty( $settings['jl_text_url']['url'] ) ) {?>
                            <a <?php echo $this->get_render_attribute_string( 'jl_text_url' ); ?> class="jlopt-text-link">
                            <?php }?>
                                <?php echo esc_html($section_title); ?>
                            <?php if ( ! empty( $settings['jl_text_url']['url'] ) ) {?>
                            </a>
                            <?php }?>
                        </span>            
                  </<?php echo esc_html($tag); ?>>
                  <?php }?>                  
                  <?php if(!empty($section_btn_text)){?>
                  <p class="jl_sct_bt">
                        <?php if ( ! empty( $settings['jl_btn_url']['url'] ) ) {?>
                        <a <?php echo $this->get_render_attribute_string( 'jl_btn_url' ); ?> class="jlopt-text-link">
                        <?php }?>
                        <span class="jl_bt_inner">
                        <span><?php echo esc_html($section_btn_text);?></span>
                        <?php if ($jl_show_icons === 'yes') {?>
                            <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 64 64" viewBox="8.1 8.1 47.8 47.8"><g transform="translate(28 328)"><path fill="currentColor" d="M4-272.1c-13.2 0-23.9-10.7-23.9-23.9S-9.2-319.9 4-319.9s23.9 10.7 23.9 23.9S17.2-272.1 4-272.1zm0-45.2c-11.7 0-21.3 9.6-21.3 21.3s9.6 21.3 21.3 21.3 21.3-9.6 21.3-21.3-9.6-21.3-21.3-21.3z"></path><path fill="currentColor" d="m3.5-282.3-1.8-1.9L13.4-296 1.7-307.8l1.8-1.9L17.2-296 3.5-282.3"></path><path fill="currentColor" d="M15.3-294.6h-24v-2.8h24z"></path></g></svg>
                        <?php }?>
                        </span>
                        <?php if ( ! empty( $settings['jl_btn_url']['url'] ) ) {?>
                        </a>
                        <?php }?>
                  </p>
                  <?php }?>
            </div>                    
            <?php if (!empty($section_desc)) {?><p class="jl_sct_sub"><?php echo $section_desc;?></p><?php }?>
          </div>                    
    <?php  
    }    
}