<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
if ( ! class_exists( 'wesper_font_view' ) ) :
	class wesper_font_view {
		private static $instance = null;
		protected $parent_menu_slug = 'jlwelcome.php';
		protected static $edit_repeater_field_count = 0;
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}
		public function __construct() {
			add_action( 'admin_menu', array( $this, 'register_custom_fonts_menu' ), 101 );
			add_action( 'admin_head', array( $this, 'custom_fonts_menu_highlight' ) );

			add_filter( 'manage_edit-' . wesper_font_tax::$register_taxonomy_slug . '_columns', array( $this, 'manage_columns' ) );

			add_action( wesper_font_tax::$register_taxonomy_slug . '_add_form_fields', array( $this, 'add_new_taxonomy_data' ) );
			add_action( wesper_font_tax::$register_taxonomy_slug . '_edit_form_fields', array( $this, 'edit_new_taxonomy_data' ) );

			add_action( 'edited_' . wesper_font_tax::$register_taxonomy_slug, array( $this, 'save_metadata' ) );
			add_action( 'create_' . wesper_font_tax::$register_taxonomy_slug, array( $this, 'save_metadata' ) );

			add_filter( 'upload_mimes', array( $this, 'add_fonts_to_allowed_mimes' ) );
			add_filter( 'wp_check_filetype_and_ext', array( $this, 'update_mime_types' ), 10, 3 );
		}
		public function register_custom_fonts_menu() {

			$title = apply_filters( 'jl_custom_fonts_menu_title', __( 'Custom Fonts', 'custom-fonts' ) );
			add_submenu_page(
				$this->parent_menu_slug,
				$title,
				$title,
				wesper_font_tax::$capability,
				'edit-tags.php?taxonomy=' . wesper_font_tax::$register_taxonomy_slug
			);

		}

		public function custom_fonts_menu_highlight() {
			global $parent_file, $submenu_file;

			if ( 'edit-tags.php?taxonomy=' . wesper_font_tax::$register_taxonomy_slug === $submenu_file ) {
				$parent_file = $this->parent_menu_slug;
			}
			if ( get_current_screen()->id != 'edit-' . wesper_font_tax::$register_taxonomy_slug ) {
				return;
			}

			?><style>.term-font-display-wrap{ display: none; } .jl_btn_wrapf{ display: flex; } .jl_btn_wrapf input[type=text]{ margin-right: 5px; }#addtag div.form-field.term-display-wrap, #edittag tr.form-field.term-display-wrap, #addtag div.form-field.term-slug-wrap, #edittag tr.form-field.term-slug-wrap, #addtag div.form-field.term-description-wrap, #edittag tr.form-field.term-description-wrap, #addtag div.form-field.term-font_fallback-wrap, #edittag tr.form-field.term-font_fallback-wrap { display: none; } .jl-custom-fonts-file-wrap select{display: block;}.jl-custom-fonts-file-wrap { margin-bottom: 15px; }</style>
				<script>jQuery( document ).ready( function( $ ) {
					var $wrapper = $( '#addtag, #edittag' );
					$wrapper.find( 'tr.form-field.term-name-wrap p, div.form-field.term-name-wrap > p' ).text( '<?php esc_html_e( 'The name of the font as it appears in the customizer options.', 'custom-fonts' ); ?>' );
				} );</script>
				<?php
		}

		public function manage_columns( $columns ) {

			$screen = get_current_screen();
			if ( isset( $screen->base ) && 'edit-tags' == $screen->base ) {
				$old_columns = $columns;
				$columns     = array(
					'cb'   => $old_columns['cb'],
					'name' => $old_columns['name'],
				);

			}
			return $columns;
		}

		public function add_new_taxonomy_data() {
			$this->add_new_taxonomy_default_data();
			?>
			<input type="hidden" name="repeater-field-count" value="1">
			<?php
			echo '
			<div id="repeater">
                <!-- Repeater Heading -->
                
                <div class="clearfix"></div>
                <!-- Repeater Items -->
                <div id="item-0" class="cf-jl-items" data-group="font-weight-type">
                    <!-- Repeater Content -->
                    <div class="item-content">
						<div class="form-group">
						<div class="weight-wrapper">';
							$this->add_new_taxonomy_repeater_data();
							wp_nonce_field( basename( __FILE__ ), 'jl_custom_font_nonce' );
							echo '</div>
					  </div>
                    </div>                    
                    <div class="clearfix"></div>
                </div>
            </div>
			';
		}

		public function add_new_taxonomy_default_data() {
			$this->font_new_field( 'font_fallback', __( 'Font Fallback', 'custom-fonts' ), __( 'Add the font\'s fallback names with comma(,) separator.  eg. Arial, Serif', 'custom-fonts' ) );

			$this->select_default_new_field(
				'font-display',
				__( 'Font Display', 'custom-fonts' ),
				__( 'Select font-display property for this font', 'custom-fonts' ),
				array(
					'auto'     => 'auto',
					'block'    => 'block',
					'swap'     => 'swap',
					'fallback' => 'fallback',
					'optional' => 'optional',
				)
			);
		}

		public function add_new_taxonomy_repeater_data() {
			$this->select_new_field(
				'font-weight-0',
				__( 'Font weight', 'custom-fonts' ),
				__( 'Select font-weight property for this font', 'custom-fonts' ),
				array(
					'100' => __( 'Thin 100', 'custom-fonts' ),
					'200' => __( 'Extra-Light 200', 'custom-fonts' ),
					'300' => __( 'Light 300', 'custom-fonts' ),
					'400' => __( 'Normal 400', 'custom-fonts' ),
					'500' => __( 'Medium 500', 'custom-fonts' ),
					'600' => __( 'Semi-Bold 600', 'custom-fonts' ),
					'700' => __( 'Bold 700', 'custom-fonts' ),
					'800' => __( 'Extra-Bold 800', 'custom-fonts' ),
					'900' => __( 'Ultra-Bold 900', 'custom-fonts' ),
				)
			);
			$this->font_file_new_field( 'font_woff_2-0', __( 'Font .woff2', 'custom-fonts' ), __( 'Upload the font\'s woff2 file or enter the URL.', 'custom-fonts' ) );
			$this->font_file_new_field( 'font_woff-0', __( 'Font .woff', 'custom-fonts' ), __( 'Upload the font\'s woff file or enter the URL.', 'custom-fonts' ) );
			$this->font_file_new_field( 'font_ttf-0', __( 'Font .ttf', 'custom-fonts' ), __( 'Upload the font\'s ttf file or enter the URL.', 'custom-fonts' ) );
			$this->font_file_new_field( 'font_eot-0', __( 'Font .eot', 'custom-fonts' ), __( 'Upload the font\'s eot file or enter the URL.', 'custom-fonts' ) );
			$this->font_file_new_field( 'font_svg-0', __( 'Font .svg', 'custom-fonts' ), __( 'Upload the font\'s svg file or enter the URL.', 'custom-fonts' ) );
			$this->font_file_new_field( 'font_otf-0', __( 'Font .otf', 'custom-fonts' ), __( 'Upload the font\'s otf file or enter the URL.', 'custom-fonts' ) );
		}

		public function edit_new_taxonomy_data( $term ) {

			$data = wesper_font_tax::get_font_links( $term->term_id );
			$this->edit_new_taxonomy_default_data( $term );
			?>
			<tr>
			<th></th>
			<td>
			<div id="repeater">
				<div class="clearfix"></div>
			<?php foreach ( $data as $key => $value ) { ?>
				<?php $this->edit_taxonomy_repeater_data( $key, $value ); ?>
			<?php	} ?>
			<input type="hidden" name="repeater-field-count" value="<?php echo esc_attr( self::$edit_repeater_field_count ); ?>">
			<?php wp_nonce_field( basename( __FILE__ ), 'jl_custom_font_nonce' ); ?>
			</div>
			</td>
			</tr>
			<?php

		}

		public function edit_new_taxonomy_default_data( $term ) {
			$data = wesper_font_tax::get_font_links( $term->term_id );
			$this->font_edit_field( 'font_fallback', __( 'Font Fallback', 'custom-fonts' ), __( 'Add the font\'s fallback names with comma(,) separator.  eg. Arial, Serif', 'custom-fonts' ), $data['font_fallback'] );

			$this->select_default_edit_field(
				'font-display',
				__( 'Font Display', 'custom-fonts' ),
				__( 'Select font-display property for this font', 'custom-fonts' ),
				array(
					'auto'     => 'Auto',
					'block'    => 'Block',
					'swap'     => 'Swap',
					'fallback' => 'Fallback',
					'optional' => 'Optional',
				),
				$data['font-display']
			);

		}

		public function edit_taxonomy_repeater_data( $key, $value ) {
			if ( strpos( $key, 'font-weight' ) !== false ) {
				?>
				<div id="<?php echo esc_attr( 'item-' . self::$edit_repeater_field_count ); ?>" class="cf-jl-items" data-group="font-weight-type">
						<div class="item-content">
							<div class="form-group">
							<?php
							$this->select_new_field(
								$key,
								__( 'Font weight', 'custom-fonts' ),
								__( 'Select font-weight property for this font', 'custom-fonts' ),
								array(
									'100' => __( 'Thin 100', 'custom-fonts' ),
									'200' => __( 'Extra-Light 200', 'custom-fonts' ),
									'300' => __( 'Light 300', 'custom-fonts' ),
									'400' => __( 'Normal 400', 'custom-fonts' ),
									'500' => __( 'Medium 500', 'custom-fonts' ),
									'600' => __( 'Semi-Bold 600', 'custom-fonts' ),
									'700' => __( 'Bold 700', 'custom-fonts' ),
									'800' => __( 'Extra-Bold 800', 'custom-fonts' ),
									'900' => __( 'Ultra-Bold 900', 'custom-fonts' ),

								),
								$value
							);
							self::$edit_repeater_field_count++;
			} elseif ( strpos( $key, 'font_woff_2-' ) !== false ) {
				$this->font_file_edit_field( 'font_woff_2', __( 'Font .woff2', 'custom-fonts' ), __( 'Upload the font\'s woff2 file or enter the URL.', 'custom-fonts' ), $value, $key );
			} elseif ( strpos( $key, 'font_woff-' ) !== false ) {
				$this->font_file_edit_field( 'font_woff', __( 'Font .woff', 'custom-fonts' ), __( 'Upload the font\'s woff file or enter the URL.', 'custom-fonts' ), $value, $key );
			} elseif ( strpos( $key, 'font_ttf' ) !== false ) {
				$this->font_file_edit_field( 'font_ttf', __( 'Font .ttf', 'custom-fonts' ), __( 'Upload the font\'s ttf file or enter the URL.', 'custom-fonts' ), $value, $key );
			} elseif ( strpos( $key, 'font_eot' ) !== false ) {
				$this->font_file_edit_field( 'font_eot', __( 'Font .eot', 'custom-fonts' ), __( 'Upload the font\'s eot file or enter the URL.', 'custom-fonts' ), $value, $key );
			} elseif ( strpos( $key, 'font_svg' ) !== false ) {
				$this->font_file_edit_field( 'font_svg', __( 'Font .svg', 'custom-fonts' ), __( 'Upload the font\'s svg file or enter the URL.', 'custom-fonts' ), $value, $key );
			} elseif ( strpos( $key, 'font_otf' ) !== false ) {
				$this->font_file_edit_field( 'font_otf', __( 'Font .otf', 'custom-fonts' ), __( 'Upload the font\'s otf file or enter the URL.', 'custom-fonts' ), $value, $key );
				?>

						</div>
					</div>					
					<div class="clearfix"></div>
				</div>
				<?php
			} else {
				return;
			}
		}

		protected function font_new_field( $id, $title, $description, $value = '' ) {
			?>
			<div class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap" >

				<label for="font-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $title ); ?></label>
				<input type="text" id="font-<?php echo esc_attr( $id ); ?>" class="jl-custom-fonts-link <?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( wesper_font_tax::$register_taxonomy_slug ); ?>[<?php echo esc_attr( $id ); ?>]" value="<?php echo esc_attr( $value ); ?>" />
				<p><?php echo esc_html( $description ); ?></p>
			</div>
			<?php
		}

		protected function font_file_new_field( $id, $title, $description, $value = '' ) {
			?>
			<div class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap" >

				<label for="font-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $title ); ?></label>
				<div class="jl_btn_wrapf">
				<input type="text" id="font-<?php echo esc_attr( $id ); ?>" class="jl-custom-fonts-link <?php echo esc_attr( $id ); ?>" data-name="<?php echo '[' . esc_attr( $id ) . ']'; ?>" name="jl_custom_fonts<?php echo '[' . esc_attr( $id ) . ']'; ?>" value="<?php echo esc_attr( $value ); ?>" />
				<a href="#" class="jl-custom-fonts-upload button" data-upload-type="<?php echo esc_attr( $id ); ?>"><?php esc_html_e( 'Upload', 'custom-fonts' ); ?></a>
				</div>
				<p><?php echo esc_html( $description ); ?></p>
			</div>
			<?php
		}

		protected function select_default_new_field( $id, $title, $description, $select_fields ) {
			?>
			<div class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap" >
				<label for="font-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $title ); ?></label>
				<select type="select" id="font-<?php echo esc_attr( $id ); ?>" class="jl-custom-font-select-field <?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( wesper_font_tax::$register_taxonomy_slug ); ?>[<?php echo esc_attr( $id ); ?>]" />
					<?php
					foreach ( $select_fields as $key => $value ) {
						?>
						<option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value ); ?></option>;
					<?php } ?>
				</select>
			</div>
			<?php
		}

		protected function select_default_edit_field( $id, $title, $description, $select_fields, $selected ) {
			?>
			<tr class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap" >
				<th><label for="font-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $title ); ?></label></th>
				<td>
				<select type="select" id="font-<?php echo esc_attr( $id ); ?>" class="jl-custom-font-select-field <?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( wesper_font_tax::$register_taxonomy_slug ); ?>[<?php echo esc_attr( $id ); ?>]" />
					<?php
					foreach ( $select_fields as $key => $value ) {
						?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php echo ( $key == $selected ) ? ' selected="selected"' : ''; ?> ><?php echo esc_html( $value ); ?></option>;
					<?php } ?>
				</select>
				<td>
			</tr>
			<?php
		}

		protected function select_new_field( $id, $title, $description, $select_fields, $selected_value = '' ) {
			?>
			<div class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap" >
				<label for="font-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $title ); ?></label>
				<select type="select" id="font-<?php echo esc_attr( $id ); ?>" class="jl-custom-font-select-field <?php echo esc_attr( $id ); ?>" data-name="<?php echo '[' . esc_attr( $id ) . ']'; ?>" name="jl_custom_fonts<?php echo '[' . esc_attr( $id ) . ']'; ?>" />
					<?php
					foreach ( $select_fields as $key => $value ) {
						?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php echo $selected_value == $key ? 'selected="selected"' : ''; ?>><?php echo esc_html( $value ); ?></option>
					<?php } ?>
				</select>
			</div>
			<?php
		}

		private function select_edit_field( $id, $title, $description, $select_fields, $saved_val = '' ) {
			?>
			<tr class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap ">
				<th scope="row">
					<label for="metadata-<?php echo esc_attr( $id ); ?>">
						<?php echo esc_html( $title ); ?>
					</label>
				</th>
				<td>
				<select type="select" id="font-<?php echo esc_attr( $id ); ?>" class="jl-custom-font-select-field <?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( wesper_font_tax::$register_taxonomy_slug ); ?>[<?php echo esc_attr( $id ); ?>]" />
					<?php
					foreach ( $select_fields as $key => $value ) {
						?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $saved_val ); ?>><?php echo esc_html( $value ); ?></option>;
					<?php } ?>
				</select>
					<p><?php echo esc_html( $description ); ?></p>
				</td>
			</tr>
			<?php
		}

		protected function font_edit_field( $id, $title, $description, $value = '' ) {
			?>
			<tr class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap ">
				<th scope="row">
					<label for="metadata-<?php echo esc_attr( $id ); ?>">
						<?php echo esc_html( $title ); ?>
					</label>
				</th>
				<td>
					<input id="metadata-<?php echo esc_attr( $id ); ?>" type="text" class="jl-custom-fonts-link <?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( wesper_font_tax::$register_taxonomy_slug ); ?>[<?php echo esc_attr( $id ); ?>]" value="<?php echo esc_attr( $value ); ?>" />
					<p><?php echo esc_html( $description ); ?></p>
				</td>
			</tr>
			<?php
		}

		protected function font_file_edit_field( $id, $title, $description, $value, $key ) {
			?>
			<div class="jl-custom-fonts-file-wrap form-field term-<?php echo esc_attr( $id ); ?>-wrap ">
				<div scope="row">
					<label for="metadata-<?php echo esc_attr( $id ); ?>">
						<?php echo esc_html( $title ); ?>
					</label>
				</div>
				<div>
					<div class="jl_btn_wrapf">
					<input id="metadata-<?php echo esc_attr( $id ); ?>" type="text" class="jl-custom-fonts-link <?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( wesper_font_tax::$register_taxonomy_slug ); ?>[<?php echo esc_attr( $key ); ?>]" value="<?php echo esc_attr( $value ); ?>" />
					<a href="#" class="jl-custom-fonts-upload button" data-upload-type="<?php echo esc_attr( $id ); ?>"><?php esc_html_e( 'Upload', 'custom-fonts' ); ?></a>
					</div>
					<p><?php echo esc_html( $description ); ?></p>
				</div>
			</div>
			<?php
		}

		public function save_metadata( $term_id ) {
			if ( ! isset( $_POST['jl_custom_font_nonce'] ) || ! wp_verify_nonce( $_POST['jl_custom_font_nonce'], basename( __FILE__ ) ) ) {
				return;
			}

			if ( isset( $_POST[ wesper_font_tax::$register_taxonomy_slug ] ) ) {
				$value = $_POST[ wesper_font_tax::$register_taxonomy_slug ];
				wesper_font_tax::update_font_links( $value, $term_id );
			}
		}
		public function add_fonts_to_allowed_mimes( $mimes ) {
			$mimes['woff']  = 'application/x-font-woff';
			$mimes['woff2'] = 'application/x-font-woff2';
			$mimes['ttf']   = 'application/x-font-ttf';
			$mimes['svg']   = 'image/svg+xml';
			$mimes['eot']   = 'application/vnd.ms-fontobject';
			$mimes['otf']   = 'font/otf';

			return $mimes;
		}

		public function update_mime_types( $defaults, $file, $filename ) {
			if ( 'ttf' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
				$defaults['type'] = 'application/x-font-ttf';
				$defaults['ext']  = 'ttf';
			}

			if ( 'otf' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
				$defaults['type'] = 'application/x-font-otf';
				$defaults['ext']  = 'otf';
			}

			return $defaults;
		}

	}

	wesper_font_view::get_instance();

endif;
