<?php
// update_option( 'category_color_options', '#ff0000' );

/**
 * Version 0.0.3
 *
 * This file is just an example you can copy it to your theme and modify it to fit your own needs.
 * Watch the paths though.
 */
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// Don't duplicate me!
if ( !class_exists( 'Radium_Theme_Demo_Data_Importer' ) ) {

	require_once( plugin_dir_path( __FILE__ ) . 'importer/radium-importer.php' );

	class Radium_Theme_Demo_Data_Importer extends Radium_Theme_Importer {

		/**
		 * Set framewok
		 *
		 * options that can be used are 'default', 'radium' or 'optiontree'
		 *
		 * @since 0.0.3
		 *
		 * @var string
		 */
		public $theme_options_framework = 'customizer';

		/**
		 * Holds a copy of the object for easy reference.
		 *
		 * @since 0.0.1
		 *
		 * @var object
		 */
		private static $instance;

		/**
		 * Set the key to be used to store theme options
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $theme_option_name       = 'INHYPE_PANEL'; //set theme options name here (key used to save theme options). Optiontree option name will be set automatically

		/**
		 * Set name of the theme options file
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $theme_options_file_name = 'theme_options.dat';

		/**
		 * Set name of the widgets json file
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $widgets_file_name       = 'widgets.json';

		/**
		 * Set name of the content file
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $content_demo_file_name  = 'content.xml';

		/**
		 * Holds a copy of the widget settings
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $widget_import_results;

		/**
		 * Constructor. Hooks all interactions to initialize the class.
		 *
		 * @since 0.0.1
		 */

		// public static function init_filesystem() {

		// 	if ( ! defined( 'FS_METHOD' ) ) {
		// 		define( 'FS_METHOD', 'direct' );
		// 	}
	
		// 	global $wp_filesystem;
	
		// 	if ( empty( $wp_filesystem ) ) {
		// 		require_once( ABSPATH . '/wp-admin/includes/file.php' );
		// 		WP_Filesystem();
		// 	}
	
		// 	return $wp_filesystem;
		// }

		// public function temp_folder($url = false) {
		// 	$this->init_filesystem();
	
		// 	$upload_dir = wp_upload_dir();
		// 	$temp_folder = 'wesper_temp';
		// 	$theme_temp_folder = $upload_dir['basedir'].'/'.$temp_folder;
		// 	if(!file_exists($theme_temp_folder)) {
		// 		wp_mkdir_p( $theme_temp_folder );
		// 	}
		// 	if($url) {
		// 		return $upload_dir['baseurl'].'/'.$temp_folder;
		// 	} else {
		// 		return $theme_temp_folder;
		// 	}
		// }		

		public function __construct() {
			if(!isset($_GET['import_theme_demo'])) {
				$_GET['import_theme_demo'] = 0;
			}
			
				// $this->temp_folder();
				// $temp = $this->temp_folder();
			// 	$wp_filesystem = $this->init_filesystem();				


			$this->demo_files_path = plugin_dir_path( __FILE__ ) . 'demo-files/'.$_GET['import_theme_demo'].'/';
			// $this->demo_files_path = $temp.$_GET['import_theme_demo'].'/';

			self::$instance = $this;
			parent::__construct();

		}

		/**
		 * Add menus - the menus listed here largely depend on the ones registered in the theme
		 *
		 * @since 0.0.1
		 */
		public function set_demo_menus(){

			// Menus to Import and assign - you can remove or add as many as you want

			$top_menu   = get_term_by('slug', 'top-menu', 'nav_menu');
			$main_menu   = get_term_by('slug', 'main-menu', 'nav_menu');
			$mobile_menu = get_term_by('slug', 'mobile-menu', 'nav_menu');
			$footer_menu = get_term_by('slug', 'footer', 'nav_menu');

			// Default demo
			set_theme_mod( 'nav_menu_locations', array(
				'top_menu' => $top_menu->term_id,
				'main_menu' => $main_menu->term_id,
				'mobile_menu' => $main_menu->term_id,
				'footer_menu' => $footer_menu->term_id
				)
			);			

			$front_page = get_page_by_title( "Home" );
			update_option( 'page_on_front', $front_page->ID );
			update_option( 'show_on_front', 'page' );

			$checkout_page = get_page_by_title( "Checkout" );
			update_option( 'woocommerce_checkout_page_id', $checkout_page->ID );

			$cart_page = get_page_by_title( "Cart" );
			update_option( 'woocommerce_cart_page_id', $cart_page->ID );

			$shop_page = get_page_by_title( "Shop" );
			update_option( 'woocommerce_shop_page_id', $shop_page->ID );

			$account_page = get_page_by_title( "My Account" );
			update_option( 'woocommerce_myaccount_page_id', $account_page->ID );


			if($_GET['import_theme_demo'] == 1) {
				$term_cat = get_terms('category');
				if ($term_cat) {
					$i = 0;
					foreach( $term_cat as $tag) {
						$term_id = $tag->term_id;
						if($i == 0){
							update_term_meta( $term_id, 'jelly_header_id', 11459 );
							update_term_meta( $term_id, 'category_color_options', '#dd3333' );						
						}
						if($i == 1){
							update_term_meta( $term_id, 'jelly_header_id', 11444 );
							update_term_meta( $term_id, 'category_color_options', '#8ccc3f' );						
						}
						if($i == 2){
							update_term_meta( $term_id, 'jelly_header_id', 11470 );
							update_term_meta( $term_id, 'category_color_options', '#e8af20' );						
						}
						if($i == 3){
							update_term_meta( $term_id, 'jelly_header_id', 11446 );
							update_term_meta( $term_id, 'category_color_options', '#228fd8' );						
						}
						if($i == 4){
							update_term_meta( $term_id, 'jelly_header_id', 11459 );
							update_term_meta( $term_id, 'category_color_options', '#8224e3' );						
						}
						if($i == 5){
							update_term_meta( $term_id, 'jelly_header_id', 11455 );
							update_term_meta( $term_id, 'category_color_options', '#40d1d1' );						
						}
						$i++;
					}
				}
			}

			if($_GET['import_theme_demo'] == 3) {
				$term_cat = get_terms('category');
				if ($term_cat) {
					$i = 0;
					foreach( $term_cat as $tag) {
						$term_id = $tag->term_id;
						if($i == 0){
							update_term_meta( $term_id, 'jelly_header_id', 11981 );
							update_term_meta( $term_id, 'category_color_options', '#00ab4a' );						
						}
						if($i == 1){
							update_term_meta( $term_id, 'jelly_header_id', 11963 );
							update_term_meta( $term_id, 'category_color_options', '#f22717' );						
						}
						if($i == 2){
							update_term_meta( $term_id, 'jelly_header_id', 11966 );
							update_term_meta( $term_id, 'category_color_options', '#f526d6' );						
						}
						if($i == 3){							
							update_term_meta( $term_id, 'category_color_options', '#ff5722' );						
						}
						if($i == 4){
							update_term_meta( $term_id, 'category_color_options', '#5800ab' );						
						}
						if($i == 5){
							update_term_meta( $term_id, 'category_color_options', '#f8ce0a' );						
						}
						$i++;
					}
				}
			}
			
			if($_GET['import_theme_demo'] == 10) {
				$term_cat = get_terms('category');
				if ($term_cat) {
					$i = 0;
					foreach( $term_cat as $tag) {
						$term_id = $tag->term_id;
						if($i == 0){
							update_term_meta( $term_id, 'jelly_header_id', 12521 );
							update_term_meta( $term_id, 'category_color_options', '#64a51d' );						
						}
						if($i == 1){
							update_term_meta( $term_id, 'jelly_header_id', 12520 );
							update_term_meta( $term_id, 'category_color_options', '#ff2905' );						
						}
						if($i == 2){
							update_term_meta( $term_id, 'jelly_header_id', 12504 );
							update_term_meta( $term_id, 'category_color_options', '#d3bb00' );						
						}
						if($i == 3){
							update_term_meta( $term_id, 'jelly_header_id', 12517 );
							update_term_meta( $term_id, 'category_color_options', '#006ff6' );						
						}
						if($i == 4){
							update_term_meta( $term_id, 'jelly_header_id', 12527 );
							update_term_meta( $term_id, 'category_color_options', '#1da5ba' );						
						}
						if($i == 5){
							update_term_meta( $term_id, 'jelly_header_id', 12495 );
							update_term_meta( $term_id, 'category_color_options', '#8224e3' );						
						}
						$i++;
					}
				}
			}	
			
			if($_GET['import_theme_demo'] == 11) {
				$term_cat = get_terms('category');
				if ($term_cat) {
					$i = 0;
					foreach( $term_cat as $tag) {
						$term_id = $tag->term_id;
						if($i == 0){
							update_term_meta( $term_id, 'jelly_header_id', 14230 );
							update_term_meta( $term_id, 'category_color_options', '#dd3333' );						
						}
						if($i == 1){
							update_term_meta( $term_id, 'jelly_header_id', 14231 );
							update_term_meta( $term_id, 'category_color_options', '#8224e3' );						
						}
						if($i == 2){
							update_term_meta( $term_id, 'jelly_header_id', 14227 );
							update_term_meta( $term_id, 'category_color_options', '#bbc63d' );						
						}
						if($i == 3){
							update_term_meta( $term_id, 'jelly_header_id', 14228 );
							update_term_meta( $term_id, 'category_color_options', '#eaa504' );						
						}
						if($i == 4){
							update_term_meta( $term_id, 'jelly_header_id', 14229 );
							update_term_meta( $term_id, 'category_color_options', '#3bbf62' );						
						}
						if($i == 5){
							update_term_meta( $term_id, 'category_color_options', '#4133dd' );						
						}
						$i++;
					}
				}
			}	
			
			$this->flag_as_imported['menus'] = true;
		}

	}

	new Radium_Theme_Demo_Data_Importer;
}