<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init','wesper_widget_layouts');
function wesper_widget_layouts(){
		register_widget("wesper_widget_add_layouts");
}

class wesper_widget_add_layouts extends WP_widget{

/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/

	public function __construct() {
		$widget_ops = array( 'classname' => 'jl_cus_layouts_widget', 'description' => esc_html__( 'Add custom layouts' , 'wesper') );
		parent::__construct('wesper_widget_add_layouts', esc_html__('&nbsp;Custom layouts', 'wesper'), $widget_ops);
	}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget($args,$instance){
	extract($args);		
		$jllayout = isset($instance["jllayout"]) ? $instance["jllayout"] : "";
		?>
<?php print $before_widget;?>
<div class="widget_jl_wrapper jl-cuslayouts-wrapper">
    <div class="jl_cuslayouts_inner">
		<?php if ( ! empty( $jllayout ) ) {
			echo do_shortcode( '[jl_layout id="' . esc_attr($jllayout) . '"]' );
		} ?>
	</div>
    <?php
	print $after_widget;
	print "</div>";
	}

/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['jllayout'] = $new_instance['jllayout'];
		return $instance;
	}

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/

	function form( $instance ) {
		?>
    <?php
			$jllayout = isset($instance['jllayout']) ? esc_attr($instance['jllayout']) : '';
		?>

    <p>
    <label for="<?php echo esc_attr($this->get_field_id('jllayout')); ?>">
    	<?php esc_html_e('Choose your layouts:', 'wesper');?>
 	</label>
        <?php
        $options       = array();
		$custom_layouts = get_posts( 'post_type="jl_layout"&numberposts=-1' );
		if ( ! empty( $custom_layouts ) ) {
				$options[''] = esc_html__( 'Default', 'wesper' );
			foreach ( $custom_layouts as $add_layouts ) {
				$options[ $add_layouts->ID ] = esc_html( $add_layouts->post_title );
			}
		}	
		?>

		<select id="<?php echo $this->get_field_id('jllayout'); ?>" name="<?php echo $this->get_field_name('jllayout'); ?>" class="widefat" style="width:100%;">
            <option><?php esc_html_e( 'Default', 'wesper' );?></option>
            <?php 
            if ( ! empty( $custom_layouts ) ) {            
            	foreach ( $custom_layouts as $add_layouts ) {?>
            <option <?php if ( !empty($instance['jllayout']) ) { selected( $instance['jllayout'], $add_layouts->ID ); } ?> value="<?php echo $add_layouts->ID; ?>">
            	<?php esc_html_e( $add_layouts->post_title ) ?>
            </option>
            <?php }}?>
        </select>
</p>
    <?php
	}
}
?>