<?php
if ( ! class_exists( 'wesper_customizer_default' ) ) {
	final class wesper_customizer_default {
		private static $instance = null;
		private $wp_customize;
		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		private function __construct() {
			add_action( 'customize_controls_print_scripts', array( $this, 'wesper_customize_controls_print_scripts' ) );
			add_action( 'wp_ajax_customizer_reset', array( $this, 'wesper_ajax_customizer_reset' ) );
			add_action( 'customize_register', array( $this, 'wesper_customize_register' ) );
		}

		public function wesper_customize_controls_print_scripts() {
			wp_enqueue_style( 'css-for-customize', get_template_directory_uri() . '/inc/customizer/css/customizer-control.css' );
			wp_enqueue_script( 'js-for-customize', get_template_directory_uri() . '/inc/customizer/js/customizer-control.js', array( 'jquery', 'customize-controls' ) );
			wp_localize_script( 'js-for-customize', 'wesper_customizer_reset', array(
				'reset'   => esc_html__( 'Reset', 'wesper' ),
				'confirm' => esc_html__( "Clicking the Reset button will revert all settings in the customizer except for menus, widgets and site identity.", 'wesper' ),
				'nonce'   => array(
					'reset' => wp_create_nonce( 'customizer-reset' ),
				)
			) );
		}
		public function wesper_customize_register( $wp_customize ) {
			$this->wp_customize = $wp_customize;
		}

		public function wesper_ajax_customizer_reset() {
			if ( ! $this->wp_customize->is_preview() ) {
				wp_send_json_error( 'not_preview' );
			}
			if ( ! check_ajax_referer( 'customizer-reset', 'nonce', false ) ) {
				wp_send_json_error( 'invalid_nonce' );
			}
			$this->wesper_reset_customizer();
			wp_send_json_success();
		}
		public function wesper_reset_customizer() {
			$settings = $this->wp_customize->settings();
			foreach ( $settings as $setting ) {
				if ( 'theme_mod' == $setting->type ) {
					remove_theme_mod( $setting->id );
				}
			}
		}
	}
}
wesper_customizer_default::get_instance();

function wesper_register_theme_customizer( $wp_customize ) {
	class wesper_control_image_select extends WP_Customize_Control {
	    public function render_content(){
	        if ( empty( $this->choices ) ){ return; }
	        if ( ! empty( $this->label ) ) : ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php endif;
				if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo esc_html($this->description) ; ?></span>
			<?php endif;
	        $html = array();
			$tpl  = '<label class="jlc-image-select"><img src="%s"><input type="%s" class="hidden" name="%s" value="%s" %s%s></label>';
			$field = $this->input_attrs;
			foreach ( $this->choices as $value => $image )
			{
				$html[] = sprintf(
					$tpl,
					$image,
					$field['multiple'] ? 'checkbox' : 'radio',
					$this->id,
					esc_attr( $value ),
					$this->get_link(),
					checked( $this->value(), $value, false )
				);
			}
			echo implode(' ', $html);
	    }
	}
	// Header text
	class wesper_Customize_Control_Title extends WP_Customize_Control {
	    public function render_content(){
	        if ( empty( $this->label ) ){ return; }
	        if ( ! empty( $this->label ) ) : ?>
					<h2 class="jlc_headding"><?php echo esc_html( $this->label ); ?>
				<?php endif;
				if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo esc_html($this->description) ; ?></span>
			</h2><?php endif;
	    }
	}

	$option_sidebar = array();
	$sidebars = get_option('sbg_sidebars');
	$option_sidebar['default']= esc_html__( 'Default Sidebar', 'wesper' );
	if(isset($sidebars)) {
		if(is_array($sidebars)) {
			foreach($sidebars as $sidebar) {
				$sidebar_lower = strtolower($sidebar);
				$sidebarid = str_replace(' ','-', $sidebar_lower);
				$option_sidebar[$sidebarid] = $sidebar;
			}
		}
	}

	//Layouts
	$args = array(
		'post_type'     => 'jl_layout',
		'post_status'   => array( 'publish' ),
		'numberposts'   => -1,
		'orderby'       => 'title',
		'order'         => 'ASC',
		'suppress_filters'   => false
   );
   $layouts = get_posts($args);
   $jl_layouts = array();
   $jl_layouts['default']= esc_html__( 'Default Layout', 'wesper' );
   
   if(!empty($layouts)){
	   foreach ($layouts as $layout){
		   $jl_layouts[$layout->ID] = $layout->post_title;
	   }
   }

	// Custom fonts
	$jl_custom_font = array();
	if(function_exists('wesper_bac_PostViews')){
		$fonts = wesper_font_tax::wesper_get_fonts();
		if ( empty ($fonts)) {
			$jl_custom_font = array();
		}else{
			foreach ( $fonts as $font => $values ) {
				$jl_custom_font['jl_c_'.$font] = 'Custom font - '.$font;
			}
		}
	}else{
		$jl_custom_font = array();
	}

	// Font and Google Font
	$jl_google_font = array(
	'ABeeZee' => 'ABeeZee',
	'Abel' => 'Abel',
	'Abhaya Libre' => 'Abhaya Libre',
	'Abril Fatface' => 'Abril Fatface',
	'Aclonica' => 'Aclonica',
	'Acme' => 'Acme',
	'Actor' => 'Actor',
	'Adamina' => 'Adamina',
	'Advent Pro' => 'Advent Pro',
	'Aguafina Script' => 'Aguafina Script',
	'Akaya Kanadaka' => 'Akaya Kanadaka',
	'Akaya Telivigala' => 'Akaya Telivigala',
	'Akronim' => 'Akronim',
	'Aladin' => 'Aladin',
	'Alata' => 'Alata',
	'Alatsi' => 'Alatsi',
	'Aldrich' => 'Aldrich',
	'Alef' => 'Alef',
	'Alegreya' => 'Alegreya',
	'Alegreya SC' => 'Alegreya SC',
	'Alegreya Sans' => 'Alegreya Sans',
	'Alegreya Sans SC' => 'Alegreya Sans SC',
	'Aleo' => 'Aleo',
	'Alex Brush' => 'Alex Brush',
	'Alfa Slab One' => 'Alfa Slab One',
	'Alice' => 'Alice',
	'Alike' => 'Alike',
	'Alike Angular' => 'Alike Angular',
	'Allan' => 'Allan',
	'Allerta' => 'Allerta',
	'Allerta Stencil' => 'Allerta Stencil',
	'Allison' => 'Allison',
	'Allura' => 'Allura',
	'Almarai' => 'Almarai',
	'Almendra' => 'Almendra',
	'Almendra Display' => 'Almendra Display',
	'Almendra SC' => 'Almendra SC',
	'Alumni Sans' => 'Alumni Sans',
	'Amarante' => 'Amarante',
	'Amaranth' => 'Amaranth',
	'Amatic SC' => 'Amatic SC',
	'Amethysta' => 'Amethysta',
	'Amiko' => 'Amiko',
	'Amiri' => 'Amiri',
	'Amita' => 'Amita',
	'Anaheim' => 'Anaheim',
	'Andada Pro' => 'Andada Pro',
	'Andika' => 'Andika',
	'Andika New Basic' => 'Andika New Basic',
	'Angkor' => 'Angkor',
	'Annie Use Your Telescope' => 'Annie Use Your Telescope',
	'Anonymous Pro' => 'Anonymous Pro',
	'Antic' => 'Antic',
	'Antic Didone' => 'Antic Didone',
	'Antic Slab' => 'Antic Slab',
	'Anton' => 'Anton',
	'Antonio' => 'Antonio',
	'Arapey' => 'Arapey',
	'Arbutus' => 'Arbutus',
	'Arbutus Slab' => 'Arbutus Slab',
	'Architects Daughter' => 'Architects Daughter',
	'Archivo' => 'Archivo',
	'Archivo Black' => 'Archivo Black',
	'Archivo Narrow' => 'Archivo Narrow',
	'Are You Serious' => 'Are You Serious',
	'Aref Ruqaa' => 'Aref Ruqaa',
	'Arima Madurai' => 'Arima Madurai',
	'Arimo' => 'Arimo',
	'Arizonia' => 'Arizonia',
	'Armata' => 'Armata',
	'Arsenal' => 'Arsenal',
	'Artifika' => 'Artifika',
	'Arvo' => 'Arvo',
	'Arya' => 'Arya',
	'Asap' => 'Asap',
	'Asap Condensed' => 'Asap Condensed',
	'Asar' => 'Asar',
	'Asset' => 'Asset',
	'Assistant' => 'Assistant',
	'Astloch' => 'Astloch',
	'Asul' => 'Asul',
	'Athiti' => 'Athiti',
	'Atkinson Hyperlegible' => 'Atkinson Hyperlegible',
	'Atma' => 'Atma',
	'Atomic Age' => 'Atomic Age',
	'Aubrey' => 'Aubrey',
	'Audiowide' => 'Audiowide',
	'Autour One' => 'Autour One',
	'Average' => 'Average',
	'Average Sans' => 'Average Sans',
	'Averia Gruesa Libre' => 'Averia Gruesa Libre',
	'Averia Libre' => 'Averia Libre',
	'Averia Sans Libre' => 'Averia Sans Libre',
	'Averia Serif Libre' => 'Averia Serif Libre',
	'Azeret Mono' => 'Azeret Mono',
	'B612' => 'B612',
	'B612 Mono' => 'B612 Mono',
	'Bad Script' => 'Bad Script',
	'Bahiana' => 'Bahiana',
	'Bahianita' => 'Bahianita',
	'Bai Jamjuree' => 'Bai Jamjuree',
	'Ballet' => 'Ballet',
	'Baloo 2' => 'Baloo 2',
	'Baloo Bhai 2' => 'Baloo Bhai 2',
	'Baloo Bhaina 2' => 'Baloo Bhaina 2',
	'Baloo Chettan 2' => 'Baloo Chettan 2',
	'Baloo Da 2' => 'Baloo Da 2',
	'Baloo Paaji 2' => 'Baloo Paaji 2',
	'Baloo Tamma 2' => 'Baloo Tamma 2',
	'Baloo Tammudu 2' => 'Baloo Tammudu 2',
	'Baloo Thambi 2' => 'Baloo Thambi 2',
	'Balsamiq Sans' => 'Balsamiq Sans',
	'Balthazar' => 'Balthazar',
	'Bangers' => 'Bangers',
	'Barlow' => 'Barlow',
	'Barlow Condensed' => 'Barlow Condensed',
	'Barlow Semi Condensed' => 'Barlow Semi Condensed',
	'Barriecito' => 'Barriecito',
	'Barrio' => 'Barrio',
	'Basic' => 'Basic',
	'Baskervville' => 'Baskervville',
	'Battambang' => 'Battambang',
	'Baumans' => 'Baumans',
	'Bayon' => 'Bayon',
	'Be Vietnam' => 'Be Vietnam',
	'Be Vietnam Pro' => 'Be Vietnam Pro',
	'Bebas Neue' => 'Bebas Neue',
	'Belgrano' => 'Belgrano',
	'Bellefair' => 'Bellefair',
	'Belleza' => 'Belleza',
	'Bellota' => 'Bellota',
	'Bellota Text' => 'Bellota Text',
	'BenchNine' => 'BenchNine',
	'Benne' => 'Benne',
	'Bentham' => 'Bentham',
	'Berkshire Swash' => 'Berkshire Swash',
	'Besley' => 'Besley',
	'Beth Ellen' => 'Beth Ellen',
	'Bevan' => 'Bevan',
	'Big Shoulders Display' => 'Big Shoulders Display',
	'Big Shoulders Inline Display' => 'Big Shoulders Inline Display',
	'Big Shoulders Inline Text' => 'Big Shoulders Inline Text',
	'Big Shoulders Stencil Display' => 'Big Shoulders Stencil Display',
	'Big Shoulders Stencil Text' => 'Big Shoulders Stencil Text',
	'Big Shoulders Text' => 'Big Shoulders Text',
	'Bigelow Rules' => 'Bigelow Rules',
	'Bigshot One' => 'Bigshot One',
	'Bilbo' => 'Bilbo',
	'Bilbo Swash Caps' => 'Bilbo Swash Caps',
	'BioRhyme' => 'BioRhyme',
	'BioRhyme Expanded' => 'BioRhyme Expanded',
	'Birthstone' => 'Birthstone',
	'Birthstone Bounce' => 'Birthstone Bounce',
	'Biryani' => 'Biryani',
	'Bitter' => 'Bitter',
	'Black And White Picture' => 'Black And White Picture',
	'Black Han Sans' => 'Black Han Sans',
	'Black Ops One' => 'Black Ops One',
	'Blinker' => 'Blinker',
	'Bodoni Moda' => 'Bodoni Moda',
	'Bokor' => 'Bokor',
	'Bona Nova' => 'Bona Nova',
	'Bonbon' => 'Bonbon',
	'Bonheur Royale' => 'Bonheur Royale',
	'Boogaloo' => 'Boogaloo',
	'Bowlby One' => 'Bowlby One',
	'Bowlby One SC' => 'Bowlby One SC',
	'Brawler' => 'Brawler',
	'Bree Serif' => 'Bree Serif',
	'Brygada 1918' => 'Brygada 1918',
	'Bubblegum Sans' => 'Bubblegum Sans',
	'Bubbler One' => 'Bubbler One',
	'Buda' => 'Buda',
	'Buenard' => 'Buenard',
	'Bungee' => 'Bungee',
	'Bungee Hairline' => 'Bungee Hairline',
	'Bungee Inline' => 'Bungee Inline',
	'Bungee Outline' => 'Bungee Outline',
	'Bungee Shade' => 'Bungee Shade',
	'Butcherman' => 'Butcherman',
	'Butterfly Kids' => 'Butterfly Kids',
	'Cabin' => 'Cabin',
	'Cabin Condensed' => 'Cabin Condensed',
	'Cabin Sketch' => 'Cabin Sketch',
	'Caesar Dressing' => 'Caesar Dressing',
	'Cagliostro' => 'Cagliostro',
	'Cairo' => 'Cairo',
	'Caladea' => 'Caladea',
	'Calistoga' => 'Calistoga',
	'Calligraffitti' => 'Calligraffitti',
	'Cambay' => 'Cambay',
	'Cambo' => 'Cambo',
	'Candal' => 'Candal',
	'Cantarell' => 'Cantarell',
	'Cantata One' => 'Cantata One',
	'Cantora One' => 'Cantora One',
	'Capriola' => 'Capriola',
	'Caramel' => 'Caramel',
	'Carattere' => 'Carattere',
	'Cardo' => 'Cardo',
	'Carme' => 'Carme',
	'Carrois Gothic' => 'Carrois Gothic',
	'Carrois Gothic SC' => 'Carrois Gothic SC',
	'Carter One' => 'Carter One',
	'Castoro' => 'Castoro',
	'Catamaran' => 'Catamaran',
	'Caudex' => 'Caudex',
	'Caveat' => 'Caveat',
	'Caveat Brush' => 'Caveat Brush',
	'Cedarville Cursive' => 'Cedarville Cursive',
	'Ceviche One' => 'Ceviche One',
	'Chakra Petch' => 'Chakra Petch',
	'Changa' => 'Changa',
	'Changa One' => 'Changa One',
	'Chango' => 'Chango',
	'Charm' => 'Charm',
	'Charmonman' => 'Charmonman',
	'Chathura' => 'Chathura',
	'Chau Philomene One' => 'Chau Philomene One',
	'Chela One' => 'Chela One',
	'Chelsea Market' => 'Chelsea Market',
	'Chenla' => 'Chenla',
	'Cherish' => 'Cherish',
	'Cherry Cream Soda' => 'Cherry Cream Soda',
	'Cherry Swash' => 'Cherry Swash',
	'Chewy' => 'Chewy',
	'Chicle' => 'Chicle',
	'Chilanka' => 'Chilanka',
	'Chivo' => 'Chivo',
	'Chonburi' => 'Chonburi',
	'Cinzel' => 'Cinzel',
	'Cinzel Decorative' => 'Cinzel Decorative',
	'Clicker Script' => 'Clicker Script',
	'Coda' => 'Coda',
	'Coda Caption' => 'Coda Caption',
	'Codystar' => 'Codystar',
	'Coiny' => 'Coiny',
	'Combo' => 'Combo',
	'Comfortaa' => 'Comfortaa',
	'Comic Neue' => 'Comic Neue',
	'Coming Soon' => 'Coming Soon',
	'Commissioner' => 'Commissioner',
	'Concert One' => 'Concert One',
	'Condiment' => 'Condiment',
	'Content' => 'Content',
	'Contrail One' => 'Contrail One',
	'Convergence' => 'Convergence',
	'Cookie' => 'Cookie',
	'Copse' => 'Copse',
	'Corben' => 'Corben',
	'Cormorant' => 'Cormorant',
	'Cormorant Garamond' => 'Cormorant Garamond',
	'Cormorant Infant' => 'Cormorant Infant',
	'Cormorant SC' => 'Cormorant SC',
	'Cormorant Unicase' => 'Cormorant Unicase',
	'Cormorant Upright' => 'Cormorant Upright',
	'Courgette' => 'Courgette',
	'Courier Prime' => 'Courier Prime',
	'Cousine' => 'Cousine',
	'Coustard' => 'Coustard',
	'Covered By Your Grace' => 'Covered By Your Grace',
	'Crafty Girls' => 'Crafty Girls',
	'Creepster' => 'Creepster',
	'Crete Round' => 'Crete Round',
	'Crimson Pro' => 'Crimson Pro',
	'Crimson Text' => 'Crimson Text',
	'Croissant One' => 'Croissant One',
	'Crushed' => 'Crushed',
	'Cuprum' => 'Cuprum',
	'Cute Font' => 'Cute Font',
	'Cutive' => 'Cutive',
	'Cutive Mono' => 'Cutive Mono',
	'DM Mono' => 'DM Mono',
	'DM Sans' => 'DM Sans',
	'DM Serif Display' => 'DM Serif Display',
	'DM Serif Text' => 'DM Serif Text',
	'Damion' => 'Damion',
	'Dancing Script' => 'Dancing Script',
	'Dangrek' => 'Dangrek',
	'Darker Grotesque' => 'Darker Grotesque',
	'David Libre' => 'David Libre',
	'Dawning of a New Day' => 'Dawning of a New Day',
	'Days One' => 'Days One',
	'Dekko' => 'Dekko',
	'Dela Gothic One' => 'Dela Gothic One',
	'Delius' => 'Delius',
	'Delius Swash Caps' => 'Delius Swash Caps',
	'Delius Unicase' => 'Delius Unicase',
	'Della Respira' => 'Della Respira',
	'Denk One' => 'Denk One',
	'Devonshire' => 'Devonshire',
	'Dhurjati' => 'Dhurjati',
	'Didact Gothic' => 'Didact Gothic',
	'Diplomata' => 'Diplomata',
	'Diplomata SC' => 'Diplomata SC',
	'Do Hyeon' => 'Do Hyeon',
	'Dokdo' => 'Dokdo',
	'Domine' => 'Domine',
	'Donegal One' => 'Donegal One',
	'Doppio One' => 'Doppio One',
	'Dorsa' => 'Dorsa',
	'Dosis' => 'Dosis',
	'DotGothic16' => 'DotGothic16',
	'Dr Sugiyama' => 'Dr Sugiyama',
	'Duru Sans' => 'Duru Sans',
	'Dynalight' => 'Dynalight',
	'EB Garamond' => 'EB Garamond',
	'Eagle Lake' => 'Eagle Lake',
	'East Sea Dokdo' => 'East Sea Dokdo',
	'Eater' => 'Eater',
	'Economica' => 'Economica',
	'Eczar' => 'Eczar',
	'El Messiri' => 'El Messiri',
	'Electrolize' => 'Electrolize',
	'Elsie' => 'Elsie',
	'Elsie Swash Caps' => 'Elsie Swash Caps',
	'Emblema One' => 'Emblema One',
	'Emilys Candy' => 'Emilys Candy',
	'Encode Sans' => 'Encode Sans',
	'Encode Sans Condensed' => 'Encode Sans Condensed',
	'Encode Sans Expanded' => 'Encode Sans Expanded',
	'Encode Sans SC' => 'Encode Sans SC',
	'Encode Sans Semi Condensed' => 'Encode Sans Semi Condensed',
	'Encode Sans Semi Expanded' => 'Encode Sans Semi Expanded',
	'Engagement' => 'Engagement',
	'Englebert' => 'Englebert',
	'Enriqueta' => 'Enriqueta',
	'Ephesis' => 'Ephesis',
	'Epilogue' => 'Epilogue',
	'Erica One' => 'Erica One',
	'Esteban' => 'Esteban',
	'Euphoria Script' => 'Euphoria Script',
	'Ewert' => 'Ewert',
	'Exo' => 'Exo',
	'Exo 2' => 'Exo 2',
	'Expletus Sans' => 'Expletus Sans',
	'Explora' => 'Explora',
	'Fahkwang' => 'Fahkwang',
	'Fanwood Text' => 'Fanwood Text',
	'Farro' => 'Farro',
	'Farsan' => 'Farsan',
	'Fascinate' => 'Fascinate',
	'Fascinate Inline' => 'Fascinate Inline',
	'Faster One' => 'Faster One',
	'Fasthand' => 'Fasthand',
	'Fauna One' => 'Fauna One',
	'Faustina' => 'Faustina',
	'Federant' => 'Federant',
	'Federo' => 'Federo',
	'Felipa' => 'Felipa',
	'Fenix' => 'Fenix',
	'Festive' => 'Festive',
	'Finger Paint' => 'Finger Paint',
	'Fira Code' => 'Fira Code',
	'Fira Mono' => 'Fira Mono',
	'Fira Sans' => 'Fira Sans',
	'Fira Sans Condensed' => 'Fira Sans Condensed',
	'Fira Sans Extra Condensed' => 'Fira Sans Extra Condensed',
	'Fjalla One' => 'Fjalla One',
	'Fjord One' => 'Fjord One',
	'Flamenco' => 'Flamenco',
	'Flavors' => 'Flavors',
	'Fleur De Leah' => 'Fleur De Leah',
	'Fondamento' => 'Fondamento',
	'Fontdiner Swanky' => 'Fontdiner Swanky',
	'Forum' => 'Forum',
	'Francois One' => 'Francois One',
	'Frank Ruhl Libre' => 'Frank Ruhl Libre',
	'Fraunces' => 'Fraunces',
	'Freckle Face' => 'Freckle Face',
	'Fredericka the Great' => 'Fredericka the Great',
	'Fredoka One' => 'Fredoka One',
	'Freehand' => 'Freehand',
	'Fresca' => 'Fresca',
	'Frijole' => 'Frijole',
	'Fruktur' => 'Fruktur',
	'Fugaz One' => 'Fugaz One',
	'Fuggles' => 'Fuggles',
	'GFS Didot' => 'GFS Didot',
	'GFS Neohellenic' => 'GFS Neohellenic',
	'Gabriela' => 'Gabriela',
	'Gaegu' => 'Gaegu',
	'Gafata' => 'Gafata',
	'Galada' => 'Galada',
	'Galdeano' => 'Galdeano',
	'Galindo' => 'Galindo',
	'Gamja Flower' => 'Gamja Flower',
	'Gayathri' => 'Gayathri',
	'Gelasio' => 'Gelasio',
	'Gemunu Libre' => 'Gemunu Libre',
	'Gentium Basic' => 'Gentium Basic',
	'Gentium Book Basic' => 'Gentium Book Basic',
	'Geo' => 'Geo',
	'Georama' => 'Georama',
	'Geostar' => 'Geostar',
	'Geostar Fill' => 'Geostar Fill',
	'Germania One' => 'Germania One',
	'Gideon Roman' => 'Gideon Roman',
	'Gidugu' => 'Gidugu',
	'Gilda Display' => 'Gilda Display',
	'Girassol' => 'Girassol',
	'Give You Glory' => 'Give You Glory',
	'Glass Antiqua' => 'Glass Antiqua',
	'Glegoo' => 'Glegoo',
	'Gloria Hallelujah' => 'Gloria Hallelujah',
	'Glory' => 'Glory',
	'Gluten' => 'Gluten',
	'Goblin One' => 'Goblin One',
	'Gochi Hand' => 'Gochi Hand',
	'Goldman' => 'Goldman',
	'Gorditas' => 'Gorditas',
	'Gothic A1' => 'Gothic A1',
	'Gotu' => 'Gotu',
	'Goudy Bookletter 1911' => 'Goudy Bookletter 1911',
	'Gowun Batang' => 'Gowun Batang',
	'Gowun Dodum' => 'Gowun Dodum',
	'Graduate' => 'Graduate',
	'Grand Hotel' => 'Grand Hotel',
	'Grandstander' => 'Grandstander',
	'Gravitas One' => 'Gravitas One',
	'Great Vibes' => 'Great Vibes',
	'Grechen Fuemen' => 'Grechen Fuemen',
	'Grenze' => 'Grenze',
	'Grenze Gotisch' => 'Grenze Gotisch',
	'Grey Qo' => 'Grey Qo',
	'Griffy' => 'Griffy',
	'Gruppo' => 'Gruppo',
	'Gudea' => 'Gudea',
	'Gugi' => 'Gugi',
	'Gupter' => 'Gupter',
	'Gurajada' => 'Gurajada',
	'Habibi' => 'Habibi',
	'Hachi Maru Pop' => 'Hachi Maru Pop',
	'Hahmlet' => 'Hahmlet',
	'Halant' => 'Halant',
	'Hammersmith One' => 'Hammersmith One',
	'Hanalei' => 'Hanalei',
	'Hanalei Fill' => 'Hanalei Fill',
	'Handlee' => 'Handlee',
	'Hanuman' => 'Hanuman',
	'Happy Monkey' => 'Happy Monkey',
	'Harmattan' => 'Harmattan',
	'Headland One' => 'Headland One',
	'Heebo' => 'Heebo',
	'Henny Penny' => 'Henny Penny',
	'Hepta Slab' => 'Hepta Slab',
	'Herr Von Muellerhoff' => 'Herr Von Muellerhoff',
	'Hi Melody' => 'Hi Melody',
	'Hina Mincho' => 'Hina Mincho',
	'Hind' => 'Hind',
	'Hind Guntur' => 'Hind Guntur',
	'Hind Madurai' => 'Hind Madurai',
	'Hind Siliguri' => 'Hind Siliguri',
	'Hind Vadodara' => 'Hind Vadodara',
	'Holtwood One SC' => 'Holtwood One SC',
	'Homemade Apple' => 'Homemade Apple',
	'Homenaje' => 'Homenaje',
	'IBM Plex Mono' => 'IBM Plex Mono',
	'IBM Plex Sans' => 'IBM Plex Sans',
	'IBM Plex Sans Arabic' => 'IBM Plex Sans Arabic',
	'IBM Plex Sans Condensed' => 'IBM Plex Sans Condensed',
	'IBM Plex Sans Devanagari' => 'IBM Plex Sans Devanagari',
	'IBM Plex Sans Hebrew' => 'IBM Plex Sans Hebrew',
	'IBM Plex Sans KR' => 'IBM Plex Sans KR',
	'IBM Plex Sans Thai' => 'IBM Plex Sans Thai',
	'IBM Plex Sans Thai Looped' => 'IBM Plex Sans Thai Looped',
	'IBM Plex Serif' => 'IBM Plex Serif',
	'IM Fell DW Pica' => 'IM Fell DW Pica',
	'IM Fell DW Pica SC' => 'IM Fell DW Pica SC',
	'IM Fell Double Pica' => 'IM Fell Double Pica',
	'IM Fell Double Pica SC' => 'IM Fell Double Pica SC',
	'IM Fell English' => 'IM Fell English',
	'IM Fell English SC' => 'IM Fell English SC',
	'IM Fell French Canon' => 'IM Fell French Canon',
	'IM Fell French Canon SC' => 'IM Fell French Canon SC',
	'IM Fell Great Primer' => 'IM Fell Great Primer',
	'IM Fell Great Primer SC' => 'IM Fell Great Primer SC',
	'Ibarra Real Nova' => 'Ibarra Real Nova',
	'Iceberg' => 'Iceberg',
	'Iceland' => 'Iceland',
	'Imbue' => 'Imbue',
	'Imprima' => 'Imprima',
	'Inconsolata' => 'Inconsolata',
	'Inder' => 'Inder',
	'Indie Flower' => 'Indie Flower',
	'Inika' => 'Inika',
	'Inknut Antiqua' => 'Inknut Antiqua',
	'Inria Sans' => 'Inria Sans',
	'Inria Serif' => 'Inria Serif',
	'Inter' => 'Inter',
	'Inter Tight' => 'Inter Tight',
	'Irish Grover' => 'Irish Grover',
	'Istok Web' => 'Istok Web',
	'Italiana' => 'Italiana',
	'Italianno' => 'Italianno',
	'Itim' => 'Itim',
	'Jacques Francois' => 'Jacques Francois',
	'Jacques Francois Shadow' => 'Jacques Francois Shadow',
	'Jaldi' => 'Jaldi',
	'JetBrains Mono' => 'JetBrains Mono',
	'Jim Nightshade' => 'Jim Nightshade',
	'Jockey One' => 'Jockey One',
	'Jolly Lodger' => 'Jolly Lodger',
	'Jomhuria' => 'Jomhuria',
	'Jomolhari' => 'Jomolhari',
	'Josefin Sans' => 'Josefin Sans',
	'Josefin Slab' => 'Josefin Slab',
	'Jost' => 'Jost',
	'Joti One' => 'Joti One',
	'Jua' => 'Jua',
	'Judson' => 'Judson',
	'Julee' => 'Julee',
	'Julius Sans One' => 'Julius Sans One',
	'Junge' => 'Junge',
	'Jura' => 'Jura',
	'Just Another Hand' => 'Just Another Hand',
	'Just Me Again Down Here' => 'Just Me Again Down Here',
	'K2D' => 'K2D',
	'Kadwa' => 'Kadwa',
	'Kaisei Decol' => 'Kaisei Decol',
	'Kaisei HarunoUmi' => 'Kaisei HarunoUmi',
	'Kaisei Opti' => 'Kaisei Opti',
	'Kaisei Tokumin' => 'Kaisei Tokumin',
	'Kalam' => 'Kalam',
	'Kameron' => 'Kameron',
	'Kanit' => 'Kanit',
	'Kantumruy' => 'Kantumruy',
	'Karantina' => 'Karantina',
	'Karla' => 'Karla',
	'Karma' => 'Karma',
	'Katibeh' => 'Katibeh',
	'Kaushan Script' => 'Kaushan Script',
	'Kavivanar' => 'Kavivanar',
	'Kavoon' => 'Kavoon',
	'Kdam Thmor' => 'Kdam Thmor',
	'Keania One' => 'Keania One',
	'Kelly Slab' => 'Kelly Slab',
	'Kenia' => 'Kenia',
	'Khand' => 'Khand',
	'Khmer' => 'Khmer',
	'Khula' => 'Khula',
	'Kirang Haerang' => 'Kirang Haerang',
	'Kite One' => 'Kite One',
	'Kiwi Maru' => 'Kiwi Maru',
	'Klee One' => 'Klee One',
	'Knewave' => 'Knewave',
	'KoHo' => 'KoHo',
	'Kodchasan' => 'Kodchasan',
	'Koh Santepheap' => 'Koh Santepheap',
	'Kosugi' => 'Kosugi',
	'Kosugi Maru' => 'Kosugi Maru',
	'Kotta One' => 'Kotta One',
	'Koulen' => 'Koulen',
	'Kranky' => 'Kranky',
	'Kreon' => 'Kreon',
	'Kristi' => 'Kristi',
	'Krona One' => 'Krona One',
	'Krub' => 'Krub',
	'Kufam' => 'Kufam',
	'Kulim Park' => 'Kulim Park',
	'Kumar One' => 'Kumar One',
	'Kumar One Outline' => 'Kumar One Outline',
	'Kumbh Sans' => 'Kumbh Sans',
	'Kurale' => 'Kurale',
	'La Belle Aurore' => 'La Belle Aurore',
	'Lacquer' => 'Lacquer',
	'Laila' => 'Laila',
	'Lakki Reddy' => 'Lakki Reddy',
	'Lalezar' => 'Lalezar',
	'Lancelot' => 'Lancelot',
	'Langar' => 'Langar',
	'Lateef' => 'Lateef',
	'Lato' => 'Lato',
	'League Script' => 'League Script',
	'Leckerli One' => 'Leckerli One',
	'Ledger' => 'Ledger',
	'Lekton' => 'Lekton',
	'Lemon' => 'Lemon',
	'Lemonada' => 'Lemonada',
	'Lexend' => 'Lexend',
	'Lexend Deca' => 'Lexend Deca',
	'Lexend Exa' => 'Lexend Exa',
	'Lexend Giga' => 'Lexend Giga',
	'Lexend Mega' => 'Lexend Mega',
	'Lexend Peta' => 'Lexend Peta',
	'Lexend Tera' => 'Lexend Tera',
	'Lexend Zetta' => 'Lexend Zetta',
	'Libre Barcode 128' => 'Libre Barcode 128',
	'Libre Barcode 128 Text' => 'Libre Barcode 128 Text',
	'Libre Barcode 39' => 'Libre Barcode 39',
	'Libre Barcode 39 Extended' => 'Libre Barcode 39 Extended',
	'Libre Barcode 39 Extended Text' => 'Libre Barcode 39 Extended Text',
	'Libre Barcode 39 Text' => 'Libre Barcode 39 Text',
	'Libre Barcode EAN13 Text' => 'Libre Barcode EAN13 Text',
	'Libre Baskerville' => 'Libre Baskerville',
	'Libre Caslon Display' => 'Libre Caslon Display',
	'Libre Caslon Text' => 'Libre Caslon Text',
	'Libre Franklin' => 'Libre Franklin',
	'Life Savers' => 'Life Savers',
	'Lilita One' => 'Lilita One',
	'Lily Script One' => 'Lily Script One',
	'Limelight' => 'Limelight',
	'Linden Hill' => 'Linden Hill',
	'Literata' => 'Literata',
	'Liu Jian Mao Cao' => 'Liu Jian Mao Cao',
	'Livvic' => 'Livvic',
	'Lobster' => 'Lobster',
	'Lobster Two' => 'Lobster Two',
	'Londrina Outline' => 'Londrina Outline',
	'Londrina Shadow' => 'Londrina Shadow',
	'Londrina Sketch' => 'Londrina Sketch',
	'Londrina Solid' => 'Londrina Solid',
	'Long Cang' => 'Long Cang',
	'Lora' => 'Lora',
	'Love Ya Like A Sister' => 'Love Ya Like A Sister',
	'Loved by the King' => 'Loved by the King',
	'Lovers Quarrel' => 'Lovers Quarrel',
	'Luckiest Guy' => 'Luckiest Guy',
	'Lusitana' => 'Lusitana',
	'Lustria' => 'Lustria',
	'M PLUS 1p' => 'M PLUS 1p',
	'M PLUS Rounded 1c' => 'M PLUS Rounded 1c',
	'Ma Shan Zheng' => 'Ma Shan Zheng',
	'Macondo' => 'Macondo',
	'Macondo Swash Caps' => 'Macondo Swash Caps',
	'Mada' => 'Mada',
	'Magra' => 'Magra',
	'Maiden Orange' => 'Maiden Orange',
	'Maitree' => 'Maitree',
	'Major Mono Display' => 'Major Mono Display',
	'Mako' => 'Mako',
	'Mali' => 'Mali',
	'Mallanna' => 'Mallanna',
	'Mandali' => 'Mandali',
	'Manjari' => 'Manjari',
	'Manrope' => 'Manrope',
	'Mansalva' => 'Mansalva',
	'Manuale' => 'Manuale',
	'Marcellus' => 'Marcellus',
	'Marcellus SC' => 'Marcellus SC',
	'Marck Script' => 'Marck Script',
	'Margarine' => 'Margarine',
	'Markazi Text' => 'Markazi Text',
	'Marko One' => 'Marko One',
	'Marmelad' => 'Marmelad',
	'Martel' => 'Martel',
	'Martel Sans' => 'Martel Sans',
	'Marvel' => 'Marvel',
	'Mate' => 'Mate',
	'Mate SC' => 'Mate SC',
	'Maven Pro' => 'Maven Pro',
	'McLaren' => 'McLaren',
	'Meddon' => 'Meddon',
	'MedievalSharp' => 'MedievalSharp',
	'Medula One' => 'Medula One',
	'Meera Inimai' => 'Meera Inimai',
	'Megrim' => 'Megrim',
	'Meie Script' => 'Meie Script',
	'Merienda' => 'Merienda',
	'Merienda One' => 'Merienda One',
	'Merriweather' => 'Merriweather',
	'Merriweather Sans' => 'Merriweather Sans',
	'Metal' => 'Metal',
	'Metal Mania' => 'Metal Mania',
	'Metamorphous' => 'Metamorphous',
	'Metrophobic' => 'Metrophobic',
	'Michroma' => 'Michroma',
	'Milonga' => 'Milonga',
	'Miltonian' => 'Miltonian',
	'Miltonian Tattoo' => 'Miltonian Tattoo',
	'Mina' => 'Mina',
	'Miniver' => 'Miniver',
	'Miriam Libre' => 'Miriam Libre',
	'Mirza' => 'Mirza',
	'Miss Fajardose' => 'Miss Fajardose',
	'Mitr' => 'Mitr',
	'Modak' => 'Modak',
	'Modern Antiqua' => 'Modern Antiqua',
	'Mogra' => 'Mogra',
	'Molengo' => 'Molengo',
	'Molle' => 'Molle',
	'Monda' => 'Monda',
	'Monofett' => 'Monofett',
	'Monoton' => 'Monoton',
	'Monsieur La Doulaise' => 'Monsieur La Doulaise',
	'Montaga' => 'Montaga',
	'MonteCarlo' => 'MonteCarlo',
	'Montez' => 'Montez',
	'Montserrat' => 'Montserrat',
	'Montserrat Alternates' => 'Montserrat Alternates',
	'Montserrat Subrayada' => 'Montserrat Subrayada',
	'Moul' => 'Moul',
	'Moulpali' => 'Moulpali',
	'Mountains of Christmas' => 'Mountains of Christmas',
	'Mouse Memoirs' => 'Mouse Memoirs',
	'Mr Bedfort' => 'Mr Bedfort',
	'Mr Dafoe' => 'Mr Dafoe',
	'Mr De Haviland' => 'Mr De Haviland',
	'Mrs Saint Delafield' => 'Mrs Saint Delafield',
	'Mrs Sheppards' => 'Mrs Sheppards',
	'Mukta' => 'Mukta',
	'Mukta Mahee' => 'Mukta Mahee',
	'Mukta Malar' => 'Mukta Malar',
	'Mukta Vaani' => 'Mukta Vaani',
	'Mulish' => 'Mulish',
	'Muli' => 'Muli',
	'MuseoModerno' => 'MuseoModerno',
	'Mystery Quest' => 'Mystery Quest',
	'NTR' => 'NTR',
	'Nanum Brush Script' => 'Nanum Brush Script',
	'Nanum Gothic' => 'Nanum Gothic',
	'Nanum Gothic Coding' => 'Nanum Gothic Coding',
	'Nanum Myeongjo' => 'Nanum Myeongjo',
	'Nanum Pen Script' => 'Nanum Pen Script',
	'Nerko One' => 'Nerko One',
	'Neucha' => 'Neucha',
	'Neuton' => 'Neuton',
	'New Rocker' => 'New Rocker',
	'New Tegomin' => 'New Tegomin',
	'News Cycle' => 'News Cycle',
	'Newsreader' => 'Newsreader',
	'Niconne' => 'Niconne',
	'Niramit' => 'Niramit',
	'Nixie One' => 'Nixie One',
	'Nobile' => 'Nobile',
	'Nokora' => 'Nokora',
	'Norican' => 'Norican',
	'Nosifer' => 'Nosifer',
	'Notable' => 'Notable',
	'Nothing You Could Do' => 'Nothing You Could Do',
	'Noticia Text' => 'Noticia Text',
	'Noto Kufi Arabic' => 'Noto Kufi Arabic',
	'Noto Music' => 'Noto Music',
	'Noto Naskh Arabic' => 'Noto Naskh Arabic',
	'Noto Nastaliq Urdu' => 'Noto Nastaliq Urdu',
	'Noto Rashi Hebrew' => 'Noto Rashi Hebrew',
	'Noto Sans' => 'Noto Sans',
	'Noto Sans Adlam' => 'Noto Sans Adlam',
	'Noto Sans Adlam Unjoined' => 'Noto Sans Adlam Unjoined',
	'Noto Sans Anatolian Hieroglyphs' => 'Noto Sans Anatolian Hieroglyphs',
	'Noto Sans Arabic' => 'Noto Sans Arabic',
	'Noto Sans Armenian' => 'Noto Sans Armenian',
	'Noto Sans Avestan' => 'Noto Sans Avestan',
	'Noto Sans Balinese' => 'Noto Sans Balinese',
	'Noto Sans Bamum' => 'Noto Sans Bamum',
	'Noto Sans Bassa Vah' => 'Noto Sans Bassa Vah',
	'Noto Sans Batak' => 'Noto Sans Batak',
	'Noto Sans Bengali' => 'Noto Sans Bengali',
	'Noto Sans Bhaiksuki' => 'Noto Sans Bhaiksuki',
	'Noto Sans Brahmi' => 'Noto Sans Brahmi',
	'Noto Sans Buginese' => 'Noto Sans Buginese',
	'Noto Sans Buhid' => 'Noto Sans Buhid',
	'Noto Sans Canadian Aboriginal' => 'Noto Sans Canadian Aboriginal',
	'Noto Sans Carian' => 'Noto Sans Carian',
	'Noto Sans Caucasian Albanian' => 'Noto Sans Caucasian Albanian',
	'Noto Sans Chakma' => 'Noto Sans Chakma',
	'Noto Sans Cham' => 'Noto Sans Cham',
	'Noto Sans Cherokee' => 'Noto Sans Cherokee',
	'Noto Sans Coptic' => 'Noto Sans Coptic',
	'Noto Sans Cuneiform' => 'Noto Sans Cuneiform',
	'Noto Sans Cypriot' => 'Noto Sans Cypriot',
	'Noto Sans Deseret' => 'Noto Sans Deseret',
	'Noto Sans Devanagari' => 'Noto Sans Devanagari',
	'Noto Sans Display' => 'Noto Sans Display',
	'Noto Sans Duployan' => 'Noto Sans Duployan',
	'Noto Sans Egyptian Hieroglyphs' => 'Noto Sans Egyptian Hieroglyphs',
	'Noto Sans Elbasan' => 'Noto Sans Elbasan',
	'Noto Sans Elymaic' => 'Noto Sans Elymaic',
	'Noto Sans Georgian' => 'Noto Sans Georgian',
	'Noto Sans Glagolitic' => 'Noto Sans Glagolitic',
	'Noto Sans Gothic' => 'Noto Sans Gothic',
	'Noto Sans Grantha' => 'Noto Sans Grantha',
	'Noto Sans Gujarati' => 'Noto Sans Gujarati',
	'Noto Sans Gunjala Gondi' => 'Noto Sans Gunjala Gondi',
	'Noto Sans Gurmukhi' => 'Noto Sans Gurmukhi',
	'Noto Sans HK' => 'Noto Sans HK',
	'Noto Sans Hanifi Rohingya' => 'Noto Sans Hanifi Rohingya',
	'Noto Sans Hanunoo' => 'Noto Sans Hanunoo',
	'Noto Sans Hatran' => 'Noto Sans Hatran',
	'Noto Sans Hebrew' => 'Noto Sans Hebrew',
	'Noto Sans Imperial Aramaic' => 'Noto Sans Imperial Aramaic',
	'Noto Sans Indic Siyaq Numbers' => 'Noto Sans Indic Siyaq Numbers',
	'Noto Sans Inscriptional Pahlavi' => 'Noto Sans Inscriptional Pahlavi',
	'Noto Sans Inscriptional Parthian' => 'Noto Sans Inscriptional Parthian',
	'Noto Sans JP' => 'Noto Sans JP',
	'Noto Sans Javanese' => 'Noto Sans Javanese',
	'Noto Sans KR' => 'Noto Sans KR',
	'Noto Sans Kaithi' => 'Noto Sans Kaithi',
	'Noto Sans Kannada' => 'Noto Sans Kannada',
	'Noto Sans Kayah Li' => 'Noto Sans Kayah Li',
	'Noto Sans Kharoshthi' => 'Noto Sans Kharoshthi',
	'Noto Sans Khmer' => 'Noto Sans Khmer',
	'Noto Sans Khojki' => 'Noto Sans Khojki',
	'Noto Sans Khudawadi' => 'Noto Sans Khudawadi',
	'Noto Sans Lao' => 'Noto Sans Lao',
	'Noto Sans Lepcha' => 'Noto Sans Lepcha',
	'Noto Sans Limbu' => 'Noto Sans Limbu',
	'Noto Sans Linear A' => 'Noto Sans Linear A',
	'Noto Sans Linear B' => 'Noto Sans Linear B',
	'Noto Sans Lisu' => 'Noto Sans Lisu',
	'Noto Sans Lycian' => 'Noto Sans Lycian',
	'Noto Sans Lydian' => 'Noto Sans Lydian',
	'Noto Sans Mahajani' => 'Noto Sans Mahajani',
	'Noto Sans Malayalam' => 'Noto Sans Malayalam',
	'Noto Sans Mandaic' => 'Noto Sans Mandaic',
	'Noto Sans Manichaean' => 'Noto Sans Manichaean',
	'Noto Sans Marchen' => 'Noto Sans Marchen',
	'Noto Sans Masaram Gondi' => 'Noto Sans Masaram Gondi',
	'Noto Sans Math' => 'Noto Sans Math',
	'Noto Sans Mayan Numerals' => 'Noto Sans Mayan Numerals',
	'Noto Sans Medefaidrin' => 'Noto Sans Medefaidrin',
	'Noto Sans Meroitic' => 'Noto Sans Meroitic',
	'Noto Sans Miao' => 'Noto Sans Miao',
	'Noto Sans Modi' => 'Noto Sans Modi',
	'Noto Sans Mongolian' => 'Noto Sans Mongolian',
	'Noto Sans Mono' => 'Noto Sans Mono',
	'Noto Sans Mro' => 'Noto Sans Mro',
	'Noto Sans Multani' => 'Noto Sans Multani',
	'Noto Sans Myanmar' => 'Noto Sans Myanmar',
	'Noto Sans N Ko' => 'Noto Sans N Ko',
	'Noto Sans Nabataean' => 'Noto Sans Nabataean',
	'Noto Sans New Tai Lue' => 'Noto Sans New Tai Lue',
	'Noto Sans Newa' => 'Noto Sans Newa',
	'Noto Sans Nushu' => 'Noto Sans Nushu',
	'Noto Sans Ogham' => 'Noto Sans Ogham',
	'Noto Sans Ol Chiki' => 'Noto Sans Ol Chiki',
	'Noto Sans Old Hungarian' => 'Noto Sans Old Hungarian',
	'Noto Sans Old Italic' => 'Noto Sans Old Italic',
	'Noto Sans Old North Arabian' => 'Noto Sans Old North Arabian',
	'Noto Sans Old Permic' => 'Noto Sans Old Permic',
	'Noto Sans Old Persian' => 'Noto Sans Old Persian',
	'Noto Sans Old Sogdian' => 'Noto Sans Old Sogdian',
	'Noto Sans Old South Arabian' => 'Noto Sans Old South Arabian',
	'Noto Sans Old Turkic' => 'Noto Sans Old Turkic',
	'Noto Sans Oriya' => 'Noto Sans Oriya',
	'Noto Sans Osage' => 'Noto Sans Osage',
	'Noto Sans Osmanya' => 'Noto Sans Osmanya',
	'Noto Sans Pahawh Hmong' => 'Noto Sans Pahawh Hmong',
	'Noto Sans Palmyrene' => 'Noto Sans Palmyrene',
	'Noto Sans Pau Cin Hau' => 'Noto Sans Pau Cin Hau',
	'Noto Sans Phags Pa' => 'Noto Sans Phags Pa',
	'Noto Sans Phoenician' => 'Noto Sans Phoenician',
	'Noto Sans Psalter Pahlavi' => 'Noto Sans Psalter Pahlavi',
	'Noto Sans Rejang' => 'Noto Sans Rejang',
	'Noto Sans Runic' => 'Noto Sans Runic',
	'Noto Sans SC' => 'Noto Sans SC',
	'Noto Sans Samaritan' => 'Noto Sans Samaritan',
	'Noto Sans Saurashtra' => 'Noto Sans Saurashtra',
	'Noto Sans Sharada' => 'Noto Sans Sharada',
	'Noto Sans Shavian' => 'Noto Sans Shavian',
	'Noto Sans Siddham' => 'Noto Sans Siddham',
	'Noto Sans Sinhala' => 'Noto Sans Sinhala',
	'Noto Sans Sogdian' => 'Noto Sans Sogdian',
	'Noto Sans Sora Sompeng' => 'Noto Sans Sora Sompeng',
	'Noto Sans Soyombo' => 'Noto Sans Soyombo',
	'Noto Sans Sundanese' => 'Noto Sans Sundanese',
	'Noto Sans Syloti Nagri' => 'Noto Sans Syloti Nagri',
	'Noto Sans Symbols' => 'Noto Sans Symbols',
	'Noto Sans Symbols 2' => 'Noto Sans Symbols 2',
	'Noto Sans Syriac' => 'Noto Sans Syriac',
	'Noto Sans TC' => 'Noto Sans TC',
	'Noto Sans Tagalog' => 'Noto Sans Tagalog',
	'Noto Sans Tagbanwa' => 'Noto Sans Tagbanwa',
	'Noto Sans Tai Le' => 'Noto Sans Tai Le',
	'Noto Sans Tai Tham' => 'Noto Sans Tai Tham',
	'Noto Sans Tai Viet' => 'Noto Sans Tai Viet',
	'Noto Sans Takri' => 'Noto Sans Takri',
	'Noto Sans Tamil' => 'Noto Sans Tamil',
	'Noto Sans Tamil Supplement' => 'Noto Sans Tamil Supplement',
	'Noto Sans Telugu' => 'Noto Sans Telugu',
	'Noto Sans Thaana' => 'Noto Sans Thaana',
	'Noto Sans Thai' => 'Noto Sans Thai',
	'Noto Sans Thai Looped' => 'Noto Sans Thai Looped',
	'Noto Sans Tifinagh' => 'Noto Sans Tifinagh',
	'Noto Sans Tirhuta' => 'Noto Sans Tirhuta',
	'Noto Sans Ugaritic' => 'Noto Sans Ugaritic',
	'Noto Sans Vai' => 'Noto Sans Vai',
	'Noto Sans Wancho' => 'Noto Sans Wancho',
	'Noto Sans Warang Citi' => 'Noto Sans Warang Citi',
	'Noto Sans Yi' => 'Noto Sans Yi',
	'Noto Sans Zanabazar Square' => 'Noto Sans Zanabazar Square',
	'Noto Serif' => 'Noto Serif',
	'Noto Serif Ahom' => 'Noto Serif Ahom',
	'Noto Serif Armenian' => 'Noto Serif Armenian',
	'Noto Serif Balinese' => 'Noto Serif Balinese',
	'Noto Serif Bengali' => 'Noto Serif Bengali',
	'Noto Serif Devanagari' => 'Noto Serif Devanagari',
	'Noto Serif Display' => 'Noto Serif Display',
	'Noto Serif Dogra' => 'Noto Serif Dogra',
	'Noto Serif Ethiopic' => 'Noto Serif Ethiopic',
	'Noto Serif Georgian' => 'Noto Serif Georgian',
	'Noto Serif Grantha' => 'Noto Serif Grantha',
	'Noto Serif Gujarati' => 'Noto Serif Gujarati',
	'Noto Serif Gurmukhi' => 'Noto Serif Gurmukhi',
	'Noto Serif Hebrew' => 'Noto Serif Hebrew',
	'Noto Serif JP' => 'Noto Serif JP',
	'Noto Serif KR' => 'Noto Serif KR',
	'Noto Serif Kannada' => 'Noto Serif Kannada',
	'Noto Serif Khmer' => 'Noto Serif Khmer',
	'Noto Serif Lao' => 'Noto Serif Lao',
	'Noto Serif Malayalam' => 'Noto Serif Malayalam',
	'Noto Serif Myanmar' => 'Noto Serif Myanmar',
	'Noto Serif Nyiakeng Puachue Hmong' => 'Noto Serif Nyiakeng Puachue Hmong',
	'Noto Serif SC' => 'Noto Serif SC',
	'Noto Serif Sinhala' => 'Noto Serif Sinhala',
	'Noto Serif TC' => 'Noto Serif TC',
	'Noto Serif Tamil' => 'Noto Serif Tamil',
	'Noto Serif Tangut' => 'Noto Serif Tangut',
	'Noto Serif Telugu' => 'Noto Serif Telugu',
	'Noto Serif Thai' => 'Noto Serif Thai',
	'Noto Serif Tibetan' => 'Noto Serif Tibetan',
	'Noto Serif Yezidi' => 'Noto Serif Yezidi',
	'Noto Traditional Nushu' => 'Noto Traditional Nushu',
	'Nova Cut' => 'Nova Cut',
	'Nova Flat' => 'Nova Flat',
	'Nova Mono' => 'Nova Mono',
	'Nova Oval' => 'Nova Oval',
	'Nova Round' => 'Nova Round',
	'Nova Script' => 'Nova Script',
	'Nova Slim' => 'Nova Slim',
	'Nova Square' => 'Nova Square',
	'Numans' => 'Numans',
	'Nunito' => 'Nunito',
	'Nunito Sans' => 'Nunito Sans',
	'Odibee Sans' => 'Odibee Sans',
	'Odor Mean Chey' => 'Odor Mean Chey',
	'Offside' => 'Offside',
	'Oi' => 'Oi',
	'Old Standard TT' => 'Old Standard TT',
	'Oldenburg' => 'Oldenburg',
	'Oleo Script' => 'Oleo Script',
	'Oleo Script Swash Caps' => 'Oleo Script Swash Caps',
	'Open Sans' => 'Open Sans',
	'Open Sans Condensed' => 'Open Sans Condensed',
	'Oranienbaum' => 'Oranienbaum',
	'Orbitron' => 'Orbitron',
	'Oregano' => 'Oregano',
	'Orelega One' => 'Orelega One',
	'Orienta' => 'Orienta',
	'Original Surfer' => 'Original Surfer',
	'Oswald' => 'Oswald',
	'Otomanopee One' => 'Otomanopee One',
	'Over the Rainbow' => 'Over the Rainbow',
	'Overlock' => 'Overlock',
	'Overlock SC' => 'Overlock SC',
	'Overpass' => 'Overpass',
	'Overpass Mono' => 'Overpass Mono',
	'Ovo' => 'Ovo',
	'Oxanium' => 'Oxanium',
	'Oxygen' => 'Oxygen',
	'Oxygen Mono' => 'Oxygen Mono',
	'PT Mono' => 'PT Mono',
	'PT Sans' => 'PT Sans',
	'PT Sans Caption' => 'PT Sans Caption',
	'PT Sans Narrow' => 'PT Sans Narrow',
	'PT Serif' => 'PT Serif',
	'PT Serif Caption' => 'PT Serif Caption',
	'Pacifico' => 'Pacifico',
	'Padauk' => 'Padauk',
	'Palanquin' => 'Palanquin',
	'Palanquin Dark' => 'Palanquin Dark',
	'Palette Mosaic' => 'Palette Mosaic',
	'Pangolin' => 'Pangolin',
	'Paprika' => 'Paprika',
	'Parisienne' => 'Parisienne',
	'Passero One' => 'Passero One',
	'Passion One' => 'Passion One',
	'Pathway Gothic One' => 'Pathway Gothic One',
	'Patrick Hand' => 'Patrick Hand',
	'Patrick Hand SC' => 'Patrick Hand SC',
	'Pattaya' => 'Pattaya',
	'Patua One' => 'Patua One',
	'Pavanam' => 'Pavanam',
	'Paytone One' => 'Paytone One',
	'Peddana' => 'Peddana',
	'Peralta' => 'Peralta',
	'Permanent Marker' => 'Permanent Marker',
	'Petit Formal Script' => 'Petit Formal Script',
	'Petrona' => 'Petrona',
	'Philosopher' => 'Philosopher',
	'Piazzolla' => 'Piazzolla',
	'Piedra' => 'Piedra',
	'Pinyon Script' => 'Pinyon Script',
	'Pirata One' => 'Pirata One',
	'Plaster' => 'Plaster',
	'Play' => 'Play',
	'Playball' => 'Playball',
	'Playfair Display' => 'Playfair Display',
	'Playfair Display SC' => 'Playfair Display SC',
	'Podkova' => 'Podkova',
	'Poiret One' => 'Poiret One',
	'Poller One' => 'Poller One',
	'Poly' => 'Poly',
	'Pompiere' => 'Pompiere',
	'Pontano Sans' => 'Pontano Sans',
	'Poor Story' => 'Poor Story',
	'Poppins' => 'Poppins',
	'Port Lligat Sans' => 'Port Lligat Sans',
	'Port Lligat Slab' => 'Port Lligat Slab',
	'Potta One' => 'Potta One',
	'Pragati Narrow' => 'Pragati Narrow',
	'Prata' => 'Prata',
	'Preahvihear' => 'Preahvihear',
	'Press Start 2P' => 'Press Start 2P',
	'Pridi' => 'Pridi',
	'Princess Sofia' => 'Princess Sofia',
	'Prociono' => 'Prociono',
	'Prompt' => 'Prompt',
	'Prosto One' => 'Prosto One',
	'Proza Libre' => 'Proza Libre',
	'Public Sans' => 'Public Sans',
	'Puritan' => 'Puritan',
	'Purple Purse' => 'Purple Purse',
	'Qahiri' => 'Qahiri',
	'Quando' => 'Quando',
	'Quantico' => 'Quantico',
	'Quattrocento' => 'Quattrocento',
	'Quattrocento Sans' => 'Quattrocento Sans',
	'Questrial' => 'Questrial',
	'Quicksand' => 'Quicksand',
	'Quintessential' => 'Quintessential',
	'Qwigley' => 'Qwigley',
	'Racing Sans One' => 'Racing Sans One',
	'Radley' => 'Radley',
	'Rajdhani' => 'Rajdhani',
	'Rakkas' => 'Rakkas',
	'Raleway' => 'Raleway',
	'Raleway Dots' => 'Raleway Dots',
	'Ramabhadra' => 'Ramabhadra',
	'Ramaraja' => 'Ramaraja',
	'Rambla' => 'Rambla',
	'Rammetto One' => 'Rammetto One',
	'Rampart One' => 'Rampart One',
	'Ranchers' => 'Ranchers',
	'Rancho' => 'Rancho',
	'Ranga' => 'Ranga',
	'Rasa' => 'Rasa',
	'Rationale' => 'Rationale',
	'Ravi Prakash' => 'Ravi Prakash',
	'Recursive' => 'Recursive',
	'Red Hat Display' => 'Red Hat Display',
	'Red Hat Text' => 'Red Hat Text',
	'Red Rose' => 'Red Rose',
	'Redressed' => 'Redressed',
	'Reem Kufi' => 'Reem Kufi',
	'Reenie Beanie' => 'Reenie Beanie',
	'Reggae One' => 'Reggae One',
	'Revalia' => 'Revalia',
	'Rhodium Libre' => 'Rhodium Libre',
	'Ribeye' => 'Ribeye',
	'Ribeye Marrow' => 'Ribeye Marrow',
	'Righteous' => 'Righteous',
	'Risque' => 'Risque',
	'Roboto' => 'Roboto',
	'Roboto Condensed' => 'Roboto Condensed',
	'Roboto Mono' => 'Roboto Mono',
	'Roboto Slab' => 'Roboto Slab',
	'Rochester' => 'Rochester',
	'Rock Salt' => 'Rock Salt',
	'RocknRoll One' => 'RocknRoll One',
	'Rokkitt' => 'Rokkitt',
	'Romanesco' => 'Romanesco',
	'Ropa Sans' => 'Ropa Sans',
	'Rosario' => 'Rosario',
	'Rosarivo' => 'Rosarivo',
	'Rouge Script' => 'Rouge Script',
	'Rowdies' => 'Rowdies',
	'Rozha One' => 'Rozha One',
	'Rubik' => 'Rubik',
	'Rubik Beastly' => 'Rubik Beastly',
	'Rubik Mono One' => 'Rubik Mono One',
	'Ruda' => 'Ruda',
	'Rufina' => 'Rufina',
	'Ruge Boogie' => 'Ruge Boogie',
	'Ruluko' => 'Ruluko',
	'Rum Raisin' => 'Rum Raisin',
	'Ruslan Display' => 'Ruslan Display',
	'Russo One' => 'Russo One',
	'Ruthie' => 'Ruthie',
	'Rye' => 'Rye',
	'STIX Two Text' => 'STIX Two Text',
	'Sacramento' => 'Sacramento',
	'Sahitya' => 'Sahitya',
	'Sail' => 'Sail',
	'Saira' => 'Saira',
	'Saira Condensed' => 'Saira Condensed',
	'Saira Extra Condensed' => 'Saira Extra Condensed',
	'Saira Semi Condensed' => 'Saira Semi Condensed',
	'Saira Stencil One' => 'Saira Stencil One',
	'Salsa' => 'Salsa',
	'Sanchez' => 'Sanchez',
	'Sancreek' => 'Sancreek',
	'Sansita' => 'Sansita',
	'Sansita Swashed' => 'Sansita Swashed',
	'Sarabun' => 'Sarabun',
	'Sarala' => 'Sarala',
	'Sarina' => 'Sarina',
	'Sarpanch' => 'Sarpanch',
	'Satisfy' => 'Satisfy',
	'Sawarabi Gothic' => 'Sawarabi Gothic',
	'Sawarabi Mincho' => 'Sawarabi Mincho',
	'Scada' => 'Scada',
	'Scheherazade' => 'Scheherazade',
	'Scheherazade New' => 'Scheherazade New',
	'Schoolbell' => 'Schoolbell',
	'Scope One' => 'Scope One',
	'Seaweed Script' => 'Seaweed Script',
	'Secular One' => 'Secular One',
	'Sedgwick Ave' => 'Sedgwick Ave',
	'Sedgwick Ave Display' => 'Sedgwick Ave Display',
	'Sen' => 'Sen',
	'Sevillana' => 'Sevillana',
	'Seymour One' => 'Seymour One',
	'Shadows Into Light' => 'Shadows Into Light',
	'Shadows Into Light Two' => 'Shadows Into Light Two',
	'Shanti' => 'Shanti',
	'Share' => 'Share',
	'Share Tech' => 'Share Tech',
	'Share Tech Mono' => 'Share Tech Mono',
	'Shippori Mincho' => 'Shippori Mincho',
	'Shippori Mincho B1' => 'Shippori Mincho B1',
	'Shojumaru' => 'Shojumaru',
	'Short Stack' => 'Short Stack',
	'Shrikhand' => 'Shrikhand',
	'Siemreap' => 'Siemreap',
	'Sigmar One' => 'Sigmar One',
	'Signika' => 'Signika',
	'Signika Negative' => 'Signika Negative',
	'Simonetta' => 'Simonetta',
	'Single Day' => 'Single Day',
	'Sintony' => 'Sintony',
	'Sirin Stencil' => 'Sirin Stencil',
	'Six Caps' => 'Six Caps',
	'Skranji' => 'Skranji',
	'Slabo 13px' => 'Slabo 13px',
	'Slabo 27px' => 'Slabo 27px',
	'Slackey' => 'Slackey',
	'Smokum' => 'Smokum',
	'Smythe' => 'Smythe',
	'Sniglet' => 'Sniglet',
	'Snippet' => 'Snippet',
	'Snowburst One' => 'Snowburst One',
	'Sofadi One' => 'Sofadi One',
	'Sofia' => 'Sofia',
	'Solway' => 'Solway',
	'Song Myung' => 'Song Myung',
	'Sonsie One' => 'Sonsie One',
	'Sora' => 'Sora',
	'Sorts Mill Goudy' => 'Sorts Mill Goudy',
	'Source Code Pro' => 'Source Code Pro',
	'Source Sans Pro' => 'Source Sans Pro',
	'Source Serif Pro' => 'Source Serif Pro',
	'Space Grotesk' => 'Space Grotesk',
	'Space Mono' => 'Space Mono',
	'Spartan' => 'Spartan',
	'Special Elite' => 'Special Elite',
	'Spectral' => 'Spectral',
	'Spectral SC' => 'Spectral SC',
	'Spicy Rice' => 'Spicy Rice',
	'Spinnaker' => 'Spinnaker',
	'Spirax' => 'Spirax',
	'Squada One' => 'Squada One',
	'Sree Krushnadevaraya' => 'Sree Krushnadevaraya',
	'Sriracha' => 'Sriracha',
	'Srisakdi' => 'Srisakdi',
	'Staatliches' => 'Staatliches',
	'Stalemate' => 'Stalemate',
	'Stalinist One' => 'Stalinist One',
	'Stardos Stencil' => 'Stardos Stencil',
	'Stick' => 'Stick',
	'Stick No Bills' => 'Stick No Bills',
	'Stint Ultra Condensed' => 'Stint Ultra Condensed',
	'Stint Ultra Expanded' => 'Stint Ultra Expanded',
	'Stoke' => 'Stoke',
	'Strait' => 'Strait',
	'Style Script' => 'Style Script',
	'Stylish' => 'Stylish',
	'Sue Ellen Francisco' => 'Sue Ellen Francisco',
	'Suez One' => 'Suez One',
	'Sulphur Point' => 'Sulphur Point',
	'Sumana' => 'Sumana',
	'Sunflower' => 'Sunflower',
	'Sunshiney' => 'Sunshiney',
	'Supermercado One' => 'Supermercado One',
	'Sura' => 'Sura',
	'Suranna' => 'Suranna',
	'Suravaram' => 'Suravaram',
	'Suwannaphum' => 'Suwannaphum',
	'Swanky and Moo Moo' => 'Swanky and Moo Moo',
	'Syncopate' => 'Syncopate',
	'Syne' => 'Syne',
	'Syne Mono' => 'Syne Mono',
	'Syne Tactile' => 'Syne Tactile',
	'Tajawal' => 'Tajawal',
	'Tangerine' => 'Tangerine',
	'Taprom' => 'Taprom',
	'Tauri' => 'Tauri',
	'Taviraj' => 'Taviraj',
	'Teko' => 'Teko',
	'Telex' => 'Telex',
	'Tenali Ramakrishna' => 'Tenali Ramakrishna',
	'Tenor Sans' => 'Tenor Sans',
	'Text Me One' => 'Text Me One',
	'Texturina' => 'Texturina',
	'Thasadith' => 'Thasadith',
	'The Girl Next Door' => 'The Girl Next Door',
	'Tienne' => 'Tienne',
	'Tillana' => 'Tillana',
	'Timmana' => 'Timmana',
	'Tinos' => 'Tinos',
	'Titan One' => 'Titan One',
	'Titillium Web' => 'Titillium Web',
	'Tomorrow' => 'Tomorrow',
	'Tourney' => 'Tourney',
	'Trade Winds' => 'Trade Winds',
	'Train One' => 'Train One',
	'Trirong' => 'Trirong',
	'Trispace' => 'Trispace',
	'Trocchi' => 'Trocchi',
	'Trochut' => 'Trochut',
	'Truculenta' => 'Truculenta',
	'Trykker' => 'Trykker',
	'Tulpen One' => 'Tulpen One',
	'Turret Road' => 'Turret Road',
	'Ubuntu' => 'Ubuntu',
	'Ubuntu Condensed' => 'Ubuntu Condensed',
	'Ubuntu Mono' => 'Ubuntu Mono',
	'Uchen' => 'Uchen',
	'Ultra' => 'Ultra',
	'Uncial Antiqua' => 'Uncial Antiqua',
	'Underdog' => 'Underdog',
	'Unica One' => 'Unica One',
	'UnifrakturCook' => 'UnifrakturCook',
	'UnifrakturMaguntia' => 'UnifrakturMaguntia',
	'Unkempt' => 'Unkempt',
	'Unlock' => 'Unlock',
	'Unna' => 'Unna',
	'Urbanist' => 'Urbanist',
	'VT323' => 'VT323',
	'Vampiro One' => 'Vampiro One',
	'Varela' => 'Varela',
	'Varela Round' => 'Varela Round',
	'Varta' => 'Varta',
	'Vast Shadow' => 'Vast Shadow',
	'Vesper Libre' => 'Vesper Libre',
	'Viaoda Libre' => 'Viaoda Libre',
	'Vibes' => 'Vibes',
	'Vibur' => 'Vibur',
	'Vidaloka' => 'Vidaloka',
	'Viga' => 'Viga',
	'Voces' => 'Voces',
	'Volkhov' => 'Volkhov',
	'Vollkorn' => 'Vollkorn',
	'Vollkorn SC' => 'Vollkorn SC',
	'Voltaire' => 'Voltaire',
	'Waiting for the Sunrise' => 'Waiting for the Sunrise',
	'Wallpoet' => 'Wallpoet',
	'Walter Turncoat' => 'Walter Turncoat',
	'Warnes' => 'Warnes',
	'Wellfleet' => 'Wellfleet',
	'Wendy One' => 'Wendy One',
	'WindSong' => 'WindSong',
	'Wire One' => 'Wire One',
	'Work Sans' => 'Work Sans',
	'Xanh Mono' => 'Xanh Mono',
	'Yaldevi' => 'Yaldevi',
	'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
	'Yantramanav' => 'Yantramanav',
	'Yatra One' => 'Yatra One',
	'Yellowtail' => 'Yellowtail',
	'Yeon Sung' => 'Yeon Sung',
	'Yeseva One' => 'Yeseva One',
	'Yesteryear' => 'Yesteryear',
	'Yomogi' => 'Yomogi',
	'Yrsa' => 'Yrsa',
	'Yusei Magic' => 'Yusei Magic',
	'ZCOOL KuaiLe' => 'ZCOOL KuaiLe',
	'ZCOOL QingKe HuangYou' => 'ZCOOL QingKe HuangYou',
	'ZCOOL XiaoWei' => 'ZCOOL XiaoWei',
	'Zen Dots' => 'Zen Dots',
	'Zen Loop' => 'Zen Loop',
	'Zen Tokyo Zoo' => 'Zen Tokyo Zoo',
	'Zeyada' => 'Zeyada',
	'Zhi Mang Xing' => 'Zhi Mang Xing',
	'Zilla Slab' => 'Zilla Slab',
	'Zilla Slab Highlight' => 'Zilla Slab Highlight'
	);
	$faces = array_merge($jl_custom_font, $jl_google_font);
	// Font Size
	$font_sizes = array();
	$font_sizes_px_none = array();
	for ($i = 7; $i <= 70; $i++){
		$font_sizes[$i.'px'] = $i.'px';
		$font_sizes_px_none[$i] = $i.'px';
	}

	$num_sizes = array();
	for ($i = 1; $i <= 50; $i++){
		$num_sizes[$i] = $i;
	}
	// Font Weights
	$font_weights  = array(
		'100' => esc_html__('Thin', 'wesper'),
		'200' => esc_html__('Extra-Light', 'wesper'),
		'300' => esc_html__('Light', 'wesper'),
		'400' => esc_html__('Regular', 'wesper'),
		'500' => esc_html__('Medium', 'wesper'),
		'600' => esc_html__('Semi-Bold', 'wesper'),
		'700' => esc_html__('Bold', 'wesper'),
		'800' => esc_html__('Extra-Bold', 'wesper'),
		'900' => esc_html__('Black', 'wesper')
	);

	$wp_customize->add_panel( 'wesper_theme_options', array(
	    'priority' => 1,
	    'title' => esc_html__( 'Theme Options', 'wesper' ),
	    'description' => esc_html__( 'Options for theme customizing', 'wesper' ),
	));

	$wp_customize->add_section(
		'wesper_logo_favicon' ,
		array(
   		'title'      => esc_html__( 'Logo Settings', 'wesper' ),   		
   		'priority'  => 1,
   		'panel' => 'wesper_theme_options'
	));
    $wp_customize->add_setting(
    'wesper_logo',
    array(
	'default' 			=> '',
	'transport'   		=> 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
	));
    $wp_customize->add_control(
    	new WP_Customize_Image_Control(
    	$wp_customize,
    	'wesper_logo',
    	array(
        'label'    => esc_html__( 'Normal logo', 'wesper' ),
        'section'  => 'wesper_logo_favicon',
        'settings' => 'wesper_logo'
    )));

    $wp_customize->add_setting(
    'wesper_logow',
    array(
	'default' 			=> '',
	'transport'   		=> 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
	));
    $wp_customize->add_control(
    	new WP_Customize_Image_Control(
    	$wp_customize,
    	'wesper_logow',
    	array(
        'label'    => esc_html__( 'Dark mode logo', 'wesper' ),
        'section'  => 'wesper_logo_favicon',
        'settings' => 'wesper_logow'
    )));    

    $wp_customize->add_setting(
	    'logo_width',
	    array(
	        'default'    =>  esc_attr__( '150px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'logo_width',
	    array(
	        'section'   => 'wesper_logo_favicon',
	        'label'     => esc_html__('Logo Width EX: 100px','wesper'),
	        'type'      => 'text'
	    )
	);
	$wp_customize->add_setting(
	    'm_logo_width',
	    array(
	        'default'    =>  esc_attr__( '120px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'm_logo_width',
	    array(
	        'section'   => 'wesper_logo_favicon',
	        'label'     => esc_html__('Mobile Logo Width EX: 100px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    's_logo_width',
	    array(	        
			'default'    =>  esc_attr__( '150px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    's_logo_width',
	    array(
	        'section'   => 'wesper_logo_favicon',
	        'label'     => esc_html__('Sidebar Logo Width EX: 100px','wesper'),
	        'type'      => 'text'
	    )
	);	

	$wp_customize->add_setting(
	    'foot_logo_width',
	    array(	        
			'default'    =>  esc_attr__( '150px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'foot_logo_width',
	    array(
	        'section'   => 'wesper_logo_favicon',
	        'label'     => esc_html__('Footer Logo Width EX: 100px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
        'wesper_logotext_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_logotext_options',
            array(
                'label'         => esc_html__( 'Logo text settings', 'wesper' ),
                'section'       => 'wesper_logo_favicon',
                'settings'      => 'wesper_logotext_options',
            )
        )
    );

	$wp_customize->add_setting(
        'enable_logo_txt',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'enable_logo_txt',
        array(
            'section'   => 'wesper_logo_favicon',
            'label'     => esc_html__('Enable logo text','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'jl_logo_size',
	    array(
	        'default'    =>  esc_attr__( '33px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'jl_logo_size',
	    array(
	        'section'   => 'wesper_logo_favicon',
	        'label'     => esc_html__('Logo font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'jl_logo_size_mob',
	    array(
	        'default'    =>  esc_attr__( '30px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'jl_logo_size_mob',
	    array(
	        'section'   => 'wesper_logo_favicon',
	        'label'     => esc_html__('Logo mobile font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'jl_logo_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'jl_logo_color',
	        array(
	            'label'      => esc_html__( 'Logo text color', 'wesper' ),
	            'section'    => 'wesper_logo_favicon',
	            'settings'   => 'jl_logo_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_logo_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#fff', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'jl_logo_color_dark',
	        array(
	            'label'      => esc_html__( 'Logo text color dark mode', 'wesper' ),
	            'section'    => 'wesper_logo_favicon',
	            'settings'   => 'jl_logo_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_logo_color_side',
	    array(
	        'default'    =>  esc_attr__( '#000', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'jl_logo_color_side',
	        array(
	            'label'      => esc_html__( 'Logo sidebar text color', 'wesper' ),
	            'section'    => 'wesper_logo_favicon',
	            'settings'   => 'jl_logo_color_side'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_logo_color_side_dark',
	    array(
	        'default'    =>  esc_attr__( '#fff', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'jl_logo_color_side_dark',
	        array(
	            'label'      => esc_html__( 'Logo sidebar text color dark mode', 'wesper' ),
	            'section'    => 'wesper_logo_favicon',
	            'settings'   => 'jl_logo_color_side_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_logo_color_foot',
	    array(
	        'default'    =>  esc_attr__( '#fff', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'jl_logo_color_foot',
	        array(
	            'label'      => esc_html__( 'Logo footer text color', 'wesper' ),
	            'section'    => 'wesper_logo_favicon',
	            'settings'   => 'jl_logo_color_foot'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_logo_color_foot_dark',
	    array(
	        'default'    =>  esc_attr__( '#fff', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'jl_logo_color_foot_dark',
	        array(
	            'label'      => esc_html__( 'Logo footer text color dark mode', 'wesper' ),
	            'section'    => 'wesper_logo_favicon',
	            'settings'   => 'jl_logo_color_foot_dark'
	        )
	    )
	);

	/*General Setting*/
	$wp_customize->add_section(
		    'wesper_general_setting',
		    array(
		        'title'     => esc_html__('General Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'max_content_width',
	    array(
	        'default'    =>  '1200px',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'max_content_width',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Content width EX: 1200px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'header_layout_design',
	    array(
	        'default'    =>  esc_attr__( 'header_1', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    new wesper_control_image_select (
	        $wp_customize,
	        'header_layout_design',
	        array(
	            'label'      	=> esc_html__( 'Header Layout (header menu and logo)', 'wesper' ),
	            'section'		=> 'wesper_general_setting',
	            'settings'		=> 'header_layout_design',
	            'choices'		=> array(
	            	'header_1'  => get_template_directory_uri().'/inc/customizer/images/header1.png',
                    'header_2' => get_template_directory_uri().'/inc/customizer/images/header2.png',
                    'header_3'   => get_template_directory_uri().'/inc/customizer/images/header3.png',
					'header_4'   => get_template_directory_uri().'/inc/customizer/images/header4.png',
					'header_5'   => get_template_directory_uri().'/inc/customizer/images/header5.png',
					'header_6'   => get_template_directory_uri().'/inc/customizer/images/header6.png',
					'header_7'   => get_template_directory_uri().'/inc/customizer/images/header7.png',
					'header_8'   => get_template_directory_uri().'/inc/customizer/images/header8.png',
					'header_9'   => get_template_directory_uri().'/inc/customizer/images/header9.png',
	            ),
	            'input_attrs' => array(
	            	'multiple' => false
	            )
	        )
	    )
	);

	$wp_customize->add_setting(
	    'header_layout',
	    array(
	        'default'     => 'default',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'header_layout',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Header Layout Custom Template','wesper'),
			'description' => esc_html__( 'Choose layout to overwrite default header','wesper'),
	        'type'      => 'select',
	        'choices'	=> $jl_layouts
	    )
	);

	$wp_customize->add_setting(
	    'header_sticky',
	    array(
	        'default'     => 'default',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'header_sticky',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Header Sticky Custom Template','wesper'),
			'description' => esc_html__( 'Choose layout to overwrite default sticky header: Note this options work when you choose (Header Layout Custom Template)','wesper'),
	        'type'      => 'select',
	        'choices'	=> $jl_layouts
	    )
	);

	$wp_customize->add_setting(
	    'footer_layout',
	    array(
	        'default'     => 'default',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_layout',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Footer Custom Template','wesper'),
			'description' => esc_html__( 'Choose layout to overwrite default footer','wesper'),
	        'type'      => 'select',
	        'choices'	=> $jl_layouts
	    )
	);	

	$wp_customize->add_setting(
        'wesper_menu_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_menu_sec_options',
            array(
                'label'         => esc_html__( 'Menu Section', 'wesper' ),
                'section'       => 'wesper_general_setting',
                'settings'      => 'wesper_menu_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
	    'section_menu_height',
	    array(
	        'default'    =>  esc_attr__( '70px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'section_menu_height',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Section menu height  EX: 80px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'sticky_header',
	    array(
	        'default'    =>  esc_attr__( 'jl_sticky_smart', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sticky_header',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Sticky header style','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(				
				'jl_sticky_smart' => esc_html__('Header smart sticky', 'wesper'),
				'jl_sticky_fixed' => esc_html__('Header fixed sticky', 'wesper')
			
	        )
	    )
	);

	$wp_customize->add_setting(
	    'sticky_logo',
	    array(
	        'default'    =>  esc_attr__( 'logo_sticky_normal', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sticky_logo',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Sticky logo','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(				
				'logo_sticky_white' => esc_html__('Sticky dark mode logo', 'wesper'),
				'logo_sticky_normal' => esc_html__('Sticky normal logo', 'wesper')
			
	        )
	    )
	);

	$wp_customize->add_setting(
	    'mega_menu_layout',
	    array(
	        'default'    =>  esc_attr__( 'mega_full', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'mega_menu_layout',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Mega menu layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(				
				'mega_full' => esc_html__('Full width', 'wesper'),
				'mega_boxed' => esc_html__('boxed width', 'wesper')
			
	        )
	    )
	);

	$wp_customize->add_setting(
        'wesper_logo_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_logo_sec_options',
            array(
                'label'         => esc_html__( 'Logo Section', 'wesper' ),
                'section'       => 'wesper_general_setting',
                'settings'      => 'wesper_logo_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
	    'section_logo_height',
	    array(
	        'default'    =>  esc_attr__( '120px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'section_logo_height',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Section middle logo height  EX: 80px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_subcribe_txt',
	    array(
	        'default'    =>  esc_attr__( 'Subscribe', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_subcribe_txt',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Subscribe button text','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_subcribe_link',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_subcribe_link',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Subscribe button link','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
        'wesper_top_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_top_sec_options',
            array(
                'label'         => esc_html__( 'Topbar Section', 'wesper' ),
                'section'       => 'wesper_general_setting',
                'settings'      => 'wesper_top_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
	    'section_top_bar_height',
	    array(
	        'default'    =>  esc_attr__( '35px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'section_top_bar_height',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Section top bar height  EX: 35px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'section_top_bar_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'section_top_bar_size',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Section top bar font size  EX: 14px','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
        'hide_top_bar',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'hide_top_bar',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Hide top bar','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'topl_text',
	    array(
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'topl_text',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Top left text','wesper'),
	        'type'      => 'textarea'
	    )
	);

	$wp_customize->add_setting(
        'enable_topl_menu',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'enable_topl_menu',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Show top left menu','wesper'),
            'type'      => 'checkbox'
        )
    );
	

    $wp_customize->add_setting(
	    'topr_text',
	    array(
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'topr_text',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Top right text','wesper'),
	        'type'      => 'textarea'
	    )
	);

	$wp_customize->add_setting(
        'hide_top_social',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'hide_top_social',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Hide top bar social','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'show_top_date',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'show_top_date',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Show top bar date','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'topbar_date_format',
	    array(	        
	        'default'    =>  esc_attr__( 'l ,  j  F Y', 'wesper' ),
			'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'topbar_date_format',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Topbar date format EX: l ,  j  F Y','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
        'wesper_other_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_other_options',
            array(
                'label'         => esc_html__( 'Other Settings', 'wesper' ),
                'section'       => 'wesper_general_setting',
                'settings'      => 'wesper_other_options',
            )
        )
    );

    $wp_customize->add_setting(
	    'wesper_title_link',
	    array(
	        'default'    =>  esc_attr__( 'jl_tline', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_title_link',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Title hover style','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'jl_tline' => esc_html__('Title hover line animation', 'wesper'),
			'jl_tcolor' => esc_html__('Title hover text color', 'wesper'),
			'jl_uline' => esc_html__('Title hover text underline', 'wesper')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'border_rounded',
	    array(
	        'default'    =>  esc_attr__( '0px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'border_rounded',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Image border radius EX: 10px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'top_border_rounded',
	    array(
	        'default'    =>  esc_attr__( '60px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'top_border_rounded',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Go to top border radius EX: 10px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
        'enable_dark_mode',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'enable_dark_mode',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Show dark mode button','wesper'),
            'type'      => 'checkbox'
        )
    );
	

    $wp_customize->add_setting(
		'enable_dark_skin',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'enable_dark_skin',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Show default dark skin','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
        'jl_search_layout',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_search_layout',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Enable search small layout','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
		'jl_nav_guide',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'jl_nav_guide',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Show Breadcrumb','wesper'),
	        'type'      => 'checkbox'
	    )
	);

$wp_customize->add_setting(
		'disable_top_search',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_top_search',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Hide search button','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'show_mb_nav',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'show_mb_nav',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Show mobile toggle on desktop','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'mb_nav_left',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'mb_nav_left',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Canvas menu left position on desktop','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'mb_nav_right',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'mb_nav_right',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Canvas menu right position on mobile','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_social_icons',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_social_icons',
	    array(
	        'section'   => 'wesper_general_setting',
	        'label'     => esc_html__('Hide mobile menu social icons','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
        'hide_head_share',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'hide_head_share',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Hide header social','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'remove_woo_swatches',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'remove_woo_swatches',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Remove WooCommerce swatcher','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'remove_hzoom_img',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'remove_hzoom_img',
        array(
            'section'   => 'wesper_general_setting',
            'label'     => esc_html__('Remove hover zoom image','wesper'),
            'type'      => 'checkbox'
        )
    );


/*Color Setting*/
	$wp_customize->add_section(
		    'wesper_color_setting',
		    array(
		        'title'     => esc_html__('Color Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'wesper_theme_color_settings',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_theme_color_settings',
            array(
                'label'         => esc_html__( 'Theme color', 'wesper' ),
                'section'       => 'wesper_color_setting',
                'settings'      => 'wesper_theme_color_settings',
            )
        )
    );

	$wp_customize->add_setting(
	    'theme_color',
	    array(
	        'default'    =>  esc_attr__( '#f21717', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_color',
	        array(
	            'label'      => esc_html__( 'Theme color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'theme_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#f21717', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_color_dark',
	        array(
	            'label'      => esc_html__( 'Theme color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'theme_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_bg_color',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_bg_color',
	        array(
	            'label'      => esc_html__( 'Theme background color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'theme_bg_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_bg_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#111', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Theme background color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'theme_bg_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_text_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_text_color',
	        array(
	            'label'      => esc_html__( 'Theme text color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'theme_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'theme_text_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'theme_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Theme text color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'theme_text_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
        'wesper_menu_color_settings',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_menu_color_settings',
            array(
                'label'         => esc_html__( 'Menu section color', 'wesper' ),
                'section'       => 'wesper_color_setting',
                'settings'      => 'wesper_menu_color_settings',
            )
        )
    );

	$wp_customize->add_setting(
	    'ac_menu_line_color',
	    array(
	        'default'    =>  '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'ac_menu_line_color',
	        array(
	            'label'      => esc_html__( 'Active & hover line color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'ac_menu_line_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'ac_menu_line_height',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'ac_menu_line_height',
	    array(
	        'section'   => 'wesper_color_setting',
	        'label'     => esc_html__('Active & hover line height','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'menu_bg_color',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_bg_color',
	        array(
	            'label'      => esc_html__( 'Main menu background', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'menu_bg_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_text_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_text_color',
	        array(
	            'label'      => esc_html__( 'Main menu text color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'menu_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_bg_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#111', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Main menu background dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'menu_bg_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_text_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Main menu text color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'menu_text_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_back_color',
	    array(
	        'default'    =>  esc_attr__( '#f7f7f6', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_back_color',
	        array(
	            'label'      => esc_html__( 'Sub menu background color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'submenu_back_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_text_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_text_color',
	        array(
	            'label'      => esc_html__( 'Sub Menu text color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'submenu_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_back_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#222', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_back_color_dark',
	        array(
	            'label'      => esc_html__( 'Sub menu background color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'submenu_back_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_text_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Sub Menu text color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'submenu_text_color_dark'
	        )
	    )
	);



    $wp_customize->add_setting(
	    'menu_line_color',
	    array(
	        'default'    =>  esc_attr__( '#eeedeb', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_line_color',
	        array(
	            'label'      => esc_html__( 'Section menu line color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'menu_line_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'menu_line_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#ffffff26', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'menu_line_color_dark',
	        array(
	            'label'      => esc_html__( 'Section menu line color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'menu_line_color_dark'
	        )
	    )
	);




	$wp_customize->add_setting(
	    'submenu_line_color',
	    array(
	        'default'    =>  esc_attr__( '#ebebe3', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_line_color',
	        array(
	            'label'      => esc_html__( 'Sub line text color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'submenu_line_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'submenu_line_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#464646', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'submenu_line_color_dark',
	        array(
	            'label'      => esc_html__( 'Sub line color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'submenu_line_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
        'wesper_top_m_title',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_top_m_title',
            array(
                'label'         => esc_html__( 'Top bar section color', 'wesper' ),
                'section'       => 'wesper_color_setting',
                'settings'      => 'wesper_top_m_title',
            )
        )
    );

    $wp_customize->add_setting(
	    'top_menu_bg_color',
	    array(
	        'default'    =>  esc_attr__( '#000', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_bg_color',
	        array(
	            'label'      => esc_html__( 'Top bar background', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'top_menu_bg_color'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'top_menu_text_color',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_text_color',
	        array(
	            'label'      => esc_html__( 'Top bar text color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'top_menu_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'top_menu_bg_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Top bar background dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'top_menu_bg_color_dark'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'top_menu_text_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'top_menu_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Top bar text color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'top_menu_text_color_dark'
	        )
	    )
	);

    $wp_customize->add_setting(
        'wesper_logo_m_title',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_logo_m_title',
            array(
                'label'         => esc_html__( 'Logo section color', 'wesper' ),
                'section'       => 'wesper_color_setting',
                'settings'      => 'wesper_logo_m_title',
            )
        )
    );

    $wp_customize->add_setting(
	    'head_logo_bg_color',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_bg_color',
	        array(
	            'label'      => esc_html__( 'Section logo background', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'head_logo_bg_color'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'head_logo_text_color',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_text_color',
	        array(
	            'label'      => esc_html__( 'Section logo text color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'head_logo_text_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'head_logo_bg_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_bg_color_dark',
	        array(
	            'label'      => esc_html__( 'Section logo background dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'head_logo_bg_color_dark'
	        )
	    )
	);
	$wp_customize->add_setting(
	    'head_logo_text_color_dark',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'head_logo_text_color_dark',
	        array(
	            'label'      => esc_html__( 'Section logo text color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'head_logo_text_color_dark'
	        )
	    )
	);


    $wp_customize->add_setting(
        'wesper_single_opts',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_single_opts',
            array(
                'label'         => esc_html__( 'Blog & Single content color', 'wesper' ),
                'section'       => 'wesper_color_setting',
                'settings'      => 'wesper_single_opts',
            )
        )
    );

    $wp_customize->add_setting(
	    'single_color',
	    array(
	        'default'    =>  esc_attr__( '#676767', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_color',
	        array(
	            'label'      => esc_html__( 'Single color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'single_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_color_dark',
	        array(
	            'label'      => esc_html__( 'Single color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'single_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_color',
	    array(
	        'default'    =>  esc_attr__( '#f21717', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_color',
	        array(
	            'label'      => esc_html__( 'Single link color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'single_link_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#f21717', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_color_dark',
	        array(
	            'label'      => esc_html__( 'Single link color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'single_link_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_hover_color',
	    array(
	        'default'    =>  esc_attr__( '#f21717', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_hover_color',
	        array(
	            'label'      => esc_html__( 'Single link hover color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'single_link_hover_color'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_link_hover_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#f21717', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'single_link_hover_color_dark',
	        array(
	            'label'      => esc_html__( 'Single link hover color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'single_link_hover_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_meta_color',
	    array(
	        'default'    =>  esc_attr__( '#0a0a0a', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_meta_color',
	        array(
	            'label'      => esc_html__( 'Post meta color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'post_meta_color'
	        )
	    )
	);
$wp_customize->add_setting(
	    'post_meta_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#bbb', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_meta_color_dark',
	        array(
	            'label'      => esc_html__( 'Post meta color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'post_meta_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_except_color',
	    array(
	        'default'    =>  esc_attr__( '#666', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_except_color',
	        array(
	            'label'      => esc_html__( 'Post excerpt color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'post_except_color'
	        )
	    )
	);
$wp_customize->add_setting(
	    'post_except_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#ddd', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_except_color_dark',
	        array(
	            'label'      => esc_html__( 'Post excerpt color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'post_except_color_dark'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_line_color',
	    array(
	        'default'    =>  esc_attr__( '#dbdbdb', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_line_color',
	        array(
	            'label'      => esc_html__( 'Post line color', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'post_line_color'
	        )
	    )
);

$wp_customize->add_setting(
	    'post_line_color_dark',
	    array(
	        'default'    =>  esc_attr__( '#49494b', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
    $wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'post_line_color_dark',
	        array(
	            'label'      => esc_html__( 'Post line color dark mode', 'wesper' ),
	            'section'    => 'wesper_color_setting',
	            'settings'   => 'post_line_color_dark'
	        )
	    )
);

	$wp_customize->add_setting(
        'wesper_foot_opts',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_foot_opts',
            array(
                'label'         => esc_html__( 'Footer color', 'wesper' ),
                'section'       => 'wesper_color_setting',
                'settings'      => 'wesper_foot_opts',
            )
        )
    );

    $wp_customize->add_setting(
        'footer_bg_color',
        array(
            'default'     => esc_attr__( '#111', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_bg_color',
            array(
                'label'      => esc_html__( 'Footer background color', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_bg_color'
            )
        )
    );

	$wp_customize->add_setting(
        'footer_bg_dark',
        array(
            'default'     => esc_attr__( '#000', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_bg_dark',
            array(
                'label'      => esc_html__( 'Footer background color dark mode', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_bg_dark'
            )
        )
    );

    $wp_customize->add_setting(
        'footer_text_color',
        array(
            'default'     => esc_attr__( '#a8a8aa', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_text_color',
            array(
                'label'      => esc_html__( 'Footer text color', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_text_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_text_dark',
        array(
            'default'     => esc_attr__( '#a8a8aa', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_text_dark',
            array(
                'label'      => esc_html__( 'Footer text color dark mode', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_text_dark'
            )
        )
    );    
	
	$wp_customize->add_setting(
        'footer_link_color',
        array(
            'default'     => esc_attr__( '#dcdcdc', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_color',
            array(
                'label'      => esc_html__( 'Footer link color', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_link_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_link_dark',
        array(
            'default'     => esc_attr__( '#dcdcdc', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_dark',
            array(
                'label'      => esc_html__( 'Footer link color dark mode', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_link_dark'
            )
        )
    ); 

	$wp_customize->add_setting(
        'footer_link_hcolor',
        array(
            'default'     => esc_attr__( '#f21717', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_hcolor',
            array(
                'label'      => esc_html__( 'Footer link hover color', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_link_hcolor'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_link_hdark',
        array(
            'default'     => esc_attr__( '#f21717', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_link_hdark',
            array(
                'label'      => esc_html__( 'Footer link hover color dark mode', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_link_hdark'
            )
        )
    );

	$wp_customize->add_setting(
        'footer_head_color',
        array(
            'default'     => esc_attr__( '#FFF', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_head_color',
            array(
                'label'      => esc_html__( 'Footer heading color', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_head_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_head_color_dark',
        array(
            'default'     => esc_attr__( '#FFF', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_head_color_dark',
            array(
                'label'      => esc_html__( 'Footer heading color dark mode', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_head_color_dark'
            )
        )
    );

	$wp_customize->add_setting(
        'footer_line_color',
        array(
            'default'     => esc_attr__( '#49494b', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
	$wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_line_color',
            array(
                'label'      => esc_html__( 'Footer line color', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_line_color'
            )
        )
    );    

    $wp_customize->add_setting(
        'footer_line_color_dark',
        array(
            'default'     => esc_attr__( '#49494b', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_line_color_dark',
            array(
                'label'      => esc_html__( 'Footer line color dark mode', 'wesper' ),
                'section'    => 'wesper_color_setting',
                'settings'   => 'footer_line_color_dark'
            )
        )
    );


	/*Typography*/
	$wp_customize->add_section(
		    'wesper_typography_setting',
		    array(
		        'title'     => esc_html__('Typography Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'wesper_menu_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_menu_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Navigation Settings', 'wesper' ),
	            'section'		=> 'wesper_typography_setting',
	            'settings'		=> 'wesper_menu_settings_title',
	        )
	    )
	);
	$wp_customize->add_setting(
	    'wesper_menu_font_family',
	    array(
	        'default'    =>  esc_attr__( 'Inter Tight', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_menu_font_family',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Menu font family','wesper'),
	        'type'      => 'select',
	        'choices'	=> $faces
	    )
	);
    $wp_customize->add_setting(
	    'wesper_menu_font_size',
	    array(
	        'default'    =>  esc_attr__( '16px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_menu_font_size',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Main menu font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'wesper_menu_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_menu_font_weight',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Main menu font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'wesper_menu_transform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_menu_transform',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Menu text transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_menu',
	    array(
	        'default'    =>  esc_attr__( '0em', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_menu',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Menu letter spacing','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'spacing_menu',
	    array(
	        'default'    =>  esc_attr__( '30px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'spacing_menu',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Main menu items spacing','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wesper_sub_menu_font_size',
	    array(
	        'default'    =>  esc_attr__( '14px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_sub_menu_font_size',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Sub menu font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'wesper_sub_menu_font_weight',
	    array(
	        'default'    =>  esc_attr__( '500', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_sub_menu_font_weight',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Sub menu font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);

	$wp_customize->add_setting(
	    'sub_menu_transform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sub_menu_transform',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Sub menu text transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'sub_spacing_menu',
	    array(
	        'default'    =>  esc_attr__( '0em', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sub_spacing_menu',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Sub menu letter spacing','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wesper_p_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_p_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Paragraph Settings', 'wesper' ),
	            'section'		=> 'wesper_typography_setting',
	            'settings'		=> 'wesper_p_settings_title',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'wesper_p_font_family',
	    array(
	        'default'    =>  esc_attr__( 'Inter', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_p_font_family',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Paragraph font family','wesper'),
	        'type'      => 'select',
	        'choices'	=> $faces
	    )
	);
	$wp_customize->add_setting(
	    'wesper_p_font_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_p_font_size',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Content font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'p_line_height',
	    array(
	        'default'    =>  esc_attr__( '1.5', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'p_line_height',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Content line height','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'body_font_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'body_font_size',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Body & excerpt font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'body_line_height',
	    array(
	        'default'    =>  esc_attr__( '1.5', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'body_line_height',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Body line height','wesper'),
	        'type'      => 'text'
	    )
	);


	$wp_customize->add_setting(
	    'wesper_p_font_weight',
	    array(
	        'default'    =>  esc_attr__( '400', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_p_font_weight',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Paragraph font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);


	$wp_customize->add_setting(
	    'wesper_title_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_title_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Title Settings', 'wesper' ),
	            'section'		=> 'wesper_typography_setting',
	            'settings'		=> 'wesper_title_settings_title',
	        )
	    )
	);
	$wp_customize->add_setting(
	    'wesper_title_font_family',
	    array(
	        'default'    =>  esc_attr__( 'Inter Tight', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_title_font_family',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Title font family','wesper'),
	        'type'      => 'select',
	        'choices'	=> $faces
	    )
	);
	$wp_customize->add_setting(
	    'wesper_title_font_weight',
	    array(
	        'default'    =>  esc_attr__( '800', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_title_font_weight',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Title font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'wesper_title_transform',
	    array(
	        'default'    =>  esc_attr__( 'none', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_title_transform',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Title text transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'letter_spacing_heading',
	    array(
	        'default'    =>  esc_attr__( '0em', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_heading',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Title letter spacing Ex: 0.03em','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'line_height_heading',
	    array(
	        'default'    =>  esc_attr__( '1.2', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'line_height_heading',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Title line height Ex: 1.2 ','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wesper_cat_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);

	$wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_cat_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Category, Meta', 'wesper' ),
	            'section'		=> 'wesper_typography_setting',
	            'settings'		=> 'wesper_cat_settings_title',
	        )
	    )
	);
	$wp_customize->add_setting(
        'wesper_cat_font_size',
        array(
            'default'    =>  esc_attr__( '15px', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'wesper_cat_font_size',
        array(
            'section'   => 'wesper_typography_setting',
            'label'     => esc_html__('Meta cat font size','wesper'),
            'type'      => 'select',
            'choices'   => $font_sizes
        )
    );
	$wp_customize->add_setting(
	    'wesper_cat_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_cat_font_weight',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Meta cat font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'wesper_cat_transform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_cat_transform',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Meta cat text transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_cat',
	    array(
	        'default'    =>  esc_attr__( '0em', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_cat',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Meta cat letter spacing Ex: 0.03em','wesper'),
	        'type'      => 'text'
	    )
	);
	$wp_customize->add_setting(
        'wesper_meta_font_size',
        array(
            'default'    =>  esc_attr__( '11px', 'wesper' ),
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'wesper_meta_font_size',
        array(
            'section'   => 'wesper_typography_setting',
            'label'     => esc_html__('Meta font size','wesper'),
            'type'      => 'select',
            'choices'   => $font_sizes
        )
    );
	$wp_customize->add_setting(
	    'wesper_meta_font_weight',
	    array(
	        'default'    =>  esc_attr__( '400', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_meta_font_weight',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Meta font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);

	$wp_customize->add_setting(
	    'wesper_meta_a_font_weight',
	    array(	        
			'default'    =>  esc_attr__( '600', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_meta_a_font_weight',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Meta link font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);

	$wp_customize->add_setting(
	    'wesper_meta_transform',
	    array(
	        'default'    =>  esc_attr__( 'uppercase', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_meta_transform',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Meta text transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_meta',
	    array(
	        'default'    =>  esc_attr__( '.04em', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_meta',
	    array(
	        'section'   => 'wesper_typography_setting',
	        'label'     => esc_html__('Meta letter spacing Ex: 0.03em','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
		'wesper_widget_title_setting',
		array(
			'default'     => '',
			'transport'   => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	
	$wp_customize->add_control(
		new wesper_Customize_Control_Title (
			$wp_customize,
			'wesper_widget_title_setting',
			array(
				'label'      	=> esc_html__( 'Widget title setting', 'wesper' ),
				'section'		=> 'wesper_typography_setting',
				'settings'		=> 'wesper_widget_title_setting',
			)
		)
	);
	
	$wp_customize->add_setting(
			'wesper_widget_font',
			array(
				'default'    =>  esc_attr__( 'jl_weg_title', 'wesper' ),
				'transport'  =>  'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'wesper_widget_font',
			array(
				'section'   => 'wesper_typography_setting',
				'label'     => esc_html__('Widget Font','wesper'),
				'type'      => 'select',
				'choices' 	=> array(
					'none' => esc_html__('None', 'wesper'),
					'jl_weg_title' => esc_html__('Title font', 'wesper'),
					'jl_weg_menu' => esc_html__('Menu font', 'wesper')
				)
			)
	);
	
	$wp_customize->add_setting(
			'wesper_widget_font_size',
			array(
				'default'    =>  esc_attr__( '18px', 'wesper' ),
				'transport'   => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'wesper_widget_font_size',
			array(
				'section'   => 'wesper_typography_setting',
				'label'     => esc_html__('Widget font size','wesper'),
				'type'      => 'select',
				'choices'   => $font_sizes
			)
	);
	
	$wp_customize->add_setting(
			'wesper_widget_transform',
			array(
				'default'    =>  esc_attr__( 'uppercase', 'wesper' ),
				'transport'  =>  'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'wesper_widget_transform',
			array(
				'section'   => 'wesper_typography_setting',
				'label'     => esc_html__('Widget text transform','wesper'),
				'type'      => 'select',
				'choices' 	=> array(
					'none' => esc_html__('None', 'wesper'),
					'capitalize' => esc_html__('Capitalize', 'wesper'),
					'uppercase' => esc_html__('Uppercase', 'wesper')
				)
			)
	);
	
	$wp_customize->add_setting(
			'wesper_widget_letter_spacing',
			array(
				'default'    =>  esc_attr__( '0em', 'wesper' ),
				'transport'  =>  'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			)
	);
	$wp_customize->add_control(
			'wesper_widget_letter_spacing',
			array(
				'section'   => 'wesper_typography_setting',
				'label'     => esc_html__('Widget letter spacing Ex: 0.03em','wesper'),
				'type'      => 'text'
			)
	);

	

	/*Button*/
	$wp_customize->add_section(
		    'wesper_button_setting',
		    array(
		        'title'     => esc_html__('Button & Load More Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'wesper_button_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_button_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Button Settings', 'wesper' ),
	            'section'		=> 'wesper_button_setting',
	            'settings'		=> 'wesper_button_settings_title',
	        )
	    )
	);
    $wp_customize->add_setting(
	    'wesper_button_font_size',
	    array(
	        'default'    =>  esc_attr__( '12px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_button_font_size',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Button font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'wesper_button_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_button_font_weight',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Button font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'wesper_button_transform',
	    array(
	        'default'    =>  esc_attr__( 'uppercase', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_button_transform',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Button text transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_button',
	    array(
	        'default'    =>  esc_attr__( '0.1em', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_button',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Button letter spacing','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'button_radius',
	    array(
	        'default'    =>  esc_attr__( '4px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'button_radius',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Button border radius','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wesper_loadmore_settings_title',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_loadmore_settings_title',
	        array(
	            'label'      	=> esc_html__( 'Load More Settings', 'wesper' ),
	            'section'		=> 'wesper_button_setting',
	            'settings'		=> 'wesper_loadmore_settings_title',
	        )
	    )
	);
    $wp_customize->add_setting(
	    'wesper_loadmore_font_size',
	    array(
	        'default'    =>  esc_attr__( '12px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_loadmore_font_size',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Load More font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	$wp_customize->add_setting(
	    'wesper_loadmore_font_weight',
	    array(
	        'default'    =>  esc_attr__( '700', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_loadmore_font_weight',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Load More font weight','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_weights
	    )
	);
	$wp_customize->add_setting(
	    'wesper_loadmore_transform',
	    array(
	        'default'    =>  esc_attr__( 'uppercase', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wesper_loadmore_transform',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Load More text transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);
	$wp_customize->add_setting(
	    'letter_spacing_loadmore',
	    array(
	        'default'    =>  esc_attr__( '0.1em', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'letter_spacing_loadmore',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Load More letter spacing','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'load_more_radius',
	    array(
	        'default'    =>  esc_attr__( '4px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'load_more_radius',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Load more border radius','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'load_more_width',
	    array(
	        'default'    =>  esc_attr__( '290px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'load_more_width',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Load more width EX: 200px','wesper'),
	        'type'      => 'text'
	    )
	);
	
	$wp_customize->add_setting(
	    'load_more_height',
	    array(
	        'default'    =>  esc_attr__( '48px', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'load_more_height',
	    array(
	        'section'   => 'wesper_button_setting',
	        'label'     => esc_html__('Load more height EX: 40px','wesper'),
	        'type'      => 'text'
	    )
	);


	/*Blog & single post*/
	$wp_customize->add_section(
		    'wesper_blog_single_setting',
		    array(
		        'title'     => esc_html__('Blog & Single Post Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'wesper_cat_lbl',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_cat_lbl',
	        array(
	            'label'      	=> esc_html__( 'Category label', 'wesper' ),
	            'section'		=> 'wesper_blog_single_setting',
	            'settings'		=> 'wesper_cat_lbl',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_grid',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_grid',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Category label grid layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'wesper'),
			'cat_label_2' => esc_html__('Text only', 'wesper'),
			'cat_label_3' => esc_html__('Background color', 'wesper'),
			'cat_label_4' => esc_html__('Background color overlay bottom', 'wesper'),
			'cat_label_5' => esc_html__('Background color overlay bottom no space', 'wesper'),
			'cat_label_6' => esc_html__('Background color overlay bottom center no space', 'wesper'),
			'cat_label_7' => esc_html__('Background color overlay top', 'wesper'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_list',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_list',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Category label list layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'wesper'),
			'cat_label_2' => esc_html__('Text only', 'wesper'),
			'cat_label_3' => esc_html__('Background color', 'wesper')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_overlay',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_overlay',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Category label overlay layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'wesper'),
			'cat_label_2' => esc_html__('Text only', 'wesper'),
			'cat_label_3' => esc_html__('Background color', 'wesper')
	        )
	    )
	);	

	$wp_customize->add_setting(
	    'category_label_small_list',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_small_list',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Category label small layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'wesper'),
			'cat_label_2' => esc_html__('Text only', 'wesper'),			
			'cat_label_3' => esc_html__('Background color', 'wesper')
	        )
	    )
	);	

	$wp_customize->add_setting(
	    'category_label_single',
	    array(
	        'default'    =>  esc_attr__( 'cat_label_1', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_single',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Category label single post','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'cat_label_1' => esc_html__('Text with line', 'wesper'),
			'cat_label_2' => esc_html__('Text only', 'wesper'),
			'cat_label_3' => esc_html__('Background color', 'wesper')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'category_label_padding',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_padding',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Category padding EX: 2px 10px','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'category_label_radius',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'category_label_radius',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Category border radius EX: 10px','wesper'),
	        'type'      => 'text'
	    )
	);		

	$wp_customize->add_setting(
	    'wesper_achv_layout',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_achv_layout',
	        array(
	            'label'      	=> esc_html__( 'Archive layout options', 'wesper' ),
	            'section'		=> 'wesper_blog_single_setting',
	            'settings'		=> 'wesper_achv_layout',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_archive_layout',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_archive_layout',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Archive layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'wesper'),
				'archive2' => esc_html__('Grid post 3 columns', 'wesper'),
				'archive3' => esc_html__('Grid post 4 columns', 'wesper'),
				'archive4' => esc_html__('Post mian + list', 'wesper'),
				'archive5' => esc_html__('Post mix + list', 'wesper'),
				'archive6' => esc_html__('Post mian + grid', 'wesper'),
				'archive7' => esc_html__('Post list', 'wesper'),
				'archive8' => esc_html__('Post classic', 'wesper'),
				'archive9' => esc_html__('Post overlay 2 columns', 'wesper'),
				'archive10' => esc_html__('Post overlay 3 columns', 'wesper'),
				'archive11' => esc_html__('Post overlay 4 columns', 'wesper'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_archive_category',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_archive_category',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Archive category layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'wesper'),
				'archive2' => esc_html__('Grid post 3 columns', 'wesper'),
				'archive3' => esc_html__('Grid post 4 columns', 'wesper'),
				'archive4' => esc_html__('Post mian + list', 'wesper'),
				'archive5' => esc_html__('Post mix + list', 'wesper'),
				'archive6' => esc_html__('Post mian + grid', 'wesper'),
				'archive7' => esc_html__('Post list', 'wesper'),
				'archive8' => esc_html__('Post classic', 'wesper'),
				'archive9' => esc_html__('Post overlay 2 columns', 'wesper'),
				'archive10' => esc_html__('Post overlay 3 columns', 'wesper'),
				'archive11' => esc_html__('Post overlay 4 columns', 'wesper'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_archive_tag',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_archive_tag',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Archive tag layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'wesper'),
				'archive2' => esc_html__('Grid post 3 columns', 'wesper'),
				'archive3' => esc_html__('Grid post 4 columns', 'wesper'),
				'archive4' => esc_html__('Post mian + list', 'wesper'),
				'archive5' => esc_html__('Post mix + list', 'wesper'),
				'archive6' => esc_html__('Post mian + grid', 'wesper'),
				'archive7' => esc_html__('Post list', 'wesper'),
				'archive8' => esc_html__('Post classic', 'wesper'),
				'archive9' => esc_html__('Post overlay 2 columns', 'wesper'),
				'archive10' => esc_html__('Post overlay 3 columns', 'wesper'),
				'archive11' => esc_html__('Post overlay 4 columns', 'wesper'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_archive_search',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_archive_search',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Archive search layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'wesper'),
				'archive2' => esc_html__('Grid post 3 columns', 'wesper'),
				'archive3' => esc_html__('Grid post 4 columns', 'wesper'),
				'archive4' => esc_html__('Post mian + list', 'wesper'),
				'archive5' => esc_html__('Post mix + list', 'wesper'),
				'archive6' => esc_html__('Post mian + grid', 'wesper'),
				'archive7' => esc_html__('Post list', 'wesper'),
				'archive8' => esc_html__('Post classic', 'wesper'),
				'archive9' => esc_html__('Post overlay 2 columns', 'wesper'),
				'archive10' => esc_html__('Post overlay 3 columns', 'wesper'),
				'archive11' => esc_html__('Post overlay 4 columns', 'wesper'),				
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_archive_author',
	    array(
	        'default'    =>  esc_attr__( 'archive7', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_archive_author',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Archive author layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'archive1' => esc_html__('Grid post 2 columns', 'wesper'),
				'archive2' => esc_html__('Grid post 3 columns', 'wesper'),
				'archive3' => esc_html__('Grid post 4 columns', 'wesper'),
				'archive4' => esc_html__('Post mian + list', 'wesper'),
				'archive5' => esc_html__('Post mix + list', 'wesper'),
				'archive6' => esc_html__('Post mian + grid', 'wesper'),
				'archive7' => esc_html__('Post list', 'wesper'),
				'archive8' => esc_html__('Post classic', 'wesper'),
				'archive9' => esc_html__('Post overlay 2 columns', 'wesper'),
				'archive10' => esc_html__('Post overlay 3 columns', 'wesper'),
				'archive11' => esc_html__('Post overlay 4 columns', 'wesper'),				
	        )
	    )
	);

	$wp_customize->add_setting(
		'show_classic_social',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'show_classic_social',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Show share on classic layout','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
	    'jl_archive_pagination',
	    array(
	        'default'    =>  esc_attr__( 'number', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_archive_pagination',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Archive pagination layouts','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'number' => esc_html__('Number', 'wesper'),				
				'loadmore' => esc_html__('Load more', 'wesper'),
				'autoload' => esc_html__('Auto load', 'wesper')				
	        )
	    )
	);

	$wp_customize->add_setting(
		'jl_archive_img',
		array(
			'default'    =>  '',
			'transport'  =>  'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'jl_archive_img',
		array(
			'section'   => 'wesper_blog_single_setting',
			'label'     => esc_html__('Archive Image size','wesper'),
			'type'      => 'select',
			'choices'	=> array(
				''      			=>esc_html__( 'Default image size', 'wesper' ),      
				'wesper_large'      =>esc_html__( '1600 x 0', 'wesper' ),
				'wesper_medium'      =>esc_html__( '1100 x 0', 'wesper' ),
				'wesper_small'      =>esc_html__( '150 x 150', 'wesper' ),
				'wesper_layouts'      =>esc_html__( '680 x 580', 'wesper' ),
				'wesper_list'      =>esc_html__( '600 x 0', 'wesper' ),
			)
		)
	);
		

	$wp_customize->add_setting(
		'wesper_achv_metas',
		array(
			'default'     => '',
			'transport'   => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		new wesper_Customize_Control_Title (
			$wp_customize,
			'wesper_achv_metas',
			array(
				'label'      	=> esc_html__( 'Archive meta', 'wesper' ),
				'section'		=> 'wesper_blog_single_setting',
				'settings'		=> 'wesper_achv_metas',
			)
		)
	);

	$wp_customize->add_setting(
		'show_author_img',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'show_author_img',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Show meta author image','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_author',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_author',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Hide meta author','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_cat',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_cat',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Hide meta category','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_date',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_date',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Hide meta date','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'hide_front_author_date',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_front_author_date',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Hide meta author & date','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
	    'btn_txt',
	    array(
			'default'    =>  esc_attr__( 'Continue Reading', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'btn_txt',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Read more text','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wesper_single_layout',
	    array(
	        'default'     => '',
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    new wesper_Customize_Control_Title (
	        $wp_customize,
	        'wesper_single_layout',
	        array(
	            'label'      	=> esc_html__( 'Single post options', 'wesper' ),
	            'section'		=> 'wesper_blog_single_setting',
	            'settings'		=> 'wesper_single_layout',
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_post_layout_options',
	    array(
	        'default'    =>  esc_attr__( 'single1', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'single_post_layout_options',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Single Post Layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'single1' => esc_html__('Post Layout 1', 'wesper'),
			'single2' => esc_html__('Post Layout 2', 'wesper'),
			'single3' => esc_html__('Post Layout 3', 'wesper'),
			'single4' => esc_html__('Post Layout 4', 'wesper'),
			'single5' => esc_html__('Post Layout 5', 'wesper'),
			'single6' => esc_html__('Post Layout 6', 'wesper'),
			'single7' => esc_html__('Post Layout 7', 'wesper'),
			'single8' => esc_html__('Post Layout 8', 'wesper'),
			'single9' => esc_html__('Post Layout 9', 'wesper'),
			'single10' => esc_html__('Post Layout 10', 'wesper'),
			'single11' => esc_html__('Post Layout 11', 'wesper'),
			'single12' => esc_html__('Post Layout 12', 'wesper'),
			'single13' => esc_html__('Post Layout 13', 'wesper'),
			'single14' => esc_html__('Post Layout 14', 'wesper'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'post_sidebar_position',
	    array(
	        'default'    =>  esc_attr__( 'jl_sright_side', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'post_sidebar_position',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Sidebar Position','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'jl_sleft_side' => 'Left Sidebar',
				'jl_sright_side' => 'Right Sidebar'
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_video_style',
	    array(
	        'default'    =>  esc_attr__( 'background', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_video_style',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Post Video Layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'background' => esc_html__('Video background', 'wesper'),
			'popup' => esc_html__('Video popup', 'wesper'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_gallery_type',
	    array(
	        'default'    =>  esc_attr__( 'slider', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_gallery_type',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Single Post Gallery Layout','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'slider' => esc_html__('Gallery Slider', 'wesper'),
					'popup' => esc_html__('Gallery Popup', 'wesper'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'single_title_size',
	    array(
	        'default'    =>  esc_attr__( '40px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'single_title_size',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Post title font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);
	
	$wp_customize->add_setting(
	    'wesper_nav_post_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_nav_post_size',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Post Next/Previous font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'wesper_related_size',
	    array(
	        'default'    =>  esc_attr__( '20px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'wesper_related_size',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Related font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'related_num',
	    array(
			'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'related_num',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Number of related post','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_related_img',
	    array(
	        'default'    =>  esc_attr__( 'wesper_layouts', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_related_img',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Related Image size','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
				'wesper_large'      =>esc_html__( '1600 x 0', 'wesper' ),
				'wesper_medium'      =>esc_html__( '1100 x 0', 'wesper' ),
				'wesper_small'      =>esc_html__( '150 x 150', 'wesper' ),
				'wesper_layouts'      =>esc_html__( '680 x 580', 'wesper' ),
				'wesper_list'      =>esc_html__( '600 x 0', 'wesper' ),
	        )
	    )
	);

	$wp_customize->add_setting(
		'hide_breadcrumb',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'hide_breadcrumb',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Hide breadcrumb','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_date',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_date',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post meta date','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_readtime',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_readtime',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post meta read time','wesper'),
	        'type'      => 'checkbox'
	    )
	);
	$wp_customize->add_setting(
		'disable_post_view',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_view',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post meta view','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_meta_author',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_meta_author',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post meta author','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_author_img',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_author_img',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post meta author image','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_author',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_author',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post author box','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_author_box_img',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_author_box_img',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post author box image','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_category',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_category',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post category','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
	    'jl_review_bar',
	    array(
	        'default'    =>  esc_attr__( 'show', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_review_bar',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Hide/Show Review bar','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        		'show' => esc_html__('show', 'wesper'),
					'hide' => esc_html__('hide', 'wesper'),
	        )
	    )
	);

	$wp_customize->add_setting(
		'disable_post_tag',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_tag',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post tag','wesper'),
	        'type'      => 'checkbox'
	    )
	);	
	$wp_customize->add_setting(
		'disable_post_tag',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_tag',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post tag','wesper'),
	        'type'      => 'checkbox'
	    )
	);	

	$wp_customize->add_setting(
		'disable_post_share_footer',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_share_footer',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable footer post share','wesper'),
	        'type'      => 'checkbox'
	    )
	);	

	$wp_customize->add_setting(
		'disable_post_nav',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_nav',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post Next/Previous','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_section_comment',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_section_comment',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable section comment','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_section_comment_title',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_section_comment_title',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable section comment title','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_post_related',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_post_related',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable related post','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_fb',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_fb',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share Facebook','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_tw',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_tw',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share Twitter','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_pin',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_pin',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share Pinterest','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_in',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_in',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share Linkedin','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_whatsapp',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_whatsapp',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share whatsapp','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_telegram',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_telegram',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share telegram','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_tumblr',
		array(
			'default' => true,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_tumblr',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share tumblr','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'disable_s_share_line',
		array(
			'default' => true,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_line',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share line','wesper'),
	        'type'      => 'checkbox'
	    )
	);
	

	$wp_customize->add_setting(
		'disable_s_share_mail',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'disable_s_share_mail',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Disable post footer share Mail','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	$wp_customize->add_setting(
		'wesper_share_side_single',
		array(
				'default'     => '',
				'transport'   => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
		)
);
	$wp_customize->add_control(
		new wesper_Customize_Control_Title (
				$wp_customize,
				'wesper_share_side_single',
				array(
						'label'      	=> esc_html__( 'Single post share left side', 'wesper' ),
						'section'		=> 'wesper_blog_single_setting',
						'settings'		=> 'wesper_share_side_single',
				)
		)
);

$wp_customize->add_setting(
	'single_left_share_style',
	array(
		'default'    =>  esc_attr__( 'jl_share_l_line', 'wesper' ),
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_left_share_style',
	array(
		'section'   => 'wesper_blog_single_setting',
		'label'     => esc_html__('Share layout','wesper'),
		'type'      => 'select',
		'choices'	=> array(
			'jl_share_l_line' => esc_html__('Share line layout', 'wesper'),
			'jl_share_l_bg' => esc_html__('Share background layout', 'wesper'),
		)
	)
);

$wp_customize->add_setting(
	'disable_post_share',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'disable_post_share',
	array(
		'section'   => 'wesper_blog_single_setting',
		'label'     => esc_html__('Disable left post share','wesper'),
		'type'      => 'checkbox'
	)
);

$wp_customize->add_setting(
    'disable_l_share_fb',
    array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_fb',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share Facebook','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_tw',
    array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_tw',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share Twitter','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_pin',
    array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_pin',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share Pinterest','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_in',
    array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_in',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share Linkedin','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_whatsapp',
    array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_whatsapp',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share whatsapp','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_telegram',
    array(
        'default' => true,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_telegram',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share telegram','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_tumblr',
    array(
        'default' => true,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_tumblr',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share tumblr','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_line',
    array(
        'default' => true,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_line',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share line','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
    'disable_l_share_mail',
    array(
        'default' => true,
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'disable_l_share_mail',
    array(
        'section'   => 'wesper_blog_single_setting',
        'label'     => esc_html__('Disable post left share Mail','wesper'),
        'type'      => 'checkbox'
    )
);

$wp_customize->add_setting(
	'wesper_single_share_order',
	array(
			'default'     => '',
			'transport'   => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	new wesper_Customize_Control_Title (
			$wp_customize,
			'wesper_single_share_order',
			array(
					'label'      	=> esc_html__( 'Single post share order', 'wesper' ),
					'section'		=> 'wesper_blog_single_setting',
					'settings'		=> 'wesper_single_share_order',
			)
	)
);

$wp_customize->add_setting(
	'single_order_1',
	array(
		'default'    =>  'jl_sli_fb',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_order_1',
	array(
		'section'   => 'wesper_blog_single_setting',
		'type'      => 'select',
		'choices'	=> array(
			'jl_sli_fb' => esc_html__('Facebook', 'wesper'),
			'jl_sli_tw' => esc_html__('Twitter', 'wesper'),
			'jl_sli_pi' => esc_html__('Pinterest', 'wesper'),
			'jl_sli_din' => esc_html__('LinkedIn', 'wesper'),
			'jl_sli_wapp' => esc_html__('WhatsApp', 'wesper'),
			'jl_sli_tele' => esc_html__('Telegram', 'wesper'),
			'jl_sli_mil' => esc_html__('Mail', 'wesper'),
		)
	)
);

$wp_customize->add_setting(
	'single_order_2',
	array(
		'default'    =>  'jl_sli_tw',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_order_2',
	array(
		'section'   => 'wesper_blog_single_setting',
		'type'      => 'select',
		'choices'	=> array(
			'jl_sli_fb' => esc_html__('Facebook', 'wesper'),
			'jl_sli_tw' => esc_html__('Twitter', 'wesper'),
			'jl_sli_pi' => esc_html__('Pinterest', 'wesper'),
			'jl_sli_din' => esc_html__('LinkedIn', 'wesper'),
			'jl_sli_wapp' => esc_html__('WhatsApp', 'wesper'),
			'jl_sli_tele' => esc_html__('Telegram', 'wesper'),
			'jl_sli_mil' => esc_html__('Mail', 'wesper'),
		)
	)
);

$wp_customize->add_setting(
	'single_order_3',
	array(
		'default'    =>  'jl_sli_pi',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_order_3',
	array(
		'section'   => 'wesper_blog_single_setting',
		'type'      => 'select',
		'choices'	=> array(
			'jl_sli_fb' => esc_html__('Facebook', 'wesper'),
			'jl_sli_tw' => esc_html__('Twitter', 'wesper'),
			'jl_sli_pi' => esc_html__('Pinterest', 'wesper'),
			'jl_sli_din' => esc_html__('LinkedIn', 'wesper'),
			'jl_sli_wapp' => esc_html__('WhatsApp', 'wesper'),
			'jl_sli_tele' => esc_html__('Telegram', 'wesper'),
			'jl_sli_mil' => esc_html__('Mail', 'wesper'),
		)
	)
);

$wp_customize->add_setting(
	'single_order_4',
	array(
		'default'    =>  'jl_sli_din',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_order_4',
	array(
		'section'   => 'wesper_blog_single_setting',
		'type'      => 'select',
		'choices'	=> array(
			'jl_sli_fb' => esc_html__('Facebook', 'wesper'),
			'jl_sli_tw' => esc_html__('Twitter', 'wesper'),
			'jl_sli_pi' => esc_html__('Pinterest', 'wesper'),
			'jl_sli_din' => esc_html__('LinkedIn', 'wesper'),
			'jl_sli_wapp' => esc_html__('WhatsApp', 'wesper'),
			'jl_sli_tele' => esc_html__('Telegram', 'wesper'),
			'jl_sli_mil' => esc_html__('Mail', 'wesper'),
		)
	)
);

$wp_customize->add_setting(
	'single_order_5',
	array(
		'default'    =>  'jl_sli_wapp',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_order_5',
	array(
		'section'   => 'wesper_blog_single_setting',
		'type'      => 'select',
		'choices'	=> array(
			'jl_sli_fb' => esc_html__('Facebook', 'wesper'),
			'jl_sli_tw' => esc_html__('Twitter', 'wesper'),
			'jl_sli_pi' => esc_html__('Pinterest', 'wesper'),
			'jl_sli_din' => esc_html__('LinkedIn', 'wesper'),
			'jl_sli_wapp' => esc_html__('WhatsApp', 'wesper'),
			'jl_sli_tele' => esc_html__('Telegram', 'wesper'),
			'jl_sli_mil' => esc_html__('Mail', 'wesper'),
		)
	)
);

$wp_customize->add_setting(
	'single_order_6',
	array(
		'default'    =>  'jl_sli_tele',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_order_6',
	array(
		'section'   => 'wesper_blog_single_setting',
		'type'      => 'select',
		'choices'	=> array(
			'jl_sli_fb' => esc_html__('Facebook', 'wesper'),
			'jl_sli_tw' => esc_html__('Twitter', 'wesper'),
			'jl_sli_pi' => esc_html__('Pinterest', 'wesper'),
			'jl_sli_din' => esc_html__('LinkedIn', 'wesper'),
			'jl_sli_wapp' => esc_html__('WhatsApp', 'wesper'),
			'jl_sli_tele' => esc_html__('Telegram', 'wesper'),
			'jl_sli_mil' => esc_html__('Mail', 'wesper'),
		)
	)
);

$wp_customize->add_setting(
	'single_order_7',
	array(
		'default'    =>  'jl_sli_mil',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'single_order_7',
	array(
		'section'   => 'wesper_blog_single_setting',
		'type'      => 'select',
		'choices'	=> array(
			'jl_sli_fb' => esc_html__('Facebook', 'wesper'),
			'jl_sli_tw' => esc_html__('Twitter', 'wesper'),
			'jl_sli_pi' => esc_html__('Pinterest', 'wesper'),
			'jl_sli_din' => esc_html__('LinkedIn', 'wesper'),
			'jl_sli_wapp' => esc_html__('WhatsApp', 'wesper'),
			'jl_sli_tele' => esc_html__('Telegram', 'wesper'),
			'jl_sli_mil' => esc_html__('Mail', 'wesper'),
		)
	)
);

	
$wp_customize->add_setting(
			'wesper_auto_single',
			array(
					'default'     => '',
					'transport'   => 'refresh',
					'sanitize_callback' => 'sanitize_text_field',
			)
	);
		$wp_customize->add_control(
			new wesper_Customize_Control_Title (
					$wp_customize,
					'wesper_auto_single',
					array(
							'label'      	=> esc_html__( 'Auto load next post options', 'wesper' ),
							'section'		=> 'wesper_blog_single_setting',
							'settings'		=> 'wesper_auto_single',
					)
			)
	);

	$wp_customize->add_setting(
	    'single_auto_load_post',
	    array(
	        'default'    =>  esc_attr__( 'disable', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'single_auto_load_post',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Auto load next post','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        	'enable' => esc_html__('Enable', 'wesper'),
				'disable' => esc_html__('Disable', 'wesper'),
	        )
	    )
	);

	$wp_customize->add_setting(
	    'auto_load_num',
	    array(
	        'default'     => 10,
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'auto_load_num',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Auto load number post','wesper'),
	        'type'      => 'select',
	        'choices'	=> $num_sizes
	    )
	);

	$wp_customize->add_setting(
	    'single_auto_load_type',
	    array(
	        'default'    =>  esc_attr__( 'previous', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'single_auto_load_type',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Auto load next type','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        	'previous' => esc_html__('Previous Date', 'wesper'),
				'next' => esc_html__('Next Date', 'wesper'),
				'random' => esc_html__('Random', 'wesper'),
	        )
	    )
	);

	$wp_customize->add_setting(
		'auto_same_cat',
		array(
			'default' => false,
			'transport' => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
	    'auto_same_cat',
	    array(
	        'section'   => 'wesper_blog_single_setting',
	        'label'     => esc_html__('Load Same Category','wesper'),
	        'type'      => 'checkbox'
	    )
	);

	/*Single post progress settings*/
	$wp_customize->add_section(
		'wesper_blog_reading_setting',
		array(
			'title'     => esc_html__('Single Post Progress Settings', 'wesper'),
			'priority'  => 1,
			'panel' => 'wesper_theme_options'
		)
);

$wp_customize->add_setting(
	'enable_read_progress',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'enable_read_progress',
	array(
		'section'   => 'wesper_blog_reading_setting',
		'label'     => esc_html__('Enable reading progresss','wesper'),
		'type'      => 'checkbox'
	)
);

$wp_customize->add_setting(
	'sp_progress_height',
	array(
		'default'    =>  esc_attr__( '5px', 'wesper' ),
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'sp_progress_height',
	array(
		'section'   => 'wesper_blog_reading_setting',
		'label'     => esc_html__('Height progress bar EX: 5px','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'sp_progress_pos',
	array(
		'default'    =>  'top',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'sp_progress_pos',
	array(
		'section'   => 'wesper_blog_reading_setting',
		'label'     => esc_html__('Progress bar position','wesper'),
		'type'      => 'select',
		'choices'	=> array(	        
		'top' => esc_html__('Top position', 'wesper'),
		'bottom' => esc_html__('Bottom position', 'wesper')
		)
	)
);

$wp_customize->add_setting(
	'sp_color1',
	array(
		'default'    =>  esc_attr__( '#ff0080', 'wesper' ),
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sp_color1',
		array(
			'label'      => esc_html__( 'First gradient color', 'wesper' ),
			'section'    => 'wesper_blog_reading_setting',
			'settings'   => 'sp_color1'
		)
	)
);

$wp_customize->add_setting(
	'sp_color2',
	array(
		'default'    =>  esc_attr__( '#8100ff', 'wesper' ),
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sp_color2',
		array(
			'label'      => esc_html__( 'Second gradient color', 'wesper' ),
			'section'    => 'wesper_blog_reading_setting',
			'settings'   => 'sp_color2'
		)
	)
);


	/*Sidebar*/
	$wp_customize->add_section(
		    'wesper_sidebar_setting',
		    array(
		        'title'     => esc_html__('Sidebar Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);
	$wp_customize->add_setting(
        'disable_widget_block',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'disable_widget_block',
        array(
            'section'   => 'wesper_sidebar_setting',
            'label'     => esc_html__('Disable widget block','wesper'),
            'type'      => 'checkbox'
        )
    );
	$wp_customize->add_setting(
	    'post_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'post_sidebar',
	    array(
	        'section'   => 'wesper_sidebar_setting',
	        'label'     => esc_html__('Post sidebar','wesper'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'page_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'page_sidebar',
	    array(
	        'section'   => 'wesper_sidebar_setting',
	        'label'     => esc_html__('Page sidebar','wesper'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'category_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'category_sidebar',
	    array(
	        'section'   => 'wesper_sidebar_setting',
	        'label'     => esc_html__('Category sidebar','wesper'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'tag_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'tag_sidebar',
	    array(
	        'section'   => 'wesper_sidebar_setting',
	        'label'     => esc_html__('Tag sidebar','wesper'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'archive_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'archive_sidebar',
	    array(
	        'section'   => 'wesper_sidebar_setting',
	        'label'     => esc_html__('Archive sidebar','wesper'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'author_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'author_sidebar',
	    array(
	        'section'   => 'wesper_sidebar_setting',
	        'label'     => esc_html__('Author sidebar','wesper'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);

	$wp_customize->add_setting(
	    'search_sidebar',
	    array(
	        'default'    =>  esc_attr__( 'default', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'search_sidebar',
	    array(
	        'section'   => 'wesper_sidebar_setting',
	        'label'     => esc_html__('Search sidebar','wesper'),
	        'type'      => 'select',
	        'choices'	=> $option_sidebar
	    )
	);


	/*Social Header Link*/
	$wp_customize->add_section(
		    'wesper_social_setting',
		    array(
		        'title'     => esc_html__('Social Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
	    'facebook',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'facebook',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Facebook','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'twitter',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'twitter',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Twitter','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'instagram',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'instagram',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Instagram','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'pinterest',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'pinterest',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Pinterest','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'youtube',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'youtube',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Youtube','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vimeo',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vimeo',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Vimeo','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'sound_cloud',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sound_cloud',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Sound Cloud','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'spotify_i',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'spotify_i',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Spotify','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'whatsapp',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'whatsapp',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('whatsapp','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'linkedin',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'linkedin',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Linkedin','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'behance',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'behance',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Behance','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'telegram',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'telegram',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Telegram','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'tumblr',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'tumblr',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Tumblr','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'deviantart',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'deviantart',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Deviantart','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'dribble',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'dribble',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Dribble','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'dropbox',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'dropbox',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Dropbox','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'rss',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'rss',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('RSS','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'skype',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'skype',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Skype','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'stumbleupon',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'stumbleupon',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Stumbleupon','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wordpress',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wordpress',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('WordPress','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'yahoo',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'yahoo',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Yahoo','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'flickr',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'flickr',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('Flickr','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'wechat',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'wechat',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('wechat','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'tiktok',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'tiktok',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('TikTok','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'vk',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'vk',
	    array(
	        'section'   => 'wesper_social_setting',
	        'label'     => esc_html__('VK','wesper'),
	        'type'      => 'text'
	    )
	);


	/*Footer*/
	$wp_customize->add_section(
		    'wesper_footer_setting',
		    array(
		        'title'     => esc_html__('Footer Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'wesper_footer_opt',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_footer_opt',
            array(
                'label'         => esc_html__( 'Footer Options', 'wesper' ),
                'section'       => 'wesper_footer_setting',
                'settings'      => 'wesper_footer_opt',
            )
        )
    );

	$wp_customize->add_setting(
	    'footer_columns',
	    array(
	        'default'    =>  'footer3col',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'footer_columns',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Footer columns','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'footer4col' => esc_html__('Footer 4 columns', 'wesper'),
			'footer3col' => esc_html__('Footer 3 columns', 'wesper'),
			'footer2col' => esc_html__('Footer 2 columns', 'wesper'),
			'footer1col' => esc_html__('Footer 1 columns', 'wesper'),
			'footer0col' => esc_html__('No Footer', 'wesper')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'footer_menu_col',
	    array(
	        'default'    =>  '1',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'footer_menu_col',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Footer menu widget columns','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        '1' => esc_html__('Footer menu 1 columns', 'wesper'),
			'2' => esc_html__('Footer menu 2 columns', 'wesper'),
			'3' => esc_html__('Footer menu 3 columns', 'wesper'),
			'4' => esc_html__('Footer menu 4 columns', 'wesper'),
			'5' => esc_html__('Footer menu 5 columns', 'wesper')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'footer_title_size',
	    array(
	        'default'    =>  esc_attr__( '18px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_title_size',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Footer title font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'footer_font_size',
	    array(
	        'default'    =>  esc_attr__( '15px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_font_size',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Footer text font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'footer_copyright_size',
	    array(
	        'default'    =>  esc_attr__( '14px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_copyright_size',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Copyright font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'footer_menu_size',
	    array(
	        'default'    =>  esc_attr__( '14px', 'wesper' ),
	        'transport'   => 'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
    $wp_customize->add_control(
	    'footer_menu_size',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Footer Menu font size','wesper'),
	        'type'      => 'select',
	        'choices'	=> $font_sizes
	    )
	);

	$wp_customize->add_setting(
	    'sub_footer',
	    array(
	        'default'    =>  esc_attr__( 'sub_footer0', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'sub_footer',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Sub footer style','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'sub_footer1' => esc_html__('Footer logo + Copyright + Menu + Social', 'wesper'),
			'sub_footer2' => esc_html__('Copyright + Social', 'wesper'),
			'sub_footer3' => esc_html__('Copyright + Menu', 'wesper'),
			'sub_footer4' => esc_html__('Copyright Center', 'wesper'),
			'sub_footer5' => esc_html__('Footer Menu Center', 'wesper'),
			'sub_footer0' => esc_html__('Disable', 'wesper')
	        )
	    )
	);

	$wp_customize->add_setting(
	    'footer_logo',
	    array(
	        'default'    =>  esc_attr__( 'logo_foot_white', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'footer_logo',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Footer logo','wesper'),
	        'type'      => 'select',
	        'choices'	=> array(
	        'logo_foot_white' => esc_html__('Footer dark mode logo', 'wesper'),
			'logo_foot_normal' => esc_html__('Footer normal logo', 'wesper')			
	        )
	    )
	);

	$wp_customize->add_setting(
	    'jl_copyright',
	    array(
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'jl_copyright',
	    array(
	        'section'   => 'wesper_footer_setting',
	        'label'     => esc_html__('Footer copyright','wesper'),
	        'type'      => 'textarea'
	    )
	);


/*Advertisement*/
$wp_customize->add_section(
	'wesper_ads_setting',
	array(
		'title'     => esc_html__('Advertisement Settings', 'wesper'),
		'priority'  => 1,
		'panel' => 'wesper_theme_options'
	)
);

/*header above*/
$wp_customize->add_setting(
'wesper_opt_ads_head_above',
array(
	'default'     => '',
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
new wesper_Customize_Control_Title (
	$wp_customize,
	'wesper_opt_ads_head_above',
	array(
		'label'         => esc_html__( 'Header Above Ads Settings', 'wesper' ),		
		'section'       => 'wesper_ads_setting',
		'settings'      => 'wesper_opt_ads_head_above',
	)
)
);

$wp_customize->add_setting(
'home_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'home_hide_head_above',
array(
	'section'   => 'wesper_ads_setting',
	'label'     => esc_html__('Hide on home page','wesper'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'archives_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'archives_hide_head_above',
array(
	'section'   => 'wesper_ads_setting',
	'label'     => esc_html__('Hide on archives page','wesper'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'pages_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'pages_hide_head_above',
array(
	'section'   => 'wesper_ads_setting',
	'label'     => esc_html__('Hide on pages','wesper'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'posts_hide_head_above',
array(
	'default' => false,
	'transport' => 'refresh',
	'sanitize_callback' => 'sanitize_text_field',
)
);
$wp_customize->add_control(
'posts_hide_head_above',
array(
	'section'   => 'wesper_ads_setting',
	'label'     => esc_html__('Hide on posts','wesper'),
	'type'      => 'checkbox'
)
);

$wp_customize->add_setting(
'wesper_ads_head_above',
array(
	'default'    =>  '',
	'transport'  =>  'refresh',
	'sanitize_callback' => 'wp_kses_post',
)
);
$wp_customize->add_control(
'wesper_ads_head_above',
array(
	'section'   => 'wesper_ads_setting',
	'label'     => esc_html__('Header Above Ads','wesper'),
	'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
	'type'      => 'textarea'
)
);

/*header below*/
$wp_customize->add_setting(
	'wesper_opt_ads_head_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_head_below',
		array(
			'label'         => esc_html__( 'Header Below Ads Settings', 'wesper' ),			
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_head_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'home_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'home_hide_head_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on home page','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'archives_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'archives_hide_head_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on archives page','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'pages_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'pages_hide_head_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on pages','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'posts_hide_head_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'posts_hide_head_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on posts','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_head_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_head_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Header Below Ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);

	/*footer above*/
$wp_customize->add_setting(
	'wesper_opt_ads_footer_above',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_footer_above',
		array(
			'label'         => esc_html__( 'Footer Above Ads Settings', 'wesper' ),			
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_footer_above',
		)
	)
	);
	
	$wp_customize->add_setting(
	'home_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'home_hide_footer_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on home page','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'archives_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'archives_hide_footer_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on archives page','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'pages_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'pages_hide_footer_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on pages','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'posts_hide_footer_above',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'posts_hide_footer_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on posts','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_footer_above',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_footer_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Footer Above Ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);

	
	/*footer below*/
$wp_customize->add_setting(
	'wesper_opt_ads_footer_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_footer_below',
		array(
			'label'         => esc_html__( 'Footer Below Ads Settings', 'wesper' ),			
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_footer_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'home_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'home_hide_footer_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on home page','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'archives_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'archives_hide_footer_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on archives page','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'pages_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'pages_hide_footer_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on pages','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'posts_hide_footer_below',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	'posts_hide_footer_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Hide on posts','wesper'),
		'type'      => 'checkbox'
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_footer_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_footer_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Footer Below Ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);

	/*single post above content*/
$wp_customize->add_setting(
	'wesper_opt_ads_single_content_above',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_single_content_above',
		array(
			'label'         => esc_html__( 'Single post above content', 'wesper' ),
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_single_content_above',
		)
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_single_content_above',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_single_content_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Single post above content ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);

/*single post below content*/
$wp_customize->add_setting(
	'wesper_opt_ads_single_content_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_single_content_below',
		array(
			'label'         => esc_html__( 'Single post below content', 'wesper' ),
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_single_content_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_single_content_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_single_content_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Single post below content ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);
		
/*single post above author*/
$wp_customize->add_setting(
	'wesper_opt_ads_single_author_above',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_single_author_above',
		array(
			'label'         => esc_html__( 'Single post above author', 'wesper' ),
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_single_author_above',
		)
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_single_author_above',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_single_author_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Single post above author ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);

/*single post below author*/
$wp_customize->add_setting(
	'wesper_opt_ads_single_author_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_single_author_below',
		array(
			'label'         => esc_html__( 'Single post below author', 'wesper' ),
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_single_author_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_single_author_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_single_author_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Single post below author ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);

	/*single post above related*/
$wp_customize->add_setting(
	'wesper_opt_ads_single_related_above',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_single_related_above',
		array(
			'label'         => esc_html__( 'Single post above related post', 'wesper' ),
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_single_related_above',
		)
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_single_related_above',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_single_related_above',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Single post above related ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);
	

	/*single post below related*/
$wp_customize->add_setting(
	'wesper_opt_ads_single_related_below',
	array(
		'default'     => '',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
	);
	$wp_customize->add_control(
	new wesper_Customize_Control_Title (
		$wp_customize,
		'wesper_opt_ads_single_related_below',
		array(
			'label'         => esc_html__( 'Single post below related post', 'wesper' ),
			'section'       => 'wesper_ads_setting',
			'settings'      => 'wesper_opt_ads_single_related_below',
		)
	)
	);
	
	$wp_customize->add_setting(
	'wesper_ads_single_related_below',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
	);
	$wp_customize->add_control(
	'wesper_ads_single_related_below',
	array(
		'section'   => 'wesper_ads_setting',
		'label'     => esc_html__('Single post below related ads','wesper'),
		'description' => esc_html__( 'Only shortcodes[]/HTML code is allowed here','wesper'),
		'type'      => 'textarea'
	)
	);

	/*Cookie*/
	$wp_customize->add_section(
		    'wesper_cookie_setting',
		    array(
		        'title'     => esc_html__('Cookie Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'jl_cookie_enable',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_cookie_enable',
        array(
            'section'   => 'wesper_cookie_setting',
            'label'     => esc_html__('Enable Cookie','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'jl_cookie_dec',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'wp_kses_post',
	    )
	);
	$wp_customize->add_control(
	    'jl_cookie_dec',
	    array(
	        'section'   => 'wesper_cookie_setting',
	        'label'     => esc_html__('Cookie description','wesper'),
	        'type'      => 'textarea'
	    )
	);
	$wp_customize->add_setting(
	    'jl_cookie_btn',
	    array(
	        'default'    =>  esc_attr__( 'Accept', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_cookie_btn',
	    array(
	        'section'   => 'wesper_cookie_setting',
	        'label'     => esc_html__('Cookie button','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_cookie_dec_size',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_cookie_dec_size',
	    array(
	        'section'   => 'wesper_cookie_setting',
	        'label'     => esc_html__('Cookie font size Ex: 12px;','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_cookie_btn_size',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_cookie_btn_size',
	    array(
	        'section'   => 'wesper_cookie_setting',
	        'label'     => esc_html__('Cookie button font size Ex: 12px;','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_cookie_btn_space',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_cookie_btn_space',
	    array(
	        'section'   => 'wesper_cookie_setting',
	        'label'     => esc_html__('Cookie button letter spacing Ex: 1px;','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_cookie_btn_tranform',
	    array(
	        'default'    =>  esc_attr__( 'capitalize', 'wesper' ),
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_cookie_btn_tranform',
	    array(
	        'section'   => 'wesper_cookie_setting',
	        'label'     => esc_html__('Cookie button transform','wesper'),
	        'type'      => 'select',
	        'choices' 	=> array(
	        	'none' => esc_html__('None', 'wesper'),
	        	'capitalize' => esc_html__('Capitalize', 'wesper'),
	        	'uppercase' => esc_html__('Uppercase', 'wesper')
	        )
	    )
	);

/*Optimize / SEO*/
	$wp_customize->add_section(
		    'wesper_optimize_setting',
		    array(
		        'title'     => esc_html__('Optimize / SEO Settings', 'wesper'),
		        'priority'  => 1,
		        'panel' => 'wesper_theme_options'
		    )
	);

	$wp_customize->add_setting(
        'jl_opt_google_font',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_google_font',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Preload Google Fonts','wesper'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'jl_opt_font_icons',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_font_icons',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Preload Font Icon','wesper'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'jl_opt_dashicons',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_dashicons',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Disable Dashicons','wesper'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'jl_opt_polyfill',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_polyfill',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Disable Polyfill','wesper'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'jl_opt_woo_block',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_woo_block',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Disable WooCommerce Block Style','wesper'),
            'type'      => 'checkbox'
        )
    );

    $wp_customize->add_setting(
        'jl_opt_gutenberg',
        array(
            'default' => true,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_gutenberg',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Disable Gutenberg Style','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'jl_opt_lazy_img',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_lazy_img',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Disable lazy load images','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'wesper_seo_sec_options',
        array(
            'default'     => '',
            'transport'   => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new wesper_Customize_Control_Title (
            $wp_customize,
            'wesper_seo_sec_options',
            array(
                'label'         => esc_html__( 'SEO', 'wesper' ),
                'section'       => 'wesper_optimize_setting',
                'settings'      => 'wesper_seo_sec_options',
            )
        )
    );

	$wp_customize->add_setting(
        'jl_opt_h1_home',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_h1_home',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Disable H1 logo','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
        'jl_opt_seo',
        array(
            'default' => false,
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'jl_opt_seo',
        array(
            'section'   => 'wesper_optimize_setting',
            'label'     => esc_html__('Disable Open Graph Meta','wesper'),
            'type'      => 'checkbox'
        )
    );

	$wp_customize->add_setting(
	    'jl_seo_twiter_name',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_seo_twiter_name',
	    array(
	        'section'   => 'wesper_optimize_setting',
	        'label'     => esc_html__('SEO Twiter creator name','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_seo_twiter_label',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_seo_twiter_label',
	    array(
	        'section'   => 'wesper_optimize_setting',
	        'label'     => esc_html__('SEO Twiter label','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
	    'jl_seo_fb_app_id',
	    array(
	        'default'    =>  '',
	        'transport'  =>  'refresh',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'jl_seo_fb_app_id',
	    array(
	        'section'   => 'wesper_optimize_setting',
	        'label'     => esc_html__('Facebook APP ID','wesper'),
	        'type'      => 'text'
	    )
	);

	$wp_customize->add_setting(
		'wesper_seo_img',
		array(
		'default' 			=> '',
		'transport'   		=> 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control(
			new WP_Customize_Image_Control(
			$wp_customize,
			'wesper_seo_img',
			array(
			'label'    => esc_html__( 'Fallback Open Graph Image', 'wesper' ),
			'section'  => 'wesper_optimize_setting',
			'settings' => 'wesper_seo_img'
		)));


/*AMP*/
$wp_customize->add_section(
	'wesper_amp_setting',
	array(
		'title'     => esc_html__('AMP Settings', 'wesper'),
		'priority'  => 1,
		'panel' => 'wesper_theme_options'
	)
);

$wp_customize->add_setting(
'amp_head_logo',
array(
'default' 			=> '',
'transport'   		=> 'refresh',
'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control(
new WP_Customize_Image_Control(
$wp_customize,
'amp_head_logo',
array(
'label'    => esc_html__( 'Header logo', 'wesper' ),
'section'  => 'wesper_amp_setting',
'settings' => 'amp_head_logo'
)));

$wp_customize->add_setting(
'amp_foot_logo',
array(
'default' 			=> '',
'transport'   		=> 'refresh',
'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control(
new WP_Customize_Image_Control(
$wp_customize,
'amp_foot_logo',
array(
'label'    => esc_html__( 'Footer logo', 'wesper' ),
'section'  => 'wesper_amp_setting',
'settings' => 'amp_foot_logo'
)));

$wp_customize->add_setting(
	'amp_head_logo_width',
	array(
		'default'    =>  esc_attr__( '100px', 'wesper' ),
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'amp_head_logo_width',
	array(
		'section'   => 'wesper_amp_setting',
		'label'     => esc_html__('Logo width EX: 100px','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'amp_footer_logo_width',
	array(
		'default'    =>  esc_attr__( '150px', 'wesper' ),
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'amp_footer_logo_width',
	array(
		'section'   => 'wesper_amp_setting',
		'label'     => esc_html__('Footer logo width EX: 100px','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
'amp_head_bg',
array(
	'default'    =>  esc_attr__( '#000', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_head_bg',
	array(
		'label'      => esc_html__( 'Header background color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_head_bg'
	)
)
);

$wp_customize->add_setting(
'amp_head_color',
array(
	'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_head_color',
	array(
		'label'      => esc_html__( 'Header color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_head_color'
	)
)
);

$wp_customize->add_setting(
'amp_content_bg',
array(
	'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_content_bg',
	array(
		'label'      => esc_html__( 'Contetn background color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_content_bg'
	)
)
);

$wp_customize->add_setting(
'amp_content_color',
array(
	'default'    =>  esc_attr__( '#000', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_content_color',
	array(
		'label'      => esc_html__( 'Contetn color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_content_color'
	)
)
);

$wp_customize->add_setting(
'amp_content_link',
array(
	'default'    =>  esc_attr__( '#f00', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_content_link',
	array(
		'label'      => esc_html__( 'Content link color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_content_link'
	)
)
);

$wp_customize->add_setting(
'amp_footer_bg',
array(
	'default'    =>  esc_attr__( '#000', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_footer_bg',
	array(
		'label'      => esc_html__( 'Footer background color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_footer_bg'
	)
)
);

$wp_customize->add_setting(
'amp_footer_color',
array(
	'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_footer_color',
	array(
		'label'      => esc_html__( 'Footer color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_footer_color'
	)
)
);

$wp_customize->add_setting(
'amp_footer_link',
array(
	'default'    =>  esc_attr__( '#f00', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_footer_link',
	array(
		'label'      => esc_html__( 'Footer link color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_footer_link'
	)
)
);

$wp_customize->add_setting(
'amp_sidebar_bg',
array(
	'default'    =>  esc_attr__( '#111', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_sidebar_bg',
	array(
		'label'      => esc_html__( 'Sidebar background color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_sidebar_bg'
	)
)
);

$wp_customize->add_setting(
'amp_sidebar_color',
array(
	'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_sidebar_color',
	array(
		'label'      => esc_html__( 'Sidebar color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_sidebar_color'
	)
)
);

$wp_customize->add_setting(
'amp_sidebar_link',
array(
	'default'    =>  esc_attr__( '#FFF', 'wesper' ),
	'transport'   => 'refresh',
	'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(
new WP_Customize_Color_Control(
	$wp_customize,
	'amp_sidebar_link',
	array(
		'label'      => esc_html__( 'Sidebar link color', 'wesper' ),
		'section'    => 'wesper_amp_setting',
		'settings'   => 'amp_sidebar_link'
	)
)
);

$wp_customize->add_setting(
	'hide_amp_related',
	array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'hide_amp_related',
	array(
		'section'   => 'wesper_amp_setting',
		'label'     => esc_html__('Hide related posts','wesper'),
		'type'      => 'checkbox'
	)
);

$wp_customize->add_setting(
	'amp_copyright',
	array(
		'transport'  =>  'refresh',
		'sanitize_callback' => 'wp_kses_post',
	)
);
$wp_customize->add_control(
	'amp_copyright',
	array(
		'section'   => 'wesper_amp_setting',
		'label'     => esc_html__('Footer copyright','wesper'),
		'type'      => 'textarea'
	)
);


/*Theme string*/
$wp_customize->add_section(
	'wesper_string_setting',
	array(
		'title'     => esc_html__('Theme Strings', 'wesper'),
		'priority'  => 1,
		'panel' => 'wesper_theme_options'
	)
);

$wp_customize->add_setting(
	'wesper_s_home',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_home',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Home','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_load_more',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_load_more',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Load More','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_by',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_by',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('By','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_mins_read',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_mins_read',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Mins read','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_views',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_views',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Views','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_previous_post',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_previous_post',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Previous post','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_next_post',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_next_post',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Next post','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_via',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_via',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Via','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_soruce',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_soruce',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Sources','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_summary',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_summary',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Summary','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_the_pros',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_the_pros',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('The Pros','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_the_cons',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_the_cons',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('The Cons','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_share',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_share',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Share','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_tweet',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_tweet',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Tweet','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_pin',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_pin',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Pin','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_written_by',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_written_by',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Written by','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_comments',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_comments',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Comments','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_comment',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_comment',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Comment','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_old_comment',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_old_comment',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Older Comments','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_new_comment',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_new_comment',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Newer Comments','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_comment_closed',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_comment_closed',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Comments are closed','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_leave_a_comment',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_leave_a_comment',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Leave a comment','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_your_name',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_your_name',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Your name','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_your_email',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_your_email',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Your email','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_your_website',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_your_website',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Your Website','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_related_articles',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_related_articles',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Related Articles','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_type_to_search',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_type_to_search',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Type to search...','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_articles',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_articles',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Articles','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_search_result_for',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_search_result_for',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Search Result for','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_404_title',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_404_title',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Oops! This page can’t be found','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_404_desc',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_404_desc',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('The page you are looking for doesn’t exist. It may have been moved or removed. Please try searching for some other page.','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_back_to_home',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_back_to_home',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Back to Home','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_filter_products',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_filter_products',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Filter Products','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_clear_filter',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_clear_filter',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Clear filters','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_shop',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_shop',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Shop','wesper'),
		'type'      => 'text'
	)
);

$wp_customize->add_setting(
	'wesper_s_sponsored_by',
	array(
		'default'    =>  '',
		'transport'  =>  'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'wesper_s_sponsored_by',
	array(
		'section'   => 'wesper_string_setting',
		'label'     => esc_html__('Sponsored By','wesper'),
		'type'      => 'text'
	)
);


$wp_customize->remove_section( 'colors' );
$wp_customize->remove_section( 'background_image' );
}
add_action( 'customize_register', 'wesper_register_theme_customizer', 110 );
