<?php
// Logo
$logo_width = get_theme_mod('logo_width','150px');
$m_logo_width = get_theme_mod('m_logo_width','120px');
$s_logo_width = get_theme_mod('s_logo_width','150px');
$foot_logo_width = get_theme_mod('foot_logo_width','150px');

// Header
$section_top_bar_height = get_theme_mod('section_top_bar_height','35px');
$section_logo_height = get_theme_mod('section_logo_height','80px');
$section_menu_height = get_theme_mod('section_menu_height','70px');

//Menu
$wesper_menu_font_family = get_theme_mod('wesper_menu_font_family', 'Inter Tight');
$wesper_menu_font_size = get_theme_mod('wesper_menu_font_size', '16px');
$wesper_menu_font_weight = get_theme_mod('wesper_menu_font_weight', '700');
$wesper_menu_transform = get_theme_mod('wesper_menu_transform', 'capitalize');
$letter_spacing_menu = get_theme_mod('letter_spacing_menu', '0em');
$spacing_menu = get_theme_mod('spacing_menu', '30px');

//Sub Menu
$wesper_sub_menu_font_size = get_theme_mod('wesper_sub_menu_font_size', '14px');
$wesper_sub_menu_font_weight = get_theme_mod('wesper_sub_menu_font_weight', '500');
$sub_menu_transform = get_theme_mod('sub_menu_transform', 'capitalize');
$sub_spacing_menu = get_theme_mod('sub_spacing_menu', '0em');

//Paragraph
$wesper_p_font_family = get_theme_mod('wesper_p_font_family', 'Inter');
$wesper_p_font_size = get_theme_mod('wesper_p_font_size', '16px');
$wesper_p_font_weight = get_theme_mod('wesper_p_font_weight', '400');
$p_line_height = get_theme_mod('p_line_height', '1.8');
$body_font_size = get_theme_mod('body_font_size', '15px');
$body_line_height = get_theme_mod('body_line_height', '1.5');

//Title
$wesper_title_font_family = get_theme_mod('wesper_title_font_family', 'Inter Tight');
$wesper_title_font_weight = get_theme_mod('wesper_title_font_weight', '800');
$wesper_title_transform = get_theme_mod('wesper_title_transform', 'none');
$letter_spacing_heading = get_theme_mod('letter_spacing_heading', '0em');
$line_height_heading = get_theme_mod('line_height_heading', '1.2');

//Catgory, Meta, Button
$wesper_cat_font_size    = get_theme_mod('wesper_cat_font_size', '15px');
$wesper_cat_font_weight = get_theme_mod('wesper_cat_font_weight', '700');
$wesper_cat_transform	= get_theme_mod('wesper_cat_transform', 'capitalize');
$letter_spacing_cat 	= get_theme_mod('letter_spacing_cat', '0em');
$wesper_meta_font_size 	= get_theme_mod('wesper_meta_font_size', '11px');
$wesper_meta_font_weight = get_theme_mod('wesper_meta_font_weight', '400');
$wesper_meta_a_font_weight = get_theme_mod('wesper_meta_a_font_weight', '600');
$wesper_meta_transform     = get_theme_mod('wesper_meta_transform', 'uppercase');
$letter_spacing_meta     = get_theme_mod('letter_spacing_meta', '.04em');

// Button setting
$wesper_button_font_size = get_theme_mod('wesper_button_font_size', '12px');
$wesper_button_font_weight = get_theme_mod('wesper_button_font_weight', '700');
$wesper_button_transform = get_theme_mod('wesper_button_transform', 'uppercase');
$letter_spacing_button = get_theme_mod('letter_spacing_button', '0.1em');
$button_radius = get_theme_mod('button_radius', '4px');

// Load more setting
$wesper_loadmore_font_size = get_theme_mod('wesper_loadmore_font_size', '12px');
$wesper_loadmore_font_weight = get_theme_mod('wesper_loadmore_font_weight', '700');
$wesper_loadmore_transform = get_theme_mod('wesper_loadmore_transform', 'uppercase');
$letter_spacing_loadmore = get_theme_mod('letter_spacing_loadmore', '0.1em');
$load_more_radius = get_theme_mod('load_more_radius', '4px');

// Other blog
$border_rounded = get_theme_mod('border_rounded', '0px');
$top_border_rounded = get_theme_mod('top_border_rounded', '60px');
$single_title_size = get_theme_mod('single_title_size', '40px');
$wesper_related_size = get_theme_mod('wesper_related_size', '20px');

//cookie
$jl_cookie_dec_size = get_theme_mod('jl_cookie_dec_size', '13px');
$jl_cookie_btn_size = get_theme_mod('jl_cookie_btn_size', '12px');
$jl_cookie_btn_space = get_theme_mod('jl_cookie_btn_space', '0em');
$jl_cookie_btn_tranform = get_theme_mod('jl_cookie_btn_tranform', 'capitalize');

// Theme color
$theme_color = get_theme_mod('theme_color');
if(empty($theme_color)){$theme_color = '#f21717';}

$theme_color_dark = get_theme_mod('theme_color_dark');
if(empty($theme_color_dark)){$theme_color_dark = '#f21717';}

$theme_bg_color = get_theme_mod('theme_bg_color');
if(empty($theme_bg_color)){$theme_bg_color = '#FFF';}

$theme_bg_color_dark = get_theme_mod('theme_bg_color_dark');
if(empty($theme_bg_color_dark)){$theme_bg_color_dark = '#111';}

$theme_text_color = get_theme_mod('theme_text_color');
if(empty($theme_text_color)){$theme_text_color = '#000';}

$theme_text_color_dark = get_theme_mod('theme_text_color_dark');
if(empty($theme_text_color_dark)){$theme_text_color_dark = '#FFF';}

// Menu color
$menu_bg_color = get_theme_mod('menu_bg_color');
if(empty($menu_bg_color)){ $menu_bg_color = '#FFF';}

$menu_bg_color_dark = get_theme_mod('menu_bg_color_dark');
if(empty($menu_bg_color_dark)){ $menu_bg_color_dark = '#111';}

$menu_text_color = get_theme_mod('menu_text_color');
if(empty($menu_text_color)){ $menu_text_color = '#000';}

$menu_text_color_dark = get_theme_mod('menu_text_color_dark');
if(empty($menu_text_color_dark)){ $menu_text_color_dark = '#FFF';}

$submenu_back_color = get_theme_mod('submenu_back_color');
if(empty($submenu_back_color)){ $submenu_back_color = '#f7f7f6';}

$submenu_back_color_dark = get_theme_mod('submenu_back_color_dark');
if(empty($submenu_back_color_dark)){ $submenu_back_color_dark = '#222';}

$submenu_text_color = get_theme_mod('submenu_text_color');
if(empty($submenu_text_color)){ $submenu_text_color = '#000';}

$submenu_text_color_dark = get_theme_mod('submenu_text_color_dark');
if(empty($submenu_text_color_dark)){ $submenu_text_color_dark = '#FFF';}

$menu_line_color = get_theme_mod('menu_line_color');
if(empty($menu_line_color)){ $menu_line_color = '#eeedeb';}

$menu_line_color_dark = get_theme_mod('menu_line_color_dark');
if(empty($menu_line_color_dark)){ $menu_line_color_dark = '#ffffff26';}

$submenu_line_color = get_theme_mod('submenu_line_color');
if(empty($submenu_line_color)){ $submenu_line_color = '#ebebe3';}

$submenu_line_color_dark = get_theme_mod('submenu_line_color_dark');
if(empty($submenu_line_color_dark)){ $submenu_line_color_dark = '#464646';}

// Top menu color
$top_menu_bg_color = get_theme_mod('top_menu_bg_color');
if(empty($top_menu_bg_color)){ $top_menu_bg_color = '#000';}

$top_menu_text_color = get_theme_mod('top_menu_text_color');
if(empty($top_menu_text_color)){ $top_menu_text_color = '#FFF';}

$top_menu_bg_color_dark = get_theme_mod('top_menu_bg_color_dark');
if(empty($top_menu_bg_color_dark)){ $top_menu_bg_color_dark = '#000';}

$top_menu_text_color_dark = get_theme_mod('top_menu_text_color_dark');
if(empty($top_menu_text_color_dark)){ $top_menu_text_color_dark = '#FFF';}

$section_top_bar_height = get_theme_mod('section_top_bar_height','35px');
$section_top_bar_size = get_theme_mod('section_top_bar_size','15px');

// Single color
$single_color = get_theme_mod('single_color');
if(empty($single_color)){$single_color = '#676767';}

$single_color_dark = get_theme_mod('single_color_dark');
if(empty($single_color_dark)){$single_color_dark = '#FFF';}

$single_link_color = get_theme_mod('single_link_color');
if(empty($single_link_color)){$single_link_color = '#f21717';}

$single_link_color_dark = get_theme_mod('single_link_color_dark');
if(empty($single_link_color_dark)){$single_link_color_dark = '#f21717';}

$single_link_hover_color = get_theme_mod('single_link_hover_color');
if(empty($single_link_hover_color)){$single_link_hover_color = '#f21717';}

$single_link_hover_color_dark = get_theme_mod('single_link_hover_color_dark');
if(empty($single_link_hover_color_dark)){$single_link_hover_color_dark = '#f21717';}

$post_meta_color = get_theme_mod('post_meta_color');
if(empty($post_meta_color)){$post_meta_color = '#0a0a0a';}

$post_meta_color_dark = get_theme_mod('post_meta_color_dark');
if(empty($post_meta_color_dark)){$post_meta_color_dark = '#bbb';}

$post_except_color = get_theme_mod('post_except_color');
if(empty($post_except_color)){$post_except_color = '#666';}

$post_except_color_dark = get_theme_mod('post_except_color_dark');
if(empty($post_except_color_dark)){$post_except_color_dark = '#ddd';}

$post_line_color = get_theme_mod('post_line_color');
if(empty($post_line_color)){$post_line_color = '#dbdbdb';}

$post_line_color_dark = get_theme_mod('post_line_color_dark');
if(empty($post_line_color_dark)){$post_line_color_dark = '#49494b';}

// Footer color
$footer_bg_color = get_theme_mod('footer_bg_color');
if(empty($footer_bg_color)){$footer_bg_color = '#111';}

$footer_bg_dark = get_theme_mod('footer_bg_dark');
if(empty($footer_bg_dark)){$footer_bg_dark = '#000';}

$footer_text_color = get_theme_mod('footer_text_color');
if(empty($footer_text_color)){$footer_text_color = '#a8a8aa';}

$footer_text_dark = get_theme_mod('footer_text_dark');
if(empty($footer_text_dark)){$footer_text_dark = '#a8a8aa';}

$footer_link_color = get_theme_mod('footer_link_color');
if(empty($footer_link_color)){$footer_link_color = '#dcdcdc';}

$footer_link_dark = get_theme_mod('footer_link_dark');
if(empty($footer_link_dark)){$footer_link_dark = '#dcdcdc';}

$footer_link_hcolor = get_theme_mod('footer_link_hcolor');
if(empty($footer_link_hcolor)){$footer_link_hcolor = '#f21717';}

$footer_link_hdark = get_theme_mod('footer_link_hdark');
if(empty($footer_link_hdark)){$footer_link_hdark = '#f21717';}

$footer_head_color = get_theme_mod('footer_head_color');
if(empty($footer_head_color)){$footer_head_color = '#FFF';}

$footer_head_color_dark = get_theme_mod('footer_head_color_dark');
if(empty($footer_head_color_dark)){$footer_head_color_dark = '#FFF';}

$footer_line_color = get_theme_mod('footer_line_color');
if(empty($footer_line_color)){$footer_line_color = '#49494b';}

$footer_line_color_dark = get_theme_mod('footer_line_color_dark');
if(empty($footer_line_color_dark)){$footer_line_color_dark = '#49494b';}
?>
body.options_dark_skin{
    --jl-main-color: <?php echo esc_attr($theme_color_dark);?>;
    --jl-bg-color: <?php echo esc_attr($theme_bg_color_dark);?>;
    --jl-txt-color: <?php echo esc_attr($theme_text_color_dark);?>;
    --jl-btn-bg: #454545;
    --jl-comment-btn-link: #454545;
    --jl-comment-btn-linkc: #FFF;
    
    --jl-menu-bg: <?php echo esc_attr($menu_bg_color_dark);?>;
    --jl-menu-line-color: <?php echo esc_attr($menu_line_color_dark);?>;
    --jl-menu-color: <?php echo esc_attr($menu_text_color_dark);?>;
    --jl-sub-bg-color: <?php echo esc_attr($submenu_back_color_dark);?>;
    --jl-sub-menu-color: <?php echo esc_attr($submenu_text_color_dark);?>;
    --jl-sub-line-color: <?php echo esc_attr($submenu_line_color_dark);?>;
    --jl-topbar-bg: <?php echo esc_attr($top_menu_bg_color_dark);?>;
    --jl-topbar-color: <?php echo esc_attr($top_menu_text_color_dark);?>;

    --jl-single-color: <?php echo esc_attr($single_color_dark);?>;
    --jl-single-link-color: <?php echo esc_attr($single_link_color_dark);?>;
    --jl-single-link-hcolor: <?php echo esc_attr($single_link_hover_color_dark);?>;
    --jl-except-color: <?php echo esc_attr($post_except_color_dark);?>;
    --jl-meta-color: <?php echo esc_attr($post_except_color_dark);?>;
    --jl-post-line-color: <?php echo esc_attr($post_line_color_dark);?>;
    --jl-author-bg: #454545;

    --jl-foot-bg: <?php echo esc_attr($footer_bg_dark);?>;
    --jl-foot-color: <?php echo esc_attr($footer_text_dark);?>;
    --jl-foot-link: <?php echo esc_attr($footer_link_dark);?>;
    --jl-foot-hlink: <?php echo esc_attr($footer_link_hdark);?>;
    --jl-foot-head: <?php echo esc_attr($footer_head_color_dark);?>;
    --jl-foot-line: <?php echo esc_attr($footer_line_color_dark);?>;

}
body{
    --jl-main-color: <?php echo esc_attr($theme_color);?>;
    --jl-bg-color: <?php echo esc_attr($theme_bg_color);?>;
    --jl-txt-color: <?php echo esc_attr($theme_text_color);?>;
    --jl-txt-light: <?php echo esc_attr($theme_text_color_dark);?>;
    --jl-btn-bg: #000;
    --jl-comment-btn-link: #F1F1F1;
    --jl-comment-btn-linkc: #000;
    --jl-desc-light: <?php echo esc_attr($post_except_color_dark);?>;
    --jl-meta-light: <?php echo esc_attr($post_meta_color_dark);?>;

    --jl-button-radius: <?php echo esc_attr($button_radius);?>;
    --jl-load-more-radius: <?php echo esc_attr($load_more_radius);?>;

    --jl-menu-bg: <?php echo esc_attr($menu_bg_color);?>;
    --jl-menu-line-color: <?php echo esc_attr($menu_line_color);?>;
    --jl-menu-color: <?php echo esc_attr($menu_text_color);?>;
    --jl-sub-bg-color: <?php echo esc_attr($submenu_back_color);?>;
    --jl-sub-menu-color: <?php echo esc_attr($submenu_text_color);?>;
    --jl-sub-line-color: <?php echo esc_attr($submenu_line_color);?>;

    --jl-topbar-bg: <?php echo esc_attr($top_menu_bg_color);?>;
    --jl-topbar-color: <?php echo esc_attr($top_menu_text_color);?>;
    --jl-topbar-height: <?php echo esc_attr($section_top_bar_height);?>;
    --jl-topbar-size: <?php echo esc_attr($section_top_bar_size);?>;

    --jl-single-title-size: <?php echo esc_attr($single_title_size);?>;
    --jl-single-color: <?php echo esc_attr($single_color);?>;
    --jl-single-link-color: <?php echo esc_attr($single_link_color);?>;
    --jl-single-link-hcolor: <?php echo esc_attr($single_link_hover_color);?>;
    --jl-except-color: <?php echo esc_attr($post_except_color);?>;
    --jl-meta-color: <?php echo esc_attr($post_meta_color);?>;
    --jl-post-line-color: <?php echo esc_attr($post_line_color);?>;
    --jl-author-bg: #f8f7f5;
    --jl-post-related-size: <?php echo esc_attr($wesper_related_size);?>;

    --jl-foot-bg: <?php echo esc_attr($footer_bg_color);?>;
    --jl-foot-color: <?php echo esc_attr($footer_text_color);?>;
    --jl-foot-link: <?php echo esc_attr($footer_link_color);?>;
    --jl-foot-hlink: <?php echo esc_attr($footer_link_hcolor);?>;
    --jl-foot-head: <?php echo esc_attr($footer_head_color);?>;
    --jl-foot-line: <?php echo esc_attr($footer_line_color);?>;    

    --jl-body-font: <?php echo esc_attr($wesper_p_font_family);?>;
    --jl-body-font-size: <?php echo esc_attr($body_font_size);?>;
    --jl-body-font-weight: <?php echo esc_attr($wesper_p_font_weight);?>;
    --jl-body-line-height: <?php echo esc_attr($body_line_height);?>;
    --jl-logo-width: <?php echo esc_attr($logo_width);?>;
    --jl-m-logo-width: <?php echo esc_attr($m_logo_width);?>;
    --jl-s-logo-width: <?php echo esc_attr($s_logo_width);?>;
    --jl-title-font: <?php echo esc_attr($wesper_title_font_family);?>;
    --jl-title-font-weight: <?php echo esc_attr($wesper_title_font_weight);?>;
    --jl-title-transform: <?php echo esc_attr($wesper_title_transform);?>;
    --jl-title-space: <?php echo esc_attr($letter_spacing_heading);?>;
    --jl-title-line-height: <?php echo esc_attr($line_height_heading);?>;
    --jl-content-font-size: <?php echo esc_attr($wesper_p_font_size);?>;
    --jl-content-line-height: <?php echo esc_attr($p_line_height);?>;
    --jl-sec-topbar-height: <?php echo esc_attr($section_top_bar_height);?>;
    --jl-sec-menu-height: <?php echo esc_attr($section_menu_height);?>;
    --jl-sec-logo-height: <?php echo esc_attr($section_logo_height);?>;
    --jl-menu-font: <?php echo esc_attr($wesper_menu_font_family);?>;
    --jl-menu-font-size: <?php echo esc_attr($wesper_menu_font_size);?>;
    --jl-menu-font-weight: <?php echo esc_attr($wesper_menu_font_weight);?>;
    --jl-menu-transform: <?php echo esc_attr($wesper_menu_transform);?>;
    --jl-menu-space: <?php echo esc_attr($letter_spacing_menu);?>;
    --jl-spacing-menu: <?php echo esc_attr($spacing_menu);?>;
    --jl-submenu-font-size: <?php echo esc_attr($wesper_sub_menu_font_size);?>;
    --jl-submenu-font-weight: <?php echo esc_attr($wesper_sub_menu_font_weight);?>;
    --jl-submenu-transform: <?php echo esc_attr($sub_menu_transform);?>;
    --jl-submenu-space: <?php echo esc_attr($sub_spacing_menu);?>;
    --jl-cat-font-size: <?php echo esc_attr($wesper_cat_font_size);?>;
    --jl-cat-font-weight: <?php echo esc_attr($wesper_cat_font_weight);?>;
    --jl-cat-font-space: <?php echo esc_attr($letter_spacing_cat);?>;
    --jl-cat-transform: <?php echo esc_attr($wesper_cat_transform);?>;
    --jl-meta-font-size: <?php echo esc_attr($wesper_meta_font_size);?>;
    --jl-meta-font-weight: <?php echo esc_attr($wesper_meta_font_weight);?>;
    --jl-meta-a-font-weight: <?php echo esc_attr($wesper_meta_a_font_weight);?>;
    --jl-meta-font-space: <?php echo esc_attr($letter_spacing_meta);?>;
    --jl-meta-transform: <?php echo esc_attr($wesper_meta_transform);?>;
    --jl-button-font-size: <?php echo esc_attr($wesper_button_font_size);?>;
    --jl-button-font-weight: <?php echo esc_attr($wesper_button_font_weight);?>;
    --jl-button-transform: <?php echo esc_attr($wesper_button_transform);?>;
    --jl-button-space: <?php echo esc_attr($letter_spacing_button);?>;
    --jl-loadmore-font-size: <?php echo esc_attr($wesper_loadmore_font_size);?>;
    --jl-loadmore-font-weight: <?php echo esc_attr($wesper_loadmore_font_weight);?>;
    --jl-loadmore-transform: <?php echo esc_attr($wesper_loadmore_transform);?>;
    --jl-loadmore-space: <?php echo esc_attr($letter_spacing_loadmore);?>;
    --jl-border-rounded: <?php echo esc_attr($border_rounded);?>;
    --jl-top-rounded: <?php echo esc_attr($top_border_rounded);?>;
    --jl-cookie-des-size: <?php echo esc_attr($jl_cookie_dec_size);?>;
    --jl-cookie-btn-size: <?php echo esc_attr($jl_cookie_btn_size);?>;
    --jl-cookie-btn-space: <?php echo esc_attr($jl_cookie_btn_space);?>;
    --jl-cookie-btn-transform: <?php echo esc_attr($jl_cookie_btn_tranform);?>;
}