<?php
if ( ! function_exists( 'wesper_lgrid' ) ) {
	function wesper_lgrid( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'               => '',
			'section_style'      => 'large_layout1',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',
			'layout_style'       => 'large_layout1',
			'pagination'         => '',
			'jl_hide_cat'        => '',
			'jl_hide_author'     => '',
			'jl_hide_date'       => '',
			'jl_hide_meta'       => '',
			'jl_hide_desc'       => '',
			'jl_hide_line'       => '',
			'jl_hide_review'     => '',
			'jl_cus_img'     => '',
			'ignore_sticky_posts' => '',
		), $attrs );		

		$module['style_mian']         = 'jl-main-block';
		$module['row_style_mian'] = 'jl-col-row';

		$total_posts = $module['posts_per_page'];		
		$query_data = wesper_query( $module );
		$module['posts_per_page'] = $total_posts;	
		$module['section_style'] = $module['layout_style'];

		ob_start();

		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}		
		if ( 'yes' === $module['jl_hide_cat'] ) {
			$atts_style[] = 'jl_hide_cat';
		}
		if ( 'yes' === $module['jl_hide_author'] ) {
			$atts_style[] = 'jl_hide_author';
		}
		if ( 'yes' === $module['jl_hide_date'] ) {
			$atts_style[] = 'jl_hide_date';
		}
		if ( 'yes' === $module['jl_hide_meta'] ) {
			$atts_style[] = 'jl_hide_meta';
		}
		if ( 'yes' === $module['jl_hide_desc'] ) {
			$atts_style[] = 'jl_hide_desc';
		}
		if ( 'yes' === $module['jl_hide_review'] ) {
			$atts_style[] = 'jl_hide_review';
		}
		if ( 'yes' === $module['jl_hide_line'] ) {
			$atts_style[] = 'jl_hide_line';
		}
		$atts_style = implode( ' ', $atts_style ); ?>		
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="jl_clear_at <?php echo esc_attr( $atts_style ); ?>" <?php wesper_get_ajax_attributes( $module, $query_data ); ?>>		
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'jl-roww jl_contain jl_lg_opt';
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		}
		?>
		<div class="jl_l_wrap_f jl_wrap_eb jl_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">			
			<?php			
			switch ( $module['layout_style'] ) {			
				case 'large_layout1' :
					wesper_large_layout1( $module, $query_data );
				break;
				case 'large_layout2' :
					wesper_large_layout2( $module, $query_data );
				break;
				case 'large_layout3' :
					wesper_large_layout3( $module, $query_data );
				break;			
				case 'large_layout4' :
					wesper_large_layout4( $module, $query_data );
				break;			
				case 'large_layout5' :
					wesper_large_layout5( $module, $query_data );
				break;			
			}
			echo '</div>';
			wesper_blocknav( $module, $query_data );
			echo '</div></div>';
			wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'wesper_large_layout1' ) ) :
	function wesper_large_layout1( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="jl_lg_op jl_lg_l1 jl_lasep">			
					<div class="jl_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="jl_img_holder">
						<div class="jl_imgw jl_radus_e">
							<div class="jl_imgin">
								<?php
								if ($module['jl_cus_img'] != '' ) {
									the_post_thumbnail($module['jl_cus_img']);
								}else{
									the_post_thumbnail('wesper_medium');
								}?>
							</div>
							<?php wesper_video_media(get_the_ID());?>
							<?php wesper_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="jl_imgl" aria-label="<?php the_title()?>" href="<?php the_permalink();?>"></a>
							<?php wesper_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="jl_fe_text">
							<?php wesper_post_cat(get_the_ID());?>
							<h3 class="jl_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="jl_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php wesper_post_meta(get_the_ID());?>
							<div class="jl_pl_fs">
							<?php if(get_theme_mod('disable_post_share_footer') !=1){
                                if(function_exists('wesper_slink')){
                                    echo '<div class="jl_sfoot">';
                                    wesper_slink(get_the_ID());
                                    echo '</div>';
                                }
                            }?>
							</div>
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'wesper_large_layout2' ) ) :
	function wesper_large_layout2( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="jl_lg_op jl_lg_l2 jl_lasep">			
					<div class="jl_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="jl_img_holder">
						<div class="jl_imgw jl_radus_e">
							<div class="jl_imgin">
								<?php
								if ($module['jl_cus_img'] != '' ) {
									the_post_thumbnail($module['jl_cus_img']);
								}else{
									the_post_thumbnail('wesper_medium');
								}?>
							</div>
							<?php wesper_video_media(get_the_ID());?>
							<?php wesper_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="jl_imgl" aria-label="<?php the_title()?>" href="<?php the_permalink();?>"></a>
							<?php wesper_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="jl_fe_text">
							<?php wesper_post_cat(get_the_ID());?>
							<h3 class="jl_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="jl_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php wesper_post_meta(get_the_ID());?>							
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'wesper_large_layout3' ) ) :
	function wesper_large_layout3( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="jl_lg_op jl_lg_l3 jl_lasep">			
					<div class="jl_lg_op_in">                    					
					<div class="jl_fe_text">
							<?php wesper_post_cat(get_the_ID());?>
							<h3 class="jl_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<?php wesper_post_meta(get_the_ID());?>
						</div>
						<?php if ( has_post_thumbnail()) {?>
						<div class="jl_img_holder">
						<div class="jl_imgw jl_radus_e">
							<div class="jl_imgin">
								<?php
								if ($module['jl_cus_img'] != '' ) {
									the_post_thumbnail($module['jl_cus_img']);
								}else{
									the_post_thumbnail('wesper_medium');
								}?>
							</div>
							<?php wesper_video_media(get_the_ID());?>
							<?php wesper_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="jl_imgl" aria-label="<?php the_title()?>" href="<?php the_permalink();?>"></a>
							<?php wesper_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="jl_fe_text jl_fe_txt_bot">
							<p class="jl_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 52, '...' );?> </p>							
							<?php wesper_button_txt();?>
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'wesper_large_layout4' ) ) :
	function wesper_large_layout4( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="jl_lg_op jl_lg_l4 jl_lasep">			
					<div class="jl_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="jl_img_holder">
						<div class="jl_imgw jl_radus_e">
							<div class="jl_imgin">
								<?php
								if ($module['jl_cus_img'] != '' ) {
									the_post_thumbnail($module['jl_cus_img']);
								}else{
									the_post_thumbnail('wesper_medium');
								}?>
							</div>
							<?php wesper_video_media(get_the_ID());?>
							<?php wesper_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="jl_imgl" aria-label="<?php the_title()?>" href="<?php the_permalink();?>"></a>
							<?php wesper_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="jl_fe_text">
							<?php wesper_post_cat(get_the_ID());?>
							<h3 class="jl_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="jl_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php wesper_post_meta(get_the_ID());?>							
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;

if ( ! function_exists( 'wesper_large_layout5' ) ) :
	function wesper_large_layout5( $module = array(), $query_data = null ) {		
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();?>
				<div class="jl_lg_op jl_lg_l5 jl_lasep">			
					<div class="jl_lg_op_in">                    					
						<?php if ( has_post_thumbnail()) {?>
						<div class="jl_img_holder">
						<div class="jl_imgw jl_radus_e">
							<div class="jl_imgin">
								<?php
								if ($module['jl_cus_img'] != '' ) {
									the_post_thumbnail($module['jl_cus_img']);
								}else{
									the_post_thumbnail('wesper_medium');
								}?>
							</div>
							<?php wesper_video_media(get_the_ID());?>
							<?php wesper_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							<a class="jl_imgl" aria-label="<?php the_title()?>" href="<?php the_permalink();?>"></a>
							<?php wesper_post_tumb_cat(get_the_ID());?>
						</div>
						</div>
						<?php }?>
						<div class="jl_fe_text">
							<?php wesper_post_cat(get_the_ID());?>
							<h3 class="jl_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
							<p class="jl_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 22, '...' );?> </p>
							<?php wesper_post_meta(get_the_ID());?>							
						</div>
					</div>			
				</div>
			<?php endwhile;			
		endif;
	}
endif;